/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.os;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Inchron-OS-Scheduler-Allocation-DifferentCPU", checks={"OS Task scheduler should not be allocated to more than one HwStructure"})
public class InchronOsSchedulerAllocationCheck
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getScheduler();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        EObject eObject2 = eObject;
        if (eObject2 instanceof Scheduler) {
            void sched;
            Scheduler scheduler = (Scheduler)eObject2;
            Scheduler cfr_ignored_0 = (Scheduler)eObject2;
            Set schedAllocations = AmaltheaIndex.getReferringObjects((EObject)sched, SchedulerAllocation.class);
            HashSet setPU = new HashSet();
            for (SchedulerAllocation schedAllocation : schedAllocations) {
                EList listPU = schedAllocation.getResponsibility();
                if (schedAllocation.getExecutingPU() != null) {
                    listPU.add((Object)schedAllocation.getExecutingPU());
                }
                setPU.addAll(listPU);
            }
            Set taskAllocations = AmaltheaIndex.getReferringObjects((EObject)sched, TaskAllocation.class);
            for (TaskAllocation taskAllocation : taskAllocations) {
                EList listPU = taskAllocation.getAffinity();
                setPU.addAll(listPU);
            }
            HashSet<HwStructure> setHWStruct = new HashSet<HwStructure>();
            for (ProcessingUnit PU : setPU) {
                if (!(PU.eContainer() instanceof HwStructure)) continue;
                HwStructure hwStruct = (HwStructure)PU.eContainer();
                setHWStruct.add(hwStruct);
            }
            ArrayList<String> ar = new ArrayList<String>();
            if (setHWStruct.size() > 1) {
                for (HwStructure hwStruct : setHWStruct) {
                    if (hwStruct.getName() == null) continue;
                    ar.add(hwStruct.getName());
                }
                Collections.sort(ar);
                String str = String.join((CharSequence)",", ar);
                this.addIssue(results, (EObject)sched, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), "Task Scheduler " + this.name((INamed)sched) + " allocated to more than one HwStructure: " + str);
            }
        }
    }
}

