/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.javafx;

import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueConstant;
import org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.ContinuousValueInterval;
import org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics;
import org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueConstant;
import org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram;
import org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.DiscreteValueInterval;
import org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics;
import org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeBetaDistribution;
import org.eclipse.app4mc.amalthea.model.TimeConstant;
import org.eclipse.app4mc.amalthea.model.TimeGaussDistribution;
import org.eclipse.app4mc.amalthea.model.TimeHistogram;
import org.eclipse.app4mc.amalthea.model.TimeHistogramEntry;
import org.eclipse.app4mc.amalthea.model.TimeInterval;
import org.eclipse.app4mc.amalthea.model.TimeStatistics;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractDeviationChart {
    private static final String CHART_SERIES_AREA_LINE = ".chart-series-area-line";
    private static final String CHART_SERIES_AREA_FILL = ".chart-series-area-fill";
    protected static final List<String> DEVIATION_LIST = List.of("Constant", "Histogram", "Boundaries", "Statistic", "Uniform", "Beta", "Gauss", "Weibull");
    protected static final String ARROW = "\u2192";

    protected AreaChart<Number, Number> addNewChart(BorderPane pane, EObject deviation, String unit) {
        NumberAxis xAxis = new NumberAxis();
        String part1 = this.getXAxisType(deviation, "values");
        String part2 = unit == null || unit.isEmpty() ? "" : " [" + unit + "]";
        xAxis.setLabel(String.valueOf(part1) + part2);
        xAxis.setForceZeroInRange(false);
        xAxis.setMinorTickVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("density");
        yAxis.setForceZeroInRange(false);
        yAxis.setTickMarkVisible(false);
        yAxis.setTickLabelsVisible(false);
        yAxis.setMinorTickVisible(false);
        AreaChart chart = new AreaChart((Axis)xAxis, (Axis)yAxis);
        chart.setTitle(this.getChartTitle(deviation));
        chart.setAnimated(false);
        chart.setVerticalGridLinesVisible(false);
        chart.setHorizontalGridLinesVisible(false);
        chart.setLegendVisible(false);
        chart.lookup(".chart-vertical-zero-line").setStyle("-fx-stroke: rgba(0, 0, 0, 0.0);");
        pane.setCenter((Node)chart);
        return chart;
    }

    private String getChartTitle(EObject deviation) {
        if (deviation != null) {
            String className = deviation.eClass().getName();
            for (String genericName : DEVIATION_LIST) {
                if (!className.contains(genericName)) continue;
                return genericName;
            }
        }
        return null;
    }

    private String getXAxisType(EObject deviation, String defaultText) {
        if (deviation != null && deviation.eContainer() != null && deviation.eContainingFeature() != null) {
            String containerClassName = deviation.eContainer().eClass().getName();
            String featureName = deviation.eContainingFeature().getName();
            if (containerClassName.contains("Ticks")) {
                return "ticks";
            }
            if (deviation.eClass().getName().contains("Time")) {
                return "time";
            }
            if (featureName.contains("Latency")) {
                return "cycles";
            }
            if (featureName.contains("occurrences")) {
                return "occurrences";
            }
        }
        return defaultText;
    }

    protected Label addNewStatus(BorderPane pane, String status) {
        if (status != null) {
            Label statusLabel = new Label(status);
            statusLabel.setMaxWidth(Double.MAX_VALUE);
            statusLabel.setAlignment(Pos.CENTER);
            statusLabel.setTextFill((Paint)Color.RED);
            pane.setBottom((Node)statusLabel);
            return statusLabel;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void setChartXBounds(AreaChart<Number, Number> chart, double lowerBound, double upperBound) {
        if (lowerBound >= upperBound) {
            return;
        }
        Axis axis = chart.getXAxis();
        if (axis instanceof NumberAxis) {
            void axis2;
            NumberAxis numberAxis = (NumberAxis)axis;
            NumberAxis cfr_ignored_0 = (NumberAxis)axis;
            axis2.setAutoRanging(false);
            axis2.setLowerBound(lowerBound);
            axis2.setUpperBound(upperBound);
            axis2.setMinorTickCount(0);
            axis2.setTickUnit((upperBound - lowerBound) / 5.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setChartYBounds(AreaChart<Number, Number> chart, double upperBound) {
        Axis axis = chart.getYAxis();
        if (axis instanceof NumberAxis) {
            void axis2;
            NumberAxis numberAxis = (NumberAxis)axis;
            NumberAxis cfr_ignored_0 = (NumberAxis)axis;
            axis2.setAutoRanging(false);
            axis2.setLowerBound(0.0);
            axis2.setUpperBound(upperBound);
        }
    }

    protected void addSeriesStandard(AreaChart<Number, Number> chart, XYChart.Series<Number, Number> series) {
        if (series.getData().isEmpty()) {
            return;
        }
        chart.getData().add(series);
        series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 128, 0, 1.0);");
        series.getNode().lookup(CHART_SERIES_AREA_FILL).setStyle("-fx-fill: rgba(0, 128, 0, 0.15);");
        for (XYChart.Data data : series.getData()) {
            data.getNode().setVisible(false);
        }
    }

    protected void addSeriesOffLimit(AreaChart<Number, Number> chart, XYChart.Series<Number, Number> series) {
        if (series.getData().isEmpty()) {
            return;
        }
        chart.getData().add(series);
        series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(128, 128, 128, 1.0); -fx-stroke-dash-array: 2;");
        series.getNode().lookup(CHART_SERIES_AREA_FILL).setStyle("-fx-fill: rgba(0, 0, 0, 0.0);");
        for (XYChart.Data data : series.getData()) {
            data.getNode().setVisible(false);
        }
    }

    protected void addSeriesGradient(AreaChart<Number, Number> chart, XYChart.Series<Number, Number> series) {
        if (series.getData().isEmpty()) {
            return;
        }
        chart.getData().add(series);
        series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 0, 0, 0.0);");
        series.getNode().lookup(CHART_SERIES_AREA_FILL).setStyle("-fx-fill: linear-gradient(to top, rgba(0, 128, 0, 0.3), rgba(0, 128, 0, 0.0));");
        for (XYChart.Data data : series.getData()) {
            data.getNode().setVisible(false);
        }
    }

    protected void addSinglePeek(AreaChart<Number, Number> chart, double y, double x) {
        if (chart.getYAxis() instanceof NumberAxis) {
            XYChart.Series series = new XYChart.Series();
            chart.getData().add((Object)series);
            series.getData().add((Object)new XYChart.Data((Object)x, (Object)0.0));
            series.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 128, 0, 1.0);");
            ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
        }
    }

    protected void addMarkers(AreaChart<Number, Number> chart, double y, Double min, Double avg, Double max) {
        if (chart.getYAxis() instanceof NumberAxis) {
            XYChart.Series series;
            if (min != null) {
                series = new XYChart.Series();
                chart.getData().add((Object)series);
                series.setName("min");
                series.getData().add((Object)new XYChart.Data((Object)min, (Object)0.0));
                series.getData().add((Object)new XYChart.Data((Object)min, (Object)y));
                series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 0, 0, 1.0);");
                ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
            }
            if (max != null) {
                series = new XYChart.Series();
                chart.getData().add((Object)series);
                series.setName("max");
                series.getData().add((Object)new XYChart.Data((Object)max, (Object)0.0));
                series.getData().add((Object)new XYChart.Data((Object)max, (Object)y));
                series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 0, 0, 1.0);");
                ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
            }
            if (avg != null && (min == null || min <= avg) && (max == null || max >= avg)) {
                series = new XYChart.Series();
                chart.getData().add((Object)series);
                series.setName("avg");
                series.getData().add((Object)new XYChart.Data((Object)avg, (Object)0.0));
                series.getData().add((Object)new XYChart.Data((Object)avg, (Object)y));
                series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(150, 5, 5, 1.0); -fx-stroke-dash-array: 3;");
                ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(IDiscreteValueDeviation dev) {
        IDiscreteValueDeviation iDiscreteValueDeviation;
        Object lowerBound;
        if (dev instanceof DiscreteValueConstant) {
            return true;
        }
        IDiscreteValueDeviation iDiscreteValueDeviation2 = dev;
        if (iDiscreteValueDeviation2 instanceof DiscreteValueHistogram) {
            void histogram;
            DiscreteValueHistogram discreteValueHistogram = (DiscreteValueHistogram)iDiscreteValueDeviation2;
            DiscreteValueHistogram cfr_ignored_0 = (DiscreteValueHistogram)iDiscreteValueDeviation2;
            EList entries = histogram.getEntries();
            if (entries.isEmpty()) {
                return false;
            }
            for (DiscreteValueHistogramEntry entry : entries) {
                Long lowerBound2 = entry.getLowerBound();
                Long upperBound = entry.getUpperBound();
                if (lowerBound2 != null && upperBound != null && lowerBound2.compareTo(upperBound) <= 0 && entry.getOccurrences() >= 0L) continue;
                return false;
            }
            return true;
        }
        IDiscreteValueDeviation iDiscreteValueDeviation3 = dev;
        if (iDiscreteValueDeviation3 instanceof DiscreteValueInterval) {
            void interval;
            DiscreteValueInterval entries = (DiscreteValueInterval)iDiscreteValueDeviation3;
            DiscreteValueInterval cfr_ignored_1 = (DiscreteValueInterval)iDiscreteValueDeviation3;
            lowerBound = interval.getLowerBound();
            Long upperBound = interval.getUpperBound();
            if (lowerBound == null || upperBound == null || !this.isValidMinAvgMax(((Long)lowerBound).doubleValue(), this.getAverage((DiscreteValueInterval)interval), upperBound.doubleValue())) {
                return false;
            }
        }
        if ((iDiscreteValueDeviation = dev) instanceof DiscreteValueWeibullEstimatorsDistribution) {
            void weibullDist;
            lowerBound = (DiscreteValueWeibullEstimatorsDistribution)iDiscreteValueDeviation;
            DiscreteValueWeibullEstimatorsDistribution cfr_ignored_2 = (DiscreteValueWeibullEstimatorsDistribution)iDiscreteValueDeviation;
            double promille = weibullDist.getPRemainPromille();
            return promille > 0.0 && promille < 1000.0;
        }
        IDiscreteValueDeviation iDiscreteValueDeviation4 = dev;
        if (iDiscreteValueDeviation4 instanceof DiscreteValueBetaDistribution) {
            void betaDist;
            DiscreteValueBetaDistribution promille = (DiscreteValueBetaDistribution)iDiscreteValueDeviation4;
            DiscreteValueBetaDistribution cfr_ignored_3 = (DiscreteValueBetaDistribution)iDiscreteValueDeviation4;
            return betaDist.getAlpha() > 0.0 && betaDist.getBeta() > 0.0;
        }
        IDiscreteValueDeviation iDiscreteValueDeviation5 = dev;
        if (iDiscreteValueDeviation5 instanceof DiscreteValueGaussDistribution) {
            void gaussDist;
            DiscreteValueGaussDistribution discreteValueGaussDistribution = (DiscreteValueGaussDistribution)iDiscreteValueDeviation5;
            DiscreteValueGaussDistribution cfr_ignored_4 = (DiscreteValueGaussDistribution)iDiscreteValueDeviation5;
            if (gaussDist.getSd() <= 0.0 || !this.isValidMinAvgMax(gaussDist.getLowerBound(), null, gaussDist.getUpperBound())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(IContinuousValueDeviation dev) {
        IContinuousValueDeviation iContinuousValueDeviation;
        Object lowerBound;
        if (dev instanceof ContinuousValueConstant) {
            return true;
        }
        IContinuousValueDeviation iContinuousValueDeviation2 = dev;
        if (iContinuousValueDeviation2 instanceof ContinuousValueHistogram) {
            void histogram;
            ContinuousValueHistogram continuousValueHistogram = (ContinuousValueHistogram)iContinuousValueDeviation2;
            ContinuousValueHistogram cfr_ignored_0 = (ContinuousValueHistogram)iContinuousValueDeviation2;
            EList entries = histogram.getEntries();
            if (entries.isEmpty()) {
                return false;
            }
            for (ContinuousValueHistogramEntry entry : entries) {
                Double lowerBound2 = entry.getLowerBound();
                Double upperBound = entry.getUpperBound();
                if (lowerBound2 != null && upperBound != null && lowerBound2.compareTo(upperBound) <= 0 && entry.getOccurrences() >= 0L) continue;
                return false;
            }
            return true;
        }
        IContinuousValueDeviation iContinuousValueDeviation3 = dev;
        if (iContinuousValueDeviation3 instanceof ContinuousValueInterval) {
            void interval;
            ContinuousValueInterval entries = (ContinuousValueInterval)iContinuousValueDeviation3;
            ContinuousValueInterval cfr_ignored_1 = (ContinuousValueInterval)iContinuousValueDeviation3;
            lowerBound = interval.getLowerBound();
            Double upperBound = interval.getUpperBound();
            if (lowerBound == null || upperBound == null || !this.isValidMinAvgMax((Comparable)lowerBound, (Comparable)this.getAverage((ContinuousValueInterval)interval), (Comparable)upperBound)) {
                return false;
            }
        }
        if ((iContinuousValueDeviation = dev) instanceof ContinuousValueWeibullEstimatorsDistribution) {
            void weibullDist;
            lowerBound = (ContinuousValueWeibullEstimatorsDistribution)iContinuousValueDeviation;
            ContinuousValueWeibullEstimatorsDistribution cfr_ignored_2 = (ContinuousValueWeibullEstimatorsDistribution)iContinuousValueDeviation;
            double promille = weibullDist.getPRemainPromille();
            return promille > 0.0 && promille < 1000.0;
        }
        IContinuousValueDeviation iContinuousValueDeviation4 = dev;
        if (iContinuousValueDeviation4 instanceof ContinuousValueBetaDistribution) {
            void betaDist;
            ContinuousValueBetaDistribution promille = (ContinuousValueBetaDistribution)iContinuousValueDeviation4;
            ContinuousValueBetaDistribution cfr_ignored_3 = (ContinuousValueBetaDistribution)iContinuousValueDeviation4;
            return betaDist.getAlpha() > 0.0 && betaDist.getBeta() > 0.0;
        }
        IContinuousValueDeviation iContinuousValueDeviation5 = dev;
        if (iContinuousValueDeviation5 instanceof ContinuousValueGaussDistribution) {
            void gaussDist;
            ContinuousValueGaussDistribution continuousValueGaussDistribution = (ContinuousValueGaussDistribution)iContinuousValueDeviation5;
            ContinuousValueGaussDistribution cfr_ignored_4 = (ContinuousValueGaussDistribution)iContinuousValueDeviation5;
            if (gaussDist.getSd() <= 0.0 || !this.isValidMinAvgMax(gaussDist.getLowerBound(), null, gaussDist.getUpperBound())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(ITimeDeviation dev) {
        ITimeDeviation iTimeDeviation;
        TimeBetaDistribution lowerBound;
        ITimeDeviation iTimeDeviation2;
        ITimeDeviation iTimeDeviation3;
        ITimeDeviation iTimeDeviation4 = dev;
        if (iTimeDeviation4 instanceof TimeConstant) {
            void constant;
            TimeConstant timeConstant = (TimeConstant)iTimeDeviation4;
            TimeConstant cfr_ignored_0 = (TimeConstant)iTimeDeviation4;
            return this.isValidTime(constant.getValue());
        }
        ITimeDeviation iTimeDeviation5 = dev;
        if (iTimeDeviation5 instanceof TimeHistogram) {
            void histogram;
            TimeHistogram timeHistogram = (TimeHistogram)iTimeDeviation5;
            TimeHistogram cfr_ignored_1 = (TimeHistogram)iTimeDeviation5;
            EList entries = histogram.getEntries();
            if (entries.isEmpty()) {
                return false;
            }
            for (TimeHistogramEntry entry : entries) {
                Time lowerBound2 = entry.getLowerBound();
                Time upperBound = entry.getUpperBound();
                if (this.isValidTime(lowerBound2) && this.isValidTime(upperBound) && lowerBound2.compareTo(upperBound) <= 0 && entry.getOccurrences() >= 0L) continue;
                return false;
            }
            return true;
        }
        ITimeDeviation iTimeDeviation6 = dev;
        if (iTimeDeviation6 instanceof TimeStatistics) {
            void statistics;
            TimeStatistics entries = (TimeStatistics)iTimeDeviation6;
            TimeStatistics cfr_ignored_2 = (TimeStatistics)iTimeDeviation6;
            if (!this.isValidTime(statistics.getAverage())) {
                return false;
            }
        }
        if ((iTimeDeviation3 = dev) instanceof TimeWeibullEstimatorsDistribution) {
            void weibullDist;
            TimeWeibullEstimatorsDistribution lowerBound2 = (TimeWeibullEstimatorsDistribution)iTimeDeviation3;
            TimeWeibullEstimatorsDistribution cfr_ignored_3 = (TimeWeibullEstimatorsDistribution)iTimeDeviation3;
            if (!this.isValidTime(weibullDist.getAverage())) {
                return false;
            }
            double promille = weibullDist.getPRemainPromille();
            if (promille <= 0.0 || promille >= 1000.0) {
                return false;
            }
        }
        if ((iTimeDeviation2 = dev) instanceof TimeInterval) {
            void interval;
            TimeInterval promille = (TimeInterval)iTimeDeviation2;
            TimeInterval cfr_ignored_4 = (TimeInterval)iTimeDeviation2;
            lowerBound = interval.getLowerBound();
            Time upperBound = interval.getUpperBound();
            if (!(this.isValidTime((Time)lowerBound) && this.isValidTime(upperBound) && this.isValidMinAvgMax((Comparable)lowerBound, (Comparable)this.getAverage((TimeInterval)interval), (Comparable)upperBound))) {
                return false;
            }
        }
        if ((iTimeDeviation = dev) instanceof TimeBetaDistribution) {
            void betaDist;
            lowerBound = (TimeBetaDistribution)iTimeDeviation;
            TimeBetaDistribution cfr_ignored_5 = (TimeBetaDistribution)iTimeDeviation;
            return betaDist.getAlpha() > 0.0 && betaDist.getBeta() > 0.0;
        }
        ITimeDeviation iTimeDeviation7 = dev;
        if (iTimeDeviation7 instanceof TimeGaussDistribution) {
            void gaussDist;
            TimeGaussDistribution timeGaussDistribution = (TimeGaussDistribution)iTimeDeviation7;
            TimeGaussDistribution cfr_ignored_6 = (TimeGaussDistribution)iTimeDeviation7;
            Time mean = gaussDist.getMean();
            Time sd = gaussDist.getSd();
            if (!(this.isValidTime(mean) && this.isValidTime(sd) && sd.getValue().signum() >= 1 && this.isValidMinAvgMax(gaussDist.getLowerBound(), null, gaussDist.getUpperBound()))) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidTime(Time time) {
        return time != null && time.getValue() != null && time.getUnit() != TimeUnit._UNDEFINED_;
    }

    public <T extends Comparable<T>> boolean isValidMinAvgMax(T min, T avg, T max) {
        return this.isSinglePeek(min, max) || this.isValidRange(min, avg, max);
    }

    public <T extends Comparable<T>> boolean isSinglePeek(T min, T max) {
        return min != null && max != null && min.compareTo(max) == 0;
    }

    public <T extends Comparable<T>> boolean isValidRange(T min, T avg, T max) {
        if (min != null && max != null && min.compareTo(max) >= 0) {
            return false;
        }
        if (min != null && avg != null && min.compareTo(avg) >= 0) {
            return false;
        }
        return avg == null || max == null || avg.compareTo(max) < 0;
    }

    /*
     * WARNING - void declaration
     */
    public Time getAverage(TimeInterval obj) {
        TimeInterval timeInterval;
        Time avg = null;
        TimeInterval timeInterval2 = obj;
        if (timeInterval2 instanceof TimeStatistics) {
            void timeStatistics;
            TimeStatistics timeStatistics2 = (TimeStatistics)timeInterval2;
            TimeStatistics cfr_ignored_0 = (TimeStatistics)timeInterval2;
            avg = timeStatistics.getAverage();
        }
        if ((timeInterval = obj) instanceof TimeWeibullEstimatorsDistribution) {
            void timeWeibullDist;
            TimeWeibullEstimatorsDistribution timeWeibullEstimatorsDistribution = (TimeWeibullEstimatorsDistribution)timeInterval;
            TimeWeibullEstimatorsDistribution cfr_ignored_1 = (TimeWeibullEstimatorsDistribution)timeInterval;
            avg = timeWeibullDist.getAverage();
        }
        return avg;
    }

    /*
     * WARNING - void declaration
     */
    public Double getAverage(DiscreteValueInterval obj) {
        DiscreteValueInterval discreteValueInterval;
        Double avg = null;
        DiscreteValueInterval discreteValueInterval2 = obj;
        if (discreteValueInterval2 instanceof DiscreteValueStatistics) {
            void discValStat;
            DiscreteValueStatistics discreteValueStatistics = (DiscreteValueStatistics)discreteValueInterval2;
            DiscreteValueStatistics cfr_ignored_0 = (DiscreteValueStatistics)discreteValueInterval2;
            avg = discValStat.getAverage();
        }
        if ((discreteValueInterval = obj) instanceof DiscreteValueWeibullEstimatorsDistribution) {
            void discValWeibullDist;
            DiscreteValueWeibullEstimatorsDistribution discreteValueWeibullEstimatorsDistribution = (DiscreteValueWeibullEstimatorsDistribution)discreteValueInterval;
            DiscreteValueWeibullEstimatorsDistribution cfr_ignored_1 = (DiscreteValueWeibullEstimatorsDistribution)discreteValueInterval;
            avg = discValWeibullDist.getAverage();
        }
        return avg;
    }

    /*
     * WARNING - void declaration
     */
    public Double getAverage(ContinuousValueInterval obj) {
        ContinuousValueInterval continuousValueInterval;
        Double avg = null;
        ContinuousValueInterval continuousValueInterval2 = obj;
        if (continuousValueInterval2 instanceof ContinuousValueStatistics) {
            void contValStat;
            ContinuousValueStatistics continuousValueStatistics = (ContinuousValueStatistics)continuousValueInterval2;
            ContinuousValueStatistics cfr_ignored_0 = (ContinuousValueStatistics)continuousValueInterval2;
            avg = contValStat.getAverage();
        }
        if ((continuousValueInterval = obj) instanceof ContinuousValueWeibullEstimatorsDistribution) {
            void contValWeibullDist;
            ContinuousValueWeibullEstimatorsDistribution continuousValueWeibullEstimatorsDistribution = (ContinuousValueWeibullEstimatorsDistribution)continuousValueInterval;
            ContinuousValueWeibullEstimatorsDistribution cfr_ignored_1 = (ContinuousValueWeibullEstimatorsDistribution)continuousValueInterval;
            avg = contValWeibullDist.getAverage();
        }
        return avg;
    }
}

