/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters300.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=2.2.0", "output_model_version=3.0.0"}, service={IConverter.class})
public class DatatypeConverter
extends AbstractConverter {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String HREF = "href";
    private static final String TYPE = "type";
    private static final String TYPE_DEF = "typeDef";
    private static final String TYPE_DATA_TYPE_DEFINITION = "?type=DataTypeDefinition";
    private static final String DATA_TYPE = "dataType";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from {0} to {1} : Executing Datatype converter for model file : {2}", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion(), targetFile.getName()});
        this.basicConvert(targetFile, fileDocumentMapping);
    }

    private void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateSoftwareDatatypes(rootElement);
        this.updateComponentDatatypes(rootElement);
    }

    private void updateSoftwareDatatypes(Element rootElement) {
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((String)this.getInputModelVersion(), (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        Namespace xmi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xmi");
        StringBuilder xpathBuilder = new StringBuilder();
        xpathBuilder.append("./swModel/labels/dataType");
        xpathBuilder.append("|");
        xpathBuilder.append("./swModel/channels/elementType");
        List entries = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuilder.toString(), Element.class, (Namespace[])new Namespace[]{am, xsi});
        if (entries == null) {
            return;
        }
        for (Element entry : entries) {
            Element parent = entry.getParentElement();
            Attribute typeAttr = entry.getAttribute(TYPE, xsi);
            if (parent == null || typeAttr == null) continue;
            if ("am:TypeRef".equals(typeAttr.getValue())) {
                Attribute attribute = entry.getAttribute(TYPE_DEF);
                Element child = entry.getChild(TYPE_DEF);
                if (attribute != null) {
                    parent.setAttribute(entry.getName(), entry.getAttributeValue(TYPE_DEF));
                    entry.detach();
                }
                if (child != null) {
                    typeAttr.setValue(child.getAttributeValue(TYPE, xsi));
                    if (child.getAttribute(HREF) != null) {
                        entry.setAttribute(child.getAttribute(HREF).clone());
                    }
                    child.detach();
                }
                if (attribute != null || child != null) continue;
                entry.detach();
                continue;
            }
            String parentId = parent.getAttributeValue(ID, xmi);
            String parentName = parent.getAttributeValue(NAME);
            if (parentId == null || parentName == null) continue;
            String parentType = parent.getName().replace("s", "");
            String parentIdWithoutType = parentId.substring(0, parentId.lastIndexOf("?type="));
            String postfix = " (migrated " + parentType + " type)";
            String genId = String.valueOf(parentIdWithoutType) + HelperUtil.encodeName((String)postfix) + TYPE_DATA_TYPE_DEFINITION;
            String genName = String.valueOf(parentName) + postfix;
            parent.setAttribute(entry.getName(), genId);
            Element newTypeDefinition = new Element("typeDefinitions");
            newTypeDefinition.setAttribute(TYPE, "am:DataTypeDefinition", xsi);
            newTypeDefinition.setAttribute(ID, genId, xmi);
            newTypeDefinition.setAttribute(NAME, genName);
            HelperUtil.copyElementAttributeOrElement((Element)parent, (Element)newTypeDefinition, (String)"namespace");
            entry.detach();
            entry.setName(DATA_TYPE);
            newTypeDefinition.addContent((Content)entry);
            rootElement.getChild("swModel").addContent((Content)newTypeDefinition);
        }
    }

    private void updateComponentDatatypes(Element rootElement) {
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((String)this.getInputModelVersion(), (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        StringBuilder xpathBuilder = new StringBuilder();
        xpathBuilder.append("./componentsModel/interfaces");
        xpathBuilder.append("|");
        xpathBuilder.append("./componentsModel/interfaces//subInterfaces");
        List entries = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuilder.toString(), Element.class, (Namespace[])new Namespace[]{am, xsi});
        if (entries == null) {
            return;
        }
        for (Element entry : entries) {
            Element child;
            Attribute attribute = entry.getAttribute("datatype");
            if (attribute != null) {
                attribute.setName(DATA_TYPE);
            }
            if ((child = entry.getChild("datatype")) == null) continue;
            child.setName(DATA_TYPE);
        }
    }
}

