/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.dialog;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelMigrationJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ModelMigrationDialog
extends Dialog {
    private static final String MODEL_MIGRATION = "AMALTHEA Model Migration";
    private MigrationProcessor migrationProcessor;
    private IProject iProject;
    private IResource selectedContainer;
    private Label messageLabel;
    private Combo migModelVersionCombo;
    private CheckboxTableViewer tableViewer;
    private MigrationSettings currentSettings;
    private MigrationSettings migrationSettings;
    private MigrationSettings recursiveMigrationSettings;
    private ArrayList<MigrationInputFile> selectedFiles = new ArrayList();
    private ArrayList<String> warningFolders = new ArrayList();

    public ModelMigrationDialog(Shell parentShell, MigrationProcessor migrationProcessor, MigrationSettings settings, IProject iProject) {
        super(parentShell);
        this.setShellStyle(67696);
        if (migrationProcessor == null) {
            throw new IllegalStateException("MigrationProcessor cannot be null");
        }
        this.migrationProcessor = migrationProcessor;
        this.migrationSettings = settings == null ? new MigrationSettings() : settings;
        this.currentSettings = this.migrationSettings;
        this.iProject = iProject;
    }

    public void setSelectedContainer(IContainer container) {
        this.selectedContainer = container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MODEL_MIGRATION);
    }

    protected Point getInitialSize() {
        return new Point(700, 600);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText(MODEL_MIGRATION);
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)parentComposite.getLayout();
        gridLayout.numColumns = 1;
        Group grpInitialModel = new Group(parentComposite, 0);
        grpInitialModel.setText("AMALTHEA Models");
        grpInitialModel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)grpInitialModel);
        Composite tableComposite = this.createFileTableViewer((Composite)grpInitialModel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        this.messageLabel = new Label((Composite)grpInitialModel, 64);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.messageLabel);
        this.updateWarningMessage();
        Group grpMigrationModels = new Group(parentComposite, 0);
        grpMigrationModels.setText("Migration details");
        grpMigrationModels.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)grpMigrationModels);
        Label migModelVersionText = new Label((Composite)grpMigrationModels, 0);
        migModelVersionText.setText("Model Version");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)migModelVersionText);
        this.migModelVersionCombo = new Combo((Composite)grpMigrationModels, 8);
        GridDataFactory.swtDefaults().grab(false, false).span(2, 1).applyTo((Control)this.migModelVersionCombo);
        this.populateMigrationVersionCombo();
        this.migModelVersionCombo.addListener(24, event -> {
            String selectedOutputModelVersion = this.migModelVersionCombo.getText();
            if (selectedOutputModelVersion != null && selectedOutputModelVersion.length() > 0) {
                this.currentSettings.setMigrationModelVersion(selectedOutputModelVersion);
            }
        });
        final Button backup = new Button((Composite)grpMigrationModels, 32);
        backup.setText("Create backup file");
        backup.setToolTipText("Copies the file to migrate next to the original file as a backup.");
        backup.setSelection(this.currentSettings.isCreateBackupFile());
        GridDataFactory.swtDefaults().grab(false, false).span(3, 1).applyTo((Control)backup);
        backup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelMigrationDialog.this.currentSettings.setCreateBackupFile(backup.getSelection());
            }
        });
        if (this.selectedContainer != null) {
            Button recursive = new Button((Composite)grpMigrationModels, 32);
            recursive.setText("Recursive");
            recursive.setToolTipText("Migrate all model files in all sub-folders");
            GridDataFactory.swtDefaults().grab(false, false).span(3, 1).applyTo((Control)recursive);
            recursive.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    if (button.getSelection()) {
                        if (ModelMigrationDialog.this.recursiveMigrationSettings == null) {
                            ModelMigrationDialog.this.recursiveMigrationSettings = new MigrationSettings();
                            ModelMigrationDialog.this.recursiveMigrationSettings.setProject(ModelMigrationDialog.this.migrationSettings.getProject());
                            ModelMigrationDialog.this.recursiveMigrationSettings.setMigrationModelVersion(ModelMigrationDialog.this.migrationSettings.getMigrationModelVersion());
                            Path modelFilePath = Paths.get(ModelMigrationDialog.this.selectedContainer.getLocationURI());
                            try {
                                Throwable throwable = null;
                                Object var5_7 = null;
                                try (Stream<Path> directoryStream = Files.walk(modelFilePath, Integer.MAX_VALUE, new FileVisitOption[0]);){
                                    List modelFiles = directoryStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file -> file.toString().toLowerCase().endsWith(".amxmi")).map(Path::toFile).collect(Collectors.toList());
                                    ModelMigrationDialog.this.recursiveMigrationSettings.getMigModelFiles().addAll(MigrationHelper.populateModels(modelFiles, (MigrationSettings)ModelMigrationDialog.this.recursiveMigrationSettings));
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Exception ex) {
                                MessageDialog.openError((Shell)ModelMigrationDialog.this.getParentShell(), (String)"Failed to load model files", (String)("Failed to load model files: " + ex.getLocalizedMessage()));
                                return;
                            }
                        }
                        ModelMigrationDialog.this.currentSettings = ModelMigrationDialog.this.recursiveMigrationSettings;
                    } else {
                        ModelMigrationDialog.this.currentSettings = ModelMigrationDialog.this.migrationSettings;
                    }
                    ModelMigrationDialog.this.selectedFiles = new ArrayList(ModelMigrationDialog.this.currentSettings.getMigModelFiles());
                    ModelMigrationDialog.this.tableViewer.setInput((Object)ModelMigrationDialog.this.currentSettings.getMigModelFiles());
                    ModelMigrationDialog.this.tableViewer.setAllChecked(true);
                    ModelMigrationDialog.this.updateWarningMessage();
                    ModelMigrationDialog.this.populateMigrationVersionCombo();
                }
            });
        }
        return parentComposite;
    }

    private void updateWarningMessage() {
        Map<String, Map<String, List<MigrationInputFile>>> collect = this.selectedFiles.stream().collect(Collectors.groupingBy(mig -> mig.getOriginalFile().getParent(), Collectors.groupingBy(MigrationInputFile::getModelVersion)));
        this.warningFolders.clear();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Map<String, List<MigrationInputFile>>> folderMapping : collect.entrySet()) {
            if (folderMapping.getValue().size() <= 1) continue;
            String ident = this.currentSettings.getProject().toURI().relativize(new File(folderMapping.getKey()).toURI()).getPath();
            builder.append("The folder ").append(ident).append(" contains multiple files with different model versions!\n");
            this.warningFolders.add(ident);
        }
        this.messageLabel.setText(builder.toString());
        this.messageLabel.setVisible(this.messageLabel.getText() != null && !this.messageLabel.getText().isEmpty());
        this.messageLabel.getParent().layout();
        this.tableViewer.refresh(true);
    }

    private void populateMigrationVersionCombo() {
        int selectedIndex = 0;
        List comboInput = null;
        List allSupportedVersions = ModelVersion.getAllSupportedVersions();
        int totalVersionSize = allSupportedVersions.size();
        String version = this.currentSettings.getInputModelVersion();
        if (version != null) {
            int startIndex = allSupportedVersions.indexOf(version);
            if (startIndex != -1) {
                comboInput = allSupportedVersions.subList(startIndex + 1, totalVersionSize);
            }
        } else {
            String smallestInputVersion = null;
            for (MigrationInputFile file : this.currentSettings.getMigModelFiles()) {
                if (smallestInputVersion == null) {
                    smallestInputVersion = file.getModelVersion();
                    continue;
                }
                if (smallestInputVersion.equals(file.getModelVersion())) continue;
                int indexOfCurrent = allSupportedVersions.indexOf(smallestInputVersion);
                int indexOfFound = allSupportedVersions.indexOf(file.getModelVersion());
                if (indexOfFound >= indexOfCurrent) continue;
                smallestInputVersion = file.getModelVersion();
            }
            int startIndex = allSupportedVersions.indexOf(smallestInputVersion);
            comboInput = startIndex != -1 ? allSupportedVersions.subList(startIndex + 1, totalVersionSize) : new ArrayList(allSupportedVersions);
        }
        if (comboInput != null) {
            Collections.reverse(comboInput);
            this.migModelVersionCombo.setItems(comboInput.toArray(new String[0]));
            selectedIndex = comboInput.indexOf(this.currentSettings.getMigrationModelVersion());
            this.migModelVersionCombo.select(selectedIndex);
        }
    }

    private Composite createFileTableViewer(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)66314);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.getHorizontalBar().setEnabled(true);
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Relative file paths");
        viewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                MigrationInputFile migModelFile;
                File file;
                Object element = cell.getElement();
                if (element instanceof MigrationInputFile && (file = (migModelFile = (MigrationInputFile)element).getOriginalFile()) != null) {
                    try {
                        String path = migModelFile.getProjectRelativePath();
                        cell.setText(path);
                        if (migModelFile.isSelectedFile()) {
                            StyleRange styledRange = new StyleRange(0, path.length(), Display.getCurrent().getSystemColor(9), null);
                            StyleRange[] range = new StyleRange[]{styledRange};
                            cell.setStyleRanges(range);
                        }
                        if (ModelMigrationDialog.this.warningFolders.stream().anyMatch(path::startsWith)) {
                            StyleRange styledRange = new StyleRange(0, path.length(), Display.getCurrent().getSystemColor(3), null);
                            StyleRange[] range = new StyleRange[]{styledRange};
                            cell.setStyleRanges(range);
                        } else {
                            cell.setStyleRanges(null);
                        }
                    }
                    catch (Exception e) {
                        Platform.getLog(((Object)((Object)this)).getClass()).warn("unable to build the relative path for file : " + file.getAbsolutePath(), (Throwable)e);
                        cell.setText(file.getAbsolutePath());
                    }
                }
                super.update(cell);
            }
        });
        tableColumnLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(70, true));
        TableViewerColumn modelVersionColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        modelVersionColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof MigrationInputFile) {
                    MigrationInputFile migModelFile = (MigrationInputFile)element;
                    cell.setText(migModelFile.getModelVersion());
                    if (migModelFile.isSelectedFile()) {
                        StyleRange styledRange = new StyleRange(0, migModelFile.getModelVersion().length(), Display.getCurrent().getSystemColor(9), null);
                        StyleRange[] range = new StyleRange[]{styledRange};
                        cell.setStyleRanges(range);
                    }
                    String path = migModelFile.getProjectRelativePath();
                    if (ModelMigrationDialog.this.warningFolders.stream().anyMatch(path::startsWith)) {
                        StyleRange styledRange = new StyleRange(0, path.length(), Display.getCurrent().getSystemColor(3), null);
                        StyleRange[] range = new StyleRange[]{styledRange};
                        cell.setStyleRanges(range);
                    } else {
                        cell.setStyleRanges(null);
                    }
                }
                super.update(cell);
            }
        });
        column = modelVersionColumn.getColumn();
        column.setText("Model Version");
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.currentSettings.getMigModelFiles().sort((o1, o2) -> o1.getProjectRelativePath().compareTo(o2.getProjectRelativePath()));
        this.tableViewer.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.selectedFiles.add((MigrationInputFile)event.getElement());
            } else {
                this.selectedFiles.remove(event.getElement());
            }
            this.updateWarningMessage();
        });
        this.selectedFiles = new ArrayList(this.currentSettings.getMigModelFiles());
        this.tableViewer.setInput((Object)this.currentSettings.getMigModelFiles());
        this.tableViewer.setAllChecked(true);
        return tableComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button migrateModelsButton = this.createButton(parent, 0, "Migrate Models", true);
        migrateModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelMigrationDialog.this.currentSettings.getMigModelFiles().clear();
                ModelMigrationDialog.this.currentSettings.getMigModelFiles().addAll(ModelMigrationDialog.this.selectedFiles);
                ModelMigrationJob migrationJob = new ModelMigrationJob(ModelMigrationDialog.MODEL_MIGRATION, ModelMigrationDialog.this.migrationProcessor, ModelMigrationDialog.this.currentSettings, ModelMigrationDialog.this.iProject);
                migrationJob.setUser(true);
                migrationJob.schedule();
            }
        });
        Button cancelMigrationButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        cancelMigrationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Job.getJobManager().cancel((Object)"AMALTHEA_MODEL_MIGRATION");
            }
        });
    }
}

