/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters200.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=1.2.0"}, service={ICache.class, SchedulerCache.class})
public class SchedulerCache
implements ICache {
    private static final File FOLDER_SCOPE = new File("folder_scope");
    private static final String STANDARD_ALGORITHM_NAMES = "standard-algorithm-names";
    private static final String STANDARD_PARAMETER_NAMES = "standard-parameter-names";
    private static final String EXTENDED_PARAMETER_NAMES = "extended-parameter-names";
    private static final String USER_SPECIFIC_ALGORITHMS = "user-specific-algorithms";
    private static final String IS_FIRST_FILE = "is_first_file";
    @Reference
    SessionLogger logger;
    private final Map<File, Map<String, Object>> map = new HashMap<File, Map<String, Object>>();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        if (this.logger != null) {
            this.logger.info("Build up SchedulerCache for 1.2.0", new Object[0]);
        }
        this.fillCaches(fileDocumentMapping);
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }

    public Map<String, Object> getFolderScopeCache() {
        return this.map.computeIfAbsent(FOLDER_SCOPE, k -> new HashMap());
    }

    public Set<String> getStandardAlgorithmCache() {
        return (Set)this.getFolderScopeCache().computeIfAbsent(STANDARD_ALGORITHM_NAMES, k -> new HashSet());
    }

    public Set<String> getStandardParameterCache() {
        return (Set)this.getFolderScopeCache().computeIfAbsent(STANDARD_PARAMETER_NAMES, k -> new HashSet());
    }

    public Set<String> getExtendedParameterCache() {
        return (Set)this.getFolderScopeCache().computeIfAbsent(EXTENDED_PARAMETER_NAMES, k -> new HashSet());
    }

    public Map<String, List<String>> getUserSpecificAlgorithmCache() {
        return (Map)this.getFolderScopeCache().computeIfAbsent(USER_SPECIFIC_ALGORITHMS, k -> new HashMap());
    }

    public boolean isFirstFile() {
        return (Boolean)this.getFolderScopeCache().computeIfAbsent(IS_FIRST_FILE, k -> true);
    }

    public void setFirstFile(boolean flag) {
        this.getFolderScopeCache().put(IS_FIRST_FILE, flag);
    }

    private void fillCaches(Map<File, Document> fileDocumentMapping) {
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._120, (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        Set<String> standardAlgorithmCache = this.getStandardAlgorithmCache();
        Set<String> standardParameterCache = this.getStandardParameterCache();
        Set<String> extendedParameterCache = this.getExtendedParameterCache();
        Map<String, List<String>> userSpecificAlgorithmCache = this.getUserSpecificAlgorithmCache();
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            Document doc = entry.getValue();
            if (doc == null) continue;
            Element rootElement = doc.getRootElement();
            List algorithmElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems/taskSchedulers/schedulingAlgorithm|./osModel/operatingSystems/interruptControllers/schedulingAlgorithm", Element.class, (Namespace[])new Namespace[]{am, xsi});
            int counter = 0;
            for (Element elem : algorithmElements) {
                String type = elem.getAttributeValue("type", xsi);
                if (type.equals("am:UserSpecificSchedulingAlgorithm")) {
                    String algorithmName = String.valueOf(type.substring(3)) + String.valueOf(++counter);
                    ArrayList<String> algorithmParameters = new ArrayList<String>();
                    for (Element param : elem.getChildren("parameterExtensions")) {
                        String parameterName = param.getAttributeValue("key");
                        algorithmParameters.add(parameterName);
                        extendedParameterCache.add(parameterName);
                    }
                    userSpecificAlgorithmCache.put(algorithmName, algorithmParameters);
                    continue;
                }
                standardAlgorithmCache.add(type.substring(3));
            }
            List parameterElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems/taskSchedulers/parentAssociation/schedulingParameters|./mappingModel/taskAllocation/schedulingParameters", Element.class, (Namespace[])new Namespace[]{am, xsi});
            for (Element elem : parameterElements) {
                String priorityValue = elem.getAttributeValue("priority");
                if (priorityValue != null && !priorityValue.equals("0")) {
                    standardParameterCache.add("priority");
                }
                if (elem.getChild("minBudget") != null) {
                    standardParameterCache.add("minBudget");
                }
                if (elem.getChild("maxBudget") != null) {
                    standardParameterCache.add("maxBudget");
                }
                if (elem.getChild("replenishment") == null) continue;
                standardParameterCache.add("replenishment");
            }
            List extendedParameterElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems/taskSchedulers/parentAssociation/parameterExtensions|./mappingModel/taskAllocation/parameterExtensions", Element.class, (Namespace[])new Namespace[]{am, xsi});
            for (Element elem : extendedParameterElements) {
                String name = elem.getAttributeValue("key");
                extendedParameterCache.add(name);
            }
        }
    }
}

