/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters096.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.5", "output_model_version=0.9.6"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final String AM = "am";
    private static final String XSI = "xsi";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.5 to 0.9.6 : Executing Sw converter for model file : {0}", new Object[]{targetFile.getName()});
        this.basicConvert(targetFile, filename2documentMap);
    }

    public void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateCustomPropsToCounter(rootElement);
        this.updateModeConditions(rootElement);
    }

    private void updateModeConditions(Element rootElement) {
        this.updateModeCondition(rootElement);
        this.updateModeConditionConjunction(rootElement);
    }

    private void updateModeCondition(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/executionCondition//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/executionCondition//entries[@xsi:type=\"am:ModeCondition\"]");
        List modeCondition = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element element : modeCondition) {
            element.setAttribute("type", "am:ModeValueCondition", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        }
    }

    private void updateModeConditionConjunction(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/executionCondition//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/executionCondition//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        List modeConditions = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element element : modeConditions) {
            List entries = element.getChildren("entries");
            for (Element entry : entries) {
                entry.setAttribute("type", "am:ModeValueCondition", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            }
        }
    }

    private void updateCustomPropsToCounter(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        List customProps = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element element : customProps) {
            Element parentElement = element.getParentElement();
            ArrayList customProperties = new ArrayList(parentElement.getChildren("customProperties"));
            Element counter = new Element("counter");
            parentElement.addContent((Content)counter);
            for (Element prop : customProperties) {
                if (prop.getAttributeValue(KEY).equals("counter-prescaler")) {
                    counter.setAttribute("prescaler", prop.getChild(VALUE).getAttributeValue(VALUE));
                    prop.detach();
                    continue;
                }
                if (!prop.getAttributeValue(KEY).equals("counter-offset")) continue;
                counter.setAttribute("offset", prop.getChild(VALUE).getAttributeValue(VALUE));
                prop.detach();
            }
        }
    }
}

