/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters097.utils;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.6", "output_model_version=0.9.7"})
public class AmltModelReferencePostProcessor
implements IPostProcessor {
    @Reference
    SessionLogger logger;

    public void process(Map<File, Document> fileDocumentMapping) {
        if (fileDocumentMapping.keySet().size() > 1) {
            return;
        }
        if (this.logger != null) {
            this.logger.info("Start Amlt Model Reference processing from 0.9.6 to 0.9.7", new Object[0]);
        }
        for (Document document : fileDocumentMapping.values()) {
            this.postProcessAmltRefs(document.getRootElement());
        }
        if (this.logger != null) {
            this.logger.info("End Amlt Model Reference processing from 0.9.6 to 0.9.7", new Object[0]);
        }
    }

    private void postProcessAmltRefs(Element rootElement) {
        List hrefs = HelperUtil.getXpathResult((Element)rootElement, (String)".//*[@href]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)ModelVersion._097.getVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : hrefs) {
            Element parentElement = element.getParentElement();
            String hrefValue = element.getAttributeValue("href", AmaltheaNamespaceRegistry.getNamespace((String)ModelVersion._097.getVersion(), (String)"amlt"));
            hrefValue = hrefValue.replaceFirst("amlt:/#", "");
            hrefValue = hrefValue.replaceFirst("amlt://#", "");
            Attribute modelRefAttribute = new Attribute(element.getName(), hrefValue);
            parentElement.getAttributes().add(modelRefAttribute);
            element.detach();
        }
    }
}

