/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Logger;
import org.eclipse.draw3d.LightweightSystem3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DException;
import org.eclipse.draw3d.graphics3d.Graphics3DRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;

public class Draw3DCanvas
extends GLCanvas {
    private static final Logger log = Logger.getLogger(Draw3DCanvas.class.getName());

    public static Draw3DCanvas createCanvas(Composite i_parent, int i_style, LightweightSystem3D lightweightSystem3D) {
        if (lightweightSystem3D == null) {
            throw new NullPointerException("lightweightSystem3D must not be null");
        }
        GLData data = new GLData();
        data.doubleBuffer = true;
        data.depthSize = 1;
        data.sampleBuffers = 1;
        data.samples = 4;
        try {
            return new Draw3DCanvas(i_parent, i_style, data, lightweightSystem3D);
        }
        catch (SWTException ex) {
            if (ex.code == 38) {
                data.sampleBuffers = 0;
                data.samples = 0;
                return new Draw3DCanvas(i_parent, i_style, data, lightweightSystem3D);
            }
            throw ex;
        }
    }

    protected Draw3DCanvas(Composite i_parent, int i_style, GLData i_data, LightweightSystem3D lightweightSystem3D) {
        super(i_parent, i_style, i_data);
        this.setDefaultRenderer(lightweightSystem3D);
    }

    protected void setDefaultRenderer(LightweightSystem3D lightweightSystem3D) {
        Graphics3DDescriptor descr = Graphics3DRegistry.getDefaultScreenRenderer();
        Graphics3D g3d = descr.createInstance((GLCanvas)this);
        RenderContext renderContext = lightweightSystem3D.getRenderContext();
        renderContext.setGraphics3D(g3d);
        this.setCurrent();
        try {
            g3d.useContext((Object)this);
        }
        catch (Graphics3DException ex) {
            log.severe(ex.toString());
            throw new RuntimeException("caught exception while setting GL context", ex);
        }
        g3d.glEnable(3553);
        g3d.glEnable(32925);
        g3d.glEnable(2884);
        g3d.glBlendFunc(770, 771);
        g3d.glShadeModel(7424);
        g3d.glEnable(3042);
        g3d.glEnable(2929);
        g3d.glClearDepth(1.0);
        g3d.glPixelStorei(3333, 1);
        g3d.glPixelStorei(3317, 1);
    }
}

