/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;
import org.eclipse.draw3d.geometry.BoundingBox;
import org.eclipse.draw3d.geometry.BoundingBoxImpl;
import org.eclipse.draw3d.geometry.Matrix2f;
import org.eclipse.draw3d.geometry.Matrix2fImpl;
import org.eclipse.draw3d.geometry.Matrix3f;
import org.eclipse.draw3d.geometry.Matrix3fImpl;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Matrix4fImpl;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.ParaxialBoundingBoxImpl;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DUtil;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.geometry.Vector2fImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.geometry.Vector4f;
import org.eclipse.draw3d.geometry.Vector4fImpl;

public class Math3DCache {
    private static final Logger log = Logger.getLogger(Math3DCache.class.getName());
    private static final Queue<BoundingBox> m_boundingBox = new LinkedList<BoundingBox>();
    private static int m_boundingBoxCounter = 0;
    protected static boolean m_count = true;
    protected static int m_counterThreshold = 100;
    protected static int m_instanceThreshold = 100;
    private static final Queue<Matrix2f> m_matrix2f = new LinkedList<Matrix2f>();
    private static int m_matrix2fCounter = 0;
    private static final Queue<Matrix3f> m_matrix3f = new LinkedList<Matrix3f>();
    private static int m_matrix3fCounter = 0;
    private static final Queue<Matrix4f> m_matrix4f = new LinkedList<Matrix4f>();
    private static int m_matrix4fCounter = 0;
    private static final Queue<ParaxialBoundingBox> m_paraxialBoundingBox = new LinkedList<ParaxialBoundingBox>();
    private static int m_paraxialBoundingBoxCounter = 0;
    private static final Queue<Position3D> m_position3D = new LinkedList<Position3D>();
    private static int m_position3DCounter = 0;
    protected static boolean m_synchronized = false;
    private static final Queue<Vector2f> m_vector2f = new LinkedList<Vector2f>();
    private static int m_vector2fCounter = 0;
    private static final Queue<Vector3f> m_vector3f = new LinkedList<Vector3f>();
    private static int m_vector3fCounter = 0;
    private static final Queue<Vector4f> m_vector4f = new LinkedList<Vector4f>();
    private static int m_vector4fCounter = 0;

    private static BoundingBox createBoundingBox() {
        if (m_count && ++m_boundingBoxCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " bounding boxes, are you properly returning them?");
        }
        return new BoundingBoxImpl();
    }

    private static Matrix2fImpl createMatrix2f() {
        if (m_count && ++m_matrix2fCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " 2f matrices, are you properly returning them?");
        }
        return new Matrix2fImpl();
    }

    private static Matrix3fImpl createMatrix3f() {
        if (m_count && ++m_matrix3fCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " 3f matrices, are you properly returning them?");
        }
        return new Matrix3fImpl();
    }

    private static Matrix4fImpl createMatrix4f() {
        if (m_count && ++m_matrix4fCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " 4f matrices, are you properly returning them?");
        }
        return new Matrix4fImpl();
    }

    private static ParaxialBoundingBoxImpl createParaxialBoundingBox() {
        if (m_count && ++m_paraxialBoundingBoxCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " paraxial bounding boxes, are you properly returning them?");
        }
        return new ParaxialBoundingBoxImpl();
    }

    private static Position3D createPosition3D() {
        if (m_count && ++m_position3DCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " 3D positions, are you properly returning them?");
        }
        return Position3DUtil.createAbsolutePosition();
    }

    private static Vector2fImpl createVector2f() {
        if (m_count && ++m_vector2fCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " 2f vectors, are you properly returning them?");
        }
        return new Vector2fImpl();
    }

    private static Vector3fImpl createVector3f() {
        if (m_count && ++m_vector3fCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " 3f vectors, are you properly returning them?");
        }
        return new Vector3fImpl();
    }

    private static Vector4fImpl createVector4f() {
        if (m_count && ++m_vector4fCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " 4f vectors, are you properly returning them?");
        }
        return new Vector4fImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BoundingBox getBoundingBox() {
        if (m_synchronized) {
            Queue<BoundingBox> queue = m_boundingBox;
            synchronized (queue) {
                if (m_boundingBox.isEmpty()) {
                    return Math3DCache.createBoundingBox();
                }
                return m_boundingBox.remove();
            }
        }
        if (m_boundingBox.isEmpty()) {
            return Math3DCache.createBoundingBox();
        }
        return m_boundingBox.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matrix2f getMatrix2f() {
        if (m_synchronized) {
            Queue<Matrix2f> queue = m_matrix2f;
            synchronized (queue) {
                if (m_matrix2f.isEmpty()) {
                    return Math3DCache.createMatrix2f();
                }
                return m_matrix2f.remove();
            }
        }
        if (m_matrix2f.isEmpty()) {
            return Math3DCache.createMatrix2f();
        }
        return m_matrix2f.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matrix3f getMatrix3f() {
        if (m_synchronized) {
            Queue<Matrix3f> queue = m_matrix3f;
            synchronized (queue) {
                if (m_matrix3f.isEmpty()) {
                    return Math3DCache.createMatrix3f();
                }
                return m_matrix3f.remove();
            }
        }
        if (m_matrix3f.isEmpty()) {
            return Math3DCache.createMatrix3f();
        }
        return m_matrix3f.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matrix4f getMatrix4f() {
        if (m_synchronized) {
            Queue<Matrix4f> queue = m_matrix4f;
            synchronized (queue) {
                if (m_matrix4f.isEmpty()) {
                    return Math3DCache.createMatrix4f();
                }
                return m_matrix4f.remove();
            }
        }
        if (m_matrix4f.isEmpty()) {
            return Math3DCache.createMatrix4f();
        }
        return m_matrix4f.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParaxialBoundingBox getParaxialBoundingBox() {
        if (m_synchronized) {
            Queue<ParaxialBoundingBox> queue = m_paraxialBoundingBox;
            synchronized (queue) {
                if (m_paraxialBoundingBox.isEmpty()) {
                    return Math3DCache.createParaxialBoundingBox();
                }
                return m_paraxialBoundingBox.remove();
            }
        }
        if (m_paraxialBoundingBox.isEmpty()) {
            return Math3DCache.createParaxialBoundingBox();
        }
        return m_paraxialBoundingBox.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Position3D getPosition3D() {
        if (m_synchronized) {
            Queue<Position3D> queue = m_position3D;
            synchronized (queue) {
                if (m_position3D.isEmpty()) {
                    return Math3DCache.createPosition3D();
                }
                return m_position3D.remove();
            }
        }
        if (m_position3D.isEmpty()) {
            return Math3DCache.createPosition3D();
        }
        return m_position3D.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector2f getVector2f() {
        if (m_synchronized) {
            Queue<Vector2f> queue = m_vector2f;
            synchronized (queue) {
                if (m_vector2f.isEmpty()) {
                    return Math3DCache.createVector2f();
                }
                return m_vector2f.remove();
            }
        }
        if (m_vector2f.isEmpty()) {
            return Math3DCache.createVector2f();
        }
        return m_vector2f.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector3f getVector3f() {
        if (m_synchronized) {
            Queue<Vector3f> queue = m_vector3f;
            synchronized (queue) {
                if (m_vector3f.isEmpty()) {
                    return Math3DCache.createVector3f();
                }
                return m_vector3f.remove();
            }
        }
        if (m_vector3f.isEmpty()) {
            return Math3DCache.createVector3f();
        }
        return m_vector3f.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector4f getVector4f() {
        if (m_synchronized) {
            Queue<Vector4f> queue = m_vector4f;
            synchronized (queue) {
                if (m_vector4f.isEmpty()) {
                    return Math3DCache.createVector4f();
                }
                return m_vector4f.remove();
            }
        }
        if (m_vector4f.isEmpty()) {
            return Math3DCache.createVector4f();
        }
        return m_vector4f.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnBoundingBox(BoundingBox ... i_bs) {
        if (m_synchronized) {
            Queue<BoundingBox> queue = m_boundingBox;
            synchronized (queue) {
                BoundingBox[] boundingBoxArray = i_bs;
                int n = i_bs.length;
                int n2 = 0;
                while (n2 < n) {
                    BoundingBox b = boundingBoxArray[n2];
                    if (b != null) {
                        m_boundingBox.offer(b);
                    }
                    ++n2;
                }
            }
        } else {
            BoundingBox[] boundingBoxArray = i_bs;
            int n = i_bs.length;
            int n3 = 0;
            while (n3 < n) {
                BoundingBox b = boundingBoxArray[n3];
                if (b != null) {
                    m_boundingBox.offer(b);
                }
                ++n3;
            }
        }
        if (m_count && m_boundingBox.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " bounding boxes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnMatrix2f(Matrix2f ... i_ms) {
        if (m_synchronized) {
            Queue<Matrix2f> queue = m_matrix2f;
            synchronized (queue) {
                Matrix2f[] matrix2fArray = i_ms;
                int n = i_ms.length;
                int n2 = 0;
                while (n2 < n) {
                    Matrix2f m = matrix2fArray[n2];
                    if (m != null) {
                        m_matrix2f.offer(m);
                    }
                    ++n2;
                }
            }
        } else {
            Matrix2f[] matrix2fArray = i_ms;
            int n = i_ms.length;
            int n3 = 0;
            while (n3 < n) {
                Matrix2f m = matrix2fArray[n3];
                if (m != null) {
                    m_matrix2f.offer(m);
                }
                ++n3;
            }
        }
        if (m_count && m_matrix2f.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " 2f matrices");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnMatrix3f(Matrix3f ... i_ms) {
        if (m_synchronized) {
            Queue<Matrix3f> queue = m_matrix3f;
            synchronized (queue) {
                Matrix3f[] matrix3fArray = i_ms;
                int n = i_ms.length;
                int n2 = 0;
                while (n2 < n) {
                    Matrix3f m = matrix3fArray[n2];
                    if (m != null) {
                        m_matrix3f.offer(m);
                    }
                    ++n2;
                }
            }
        } else {
            Matrix3f[] matrix3fArray = i_ms;
            int n = i_ms.length;
            int n3 = 0;
            while (n3 < n) {
                Matrix3f m = matrix3fArray[n3];
                if (m != null) {
                    m_matrix3f.offer(m);
                }
                ++n3;
            }
        }
        if (m_count && m_matrix3f.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " 3f matrices");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnMatrix4f(Matrix4f ... i_ms) {
        if (m_synchronized) {
            Queue<Matrix4f> queue = m_matrix4f;
            synchronized (queue) {
                Matrix4f[] matrix4fArray = i_ms;
                int n = i_ms.length;
                int n2 = 0;
                while (n2 < n) {
                    Matrix4f m = matrix4fArray[n2];
                    if (m != null) {
                        m_matrix4f.offer(m);
                    }
                    ++n2;
                }
            }
        } else {
            Matrix4f[] matrix4fArray = i_ms;
            int n = i_ms.length;
            int n3 = 0;
            while (n3 < n) {
                Matrix4f m = matrix4fArray[n3];
                if (m != null) {
                    m_matrix4f.offer(m);
                }
                ++n3;
            }
        }
        if (m_count && m_matrix4f.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " 4f matrices");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnParaxialBoundingBox(ParaxialBoundingBox ... i_ps) {
        if (m_synchronized) {
            Queue<ParaxialBoundingBox> queue = m_paraxialBoundingBox;
            synchronized (queue) {
                ParaxialBoundingBox[] paraxialBoundingBoxArray = i_ps;
                int n = i_ps.length;
                int n2 = 0;
                while (n2 < n) {
                    ParaxialBoundingBox p = paraxialBoundingBoxArray[n2];
                    if (p != null) {
                        m_paraxialBoundingBox.offer(p);
                    }
                    ++n2;
                }
            }
        } else {
            ParaxialBoundingBox[] paraxialBoundingBoxArray = i_ps;
            int n = i_ps.length;
            int n3 = 0;
            while (n3 < n) {
                ParaxialBoundingBox p = paraxialBoundingBoxArray[n3];
                if (p != null) {
                    m_paraxialBoundingBox.offer(p);
                }
                ++n3;
            }
        }
        if (m_count && m_paraxialBoundingBox.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " paraxial bounding boxes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnPosition3D(Position3D ... i_ps) {
        if (m_synchronized) {
            Queue<Position3D> queue = m_position3D;
            synchronized (queue) {
                Position3D[] position3DArray = i_ps;
                int n = i_ps.length;
                int n2 = 0;
                while (n2 < n) {
                    Position3D p = position3DArray[n2];
                    if (p != null) {
                        m_position3D.offer(p);
                    }
                    ++n2;
                }
            }
        } else {
            Position3D[] position3DArray = i_ps;
            int n = i_ps.length;
            int n3 = 0;
            while (n3 < n) {
                Position3D p = position3DArray[n3];
                if (p != null) {
                    m_position3D.offer(p);
                }
                ++n3;
            }
        }
        if (m_count && m_position3D.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " 3D positions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnVector2f(Vector2f ... i_vs) {
        if (m_synchronized) {
            Queue<Vector2f> queue = m_vector2f;
            synchronized (queue) {
                Vector2f[] vector2fArray = i_vs;
                int n = i_vs.length;
                int n2 = 0;
                while (n2 < n) {
                    Vector2f v = vector2fArray[n2];
                    if (v != null) {
                        m_vector2f.offer(v);
                    }
                    ++n2;
                }
            }
        } else {
            Vector2f[] vector2fArray = i_vs;
            int n = i_vs.length;
            int n3 = 0;
            while (n3 < n) {
                Vector2f v = vector2fArray[n3];
                if (v != null) {
                    m_vector2f.offer(v);
                }
                ++n3;
            }
        }
        if (m_count && m_vector2f.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " 2f vectors");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnVector3f(Vector3f ... i_vs) {
        if (m_synchronized) {
            Queue<Vector3f> queue = m_vector3f;
            synchronized (queue) {
                Vector3f[] vector3fArray = i_vs;
                int n = i_vs.length;
                int n2 = 0;
                while (n2 < n) {
                    Vector3f v = vector3fArray[n2];
                    if (v != null) {
                        m_vector3f.offer(v);
                    }
                    ++n2;
                }
            }
        } else {
            Vector3f[] vector3fArray = i_vs;
            int n = i_vs.length;
            int n3 = 0;
            while (n3 < n) {
                Vector3f v = vector3fArray[n3];
                if (v != null) {
                    m_vector3f.offer(v);
                }
                ++n3;
            }
        }
        if (m_count && m_vector3f.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " 3f vectors");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnVector4f(Vector4f ... i_vs) {
        if (m_synchronized) {
            Queue<Vector4f> queue = m_vector4f;
            synchronized (queue) {
                Vector4f[] vector4fArray = i_vs;
                int n = i_vs.length;
                int n2 = 0;
                while (n2 < n) {
                    Vector4f v = vector4fArray[n2];
                    if (v != null) {
                        m_vector4f.offer(v);
                    }
                    ++n2;
                }
            }
        } else {
            Vector4f[] vector4fArray = i_vs;
            int n = i_vs.length;
            int n3 = 0;
            while (n3 < n) {
                Vector4f v = vector4fArray[n3];
                if (v != null) {
                    m_vector4f.offer(v);
                }
                ++n3;
            }
        }
        if (m_count && m_vector4f.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " 4f vectors");
        }
    }
}

