/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.ide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.metaabm.SImplementationMode;
import org.metaabm.ide.CustomMetaABMModelWizard;
import org.metaabm.ide.MetaABMModelerPlugin;

public class CustomModelWizardInitialObjectCreationPage
extends WizardPage {
    protected Text modelNameField;
    protected Text modelPackageField;
    protected Text baseDirField;
    protected List<String> encodings;
    CustomMetaABMModelWizard wizard;
    protected Combo encodingField;
    protected Combo modeField;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CustomModelWizardInitialObjectCreationPage.this.setPageComplete(CustomModelWizardInitialObjectCreationPage.this.validatePage());
        }
    };
    private Composite composite;

    public CustomModelWizardInitialObjectCreationPage(CustomMetaABMModelWizard parent, String pageId) {
        super(pageId);
        this.wizard = parent;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        this.composite.setLayoutData((Object)data);
        this.createLabel("_UI_MetaABMModelWizard_packageLabel");
        this.modelPackageField = new Text(this.composite, 4);
        this.createField((Control)this.modelPackageField);
        this.modelPackageField.addModifyListener(this.validator);
        this.createLabel("_UI_MetaABMModelWizard_nameLabel");
        this.modelNameField = new Text(this.composite, 4);
        this.createField((Control)this.modelNameField);
        this.modelNameField.addModifyListener(this.validator);
        this.createLabel("_UI_MetaABMModelWizard_modeLabel");
        this.modeField = new Combo(this.composite, 8);
        this.createField((Control)this.modeField);
        for (Object mode : SImplementationMode.VALUES) {
            this.modeField.add(((SImplementationMode)mode).getName());
        }
        this.modeField.select(0);
        this.createLabel("_UI_MetaABMModelWizard_baseDirLabel");
        this.baseDirField = new Text(this.composite, 4);
        this.createField((Control)this.baseDirField);
        this.baseDirField.setText(((CustomMetaABMModelWizard)this.getWizard()).getDefaultBaseDir());
        this.baseDirField.setToolTipText("This is the project relative base directory from which file locations will be taken. For example, by default java source files will be placed in [project directory]/[base directory]/srcgen. Unless you want to create metaABM models in a different project or location, leave this field blank.");
        this.createLabel("_UI_XMLEncoding");
        this.encodingField = new Combo(this.composite, 2048);
        this.createField((Control)this.encodingField);
        Iterator<String> i = this.getEncodings().iterator();
        while (i.hasNext()) {
            this.encodingField.add(i.next());
        }
        this.encodingField.select(0);
        this.encodingField.addModifyListener(this.validator);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)this.composite);
    }

    private void createField(Control control) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)data);
    }

    private void createLabel(String resource) {
        Label containerLabel = new Label(this.composite, 16384);
        containerLabel.setText(String.valueOf(MetaABMModelerPlugin.INSTANCE.getString(resource)) + ":");
        GridData data = new GridData();
        data.horizontalAlignment = 1;
        containerLabel.setLayoutData((Object)data);
    }

    protected boolean validatePage() {
        return !this.modelPackageField.getText().equals("") && !this.modelNameField.getText().equals("") && this.getEncodings().contains(this.encodingField.getText());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.modelPackageField.getText().equals("")) {
                this.modelPackageField.setText(this.wizard.getModelFile().getProject().getName());
            }
            if (this.modelNameField.getText().equals("")) {
                this.modelNameField.setText(this.wizard.getModelFile().getName().replace(".metaabm", ""));
            }
            this.modelNameField.setFocus();
        }
    }

    public String getEncoding() {
        return this.encodingField.getText();
    }

    public String getModelName() {
        return this.modelNameField.getText();
    }

    public String getBaseDir() {
        return this.baseDirField.getText();
    }

    public String getPackage() {
        return this.modelPackageField.getText();
    }

    public String getMode() {
        return this.modeField.getText();
    }

    public void setBaseDir(String dir) {
        this.baseDirField.setText(dir);
    }

    protected Collection<String> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(MetaABMModelerPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
            while (stringTokenizer.hasMoreTokens()) {
                this.encodings.add(stringTokenizer.nextToken());
            }
        }
        return this.encodings;
    }
}

