/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.zest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.zest.layouts.algorithms.ContinuousLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class SpringPartitionLayoutAlgorithm
extends ContinuousLayoutAlgorithm {
    private static final boolean DEFAULT_ANCHOR = false;
    public static final int DEFAULT_SPRING_ITERATIONS = 500;
    public static final long MAX_SPRING_TIME = 500L;
    public static final boolean DEFAULT_SPRING_RANDOM = true;
    public static final boolean DEFAULT_SPRING_IGNORE_UNCON = true;
    public static final boolean DEFAULT_SPRING_SEPARATE_COMPONENTS = true;
    public static final double DEFAULT_SPRING_MOVE = 1.0;
    public static final double DEFAULT_SPRING_STRAIN = 1.0;
    public static final double DEFAULT_SPRING_LENGTH = 1.0;
    public static final double DEFAULT_SPRING_GRAVITATION = 1.0;
    private static int sprIterations = 500;
    private static long maxTimeMS = 500L;
    private static boolean sprRandom = true;
    protected static final double MIN_DISTANCE = 0.001;
    protected static final double EPSILON = 0.001;
    private static double sprMove = 1.0;
    private static double sprStrain = 1.0;
    private static double sprLength = 1.0;
    private static double sprGravitation = 1.0;
    private double largestMovement = 0.0;
    private Map srcDestToNumRelsMap;
    private Map srcDestToRelsAvgWeightMap;
    private static Map relTypeToWeightMap = new HashMap();
    private int iteration;
    private int[][] srcDestToNumRels;
    private double[][] srcDestToRelsAvgWeight;
    private double[] tempLocationsX = new double[0];
    private double[] tempLocationsY = new double[0];
    private Map<InternalNode, Integer> indexForEntity = new HashMap<InternalNode, Integer>();
    private double[] forcesX = new double[0];
    private double[] forcesY = new double[0];
    private boolean[] anchors;
    private DisplayIndependentRectangle bounds = null;
    Date date = null;
    private long startTime = 0L;
    private boolean clearLocation = true;
    Map<InternalNode, Collection<InternalNode>> targetsForNode = new HashMap<InternalNode, Collection<InternalNode>>();

    public SpringPartitionLayoutAlgorithm(int styles) {
        super(styles);
        this.srcDestToNumRelsMap = new HashMap();
        this.srcDestToRelsAvgWeightMap = new HashMap();
        this.date = new Date();
    }

    public SpringPartitionLayoutAlgorithm() {
        this(0);
    }

    public void setLayoutArea(double x, double y, double width, double height) {
        this.bounds = new DisplayIndependentRectangle(x, y, width, height);
    }

    public void setSpringMove(double move) {
        sprMove = move;
    }

    public double getSpringMove() {
        return sprMove;
    }

    public void setSpringStrain(double strain) {
        sprStrain = strain;
    }

    public double getSpringStrain() {
        return sprStrain;
    }

    public void setSpringLength(double length) {
        sprLength = length;
    }

    public long getSpringTimeout() {
        return maxTimeMS;
    }

    public void setSpringTimeout(long timeout) {
        maxTimeMS = timeout;
    }

    public double getSpringLength() {
        return sprLength;
    }

    public void setSpringGravitation(double gravitation) {
        sprGravitation = gravitation;
    }

    public double getSpringGravitation() {
        return sprGravitation;
    }

    public void setIterations(int iterations) {
        sprIterations = iterations;
    }

    public int getIterations() {
        return sprIterations;
    }

    public void setRandom(boolean random) {
        sprRandom = random;
    }

    public boolean getRandom() {
        return sprRandom;
    }

    public void setWeight(String relType, double weight) {
        relTypeToWeightMap.put(relType, new Double(weight));
    }

    public double getWeight(String relType) {
        Double weight = (Double)relTypeToWeightMap.get(relType);
        return weight == null ? 1.0 : weight;
    }

    public void setDefaultConditions() {
    }

    private void reset(InternalNode[] entitiesToLayout) {
        this.resetTemps(entitiesToLayout);
        this.anchors = null;
        this.setDefaultConditions();
        this.srcDestToNumRelsMap = new HashMap();
        this.srcDestToRelsAvgWeightMap = new HashMap();
        relTypeToWeightMap = new HashMap();
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        this.bounds = new DisplayIndependentRectangle(x, y, width, height);
        this.resetTemps(entitiesToLayout);
        this.anchors = new boolean[entitiesToLayout.length];
        int i = 0;
        while (i < entitiesToLayout.length) {
            this.anchors[i] = false;
            ++i;
        }
        i = 0;
        while (i < relationshipsToConsider.length) {
            InternalRelationship layoutRelationship = relationshipsToConsider[i];
            this.addRelation(layoutRelationship);
            ++i;
        }
        this.preCompute(entitiesToLayout);
        this.startTime = this.date.getTime();
    }

    private void resetTemps(InternalNode[] entitiesToLayout) {
        if (this.tempLocationsX.length != entitiesToLayout.length) {
            this.tempLocationsX = Arrays.copyOf(this.tempLocationsX, entitiesToLayout.length);
            this.tempLocationsY = Arrays.copyOf(this.tempLocationsY, entitiesToLayout.length);
        }
        this.forcesX = new double[entitiesToLayout.length];
        this.forcesY = new double[entitiesToLayout.length];
        int i = 0;
        InternalNode[] internalNodeArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        int n2 = 0;
        while (n2 < n) {
            InternalNode internalNode = internalNodeArray[n2];
            this.indexForEntity.put(internalNode, i++);
            ++n2;
        }
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
        this.reset(entitiesToLayout);
    }

    private void addRelation(InternalRelationship layoutRelationship) {
        if (layoutRelationship == null) {
            throw new IllegalArgumentException("The arguments can not be null!");
        }
        this.addToRelationMap(layoutRelationship.getSource(), layoutRelationship.getDestination());
        this.addToRelationMap(layoutRelationship.getDestination(), layoutRelationship.getSource());
        double weight = layoutRelationship.getWeight();
        weight = weight <= 0.0 ? 0.1 : weight;
        String key1 = String.valueOf(layoutRelationship.getSource().toString()) + layoutRelationship.getDestination().toString();
        String key2 = String.valueOf(layoutRelationship.getDestination().toString()) + layoutRelationship.getSource().toString();
        String[] keys = new String[]{key1, key2};
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Integer count = (Integer)this.srcDestToNumRelsMap.get(key);
            Double avgWeight = (Double)this.srcDestToRelsAvgWeightMap.get(key);
            if (count == null) {
                count = new Integer(1);
                avgWeight = new Double(weight);
            } else {
                int newCount = count + 1;
                double newAverage = (avgWeight * count.doubleValue() + weight) / (double)newCount;
                avgWeight = new Double(newAverage);
                count = new Integer(newCount);
            }
            this.srcDestToNumRelsMap.put(key, count);
            this.srcDestToRelsAvgWeightMap.put(key, avgWeight);
            ++i;
        }
    }

    private void addToRelationMap(InternalNode source, InternalNode target) {
        Collection<InternalNode> targets = this.targetsForNode.get(source);
        if (targets == null) {
            targets = new ArrayList<InternalNode>();
            this.targetsForNode.put(source, targets);
        }
        targets.add(target);
    }

    private void preCompute(InternalNode[] entitiesToLayout) {
        this.srcDestToNumRels = new int[entitiesToLayout.length][entitiesToLayout.length];
        this.srcDestToRelsAvgWeight = new double[entitiesToLayout.length][entitiesToLayout.length];
        int i = 0;
        while (i < entitiesToLayout.length - 1) {
            InternalNode layoutEntity1 = entitiesToLayout[i];
            int j = i + 1;
            while (j < entitiesToLayout.length) {
                InternalNode layoutEntity2 = entitiesToLayout[j];
                this.srcDestToNumRels[i][j] = this.numRelations(layoutEntity1, layoutEntity2);
                int[] nArray = this.srcDestToNumRels[i];
                int n = j;
                nArray[n] = nArray[n] + this.numRelations(layoutEntity2, layoutEntity1);
                this.srcDestToRelsAvgWeight[i][j] = this.avgWeight(layoutEntity1, layoutEntity2);
                ++j;
            }
            ++i;
        }
        this.initialPlacement(entitiesToLayout);
        this.iteration = 1;
        this.largestMovement = Double.MAX_VALUE;
    }

    private void initialPlacement(InternalNode[] entitiesToLayout) {
        if (this.clearLocation) {
            if (sprRandom) {
                this.placeRandomly(entitiesToLayout);
            } else {
                this.convertToUnitCoordinates(entitiesToLayout);
            }
        }
    }

    protected DisplayIndependentRectangle getLayoutBoundsTemp(InternalNode[] entitiesToLayout, boolean includeNodeSize) {
        double rightSide = Double.MIN_VALUE;
        double bottomSide = Double.MIN_VALUE;
        double leftSide = Double.MAX_VALUE;
        double topSide = Double.MAX_VALUE;
        int i = 0;
        while (i < entitiesToLayout.length) {
            double x = this.tempLocationsX[i];
            double y = this.tempLocationsY[i];
            leftSide = Math.min(x, leftSide);
            topSide = Math.min(y, topSide);
            rightSide = Math.max(x, rightSide);
            bottomSide = Math.max(y, bottomSide);
            ++i;
        }
        return new DisplayIndependentRectangle(leftSide, topSide, rightSide - leftSide, bottomSide - topSide);
    }

    protected void convertNodePositionsBack(int i, InternalNode entityToConvert, double px, double py, double screenWidth, double screenHeight, DisplayIndependentRectangle layoutBounds) {
        if (px > screenWidth) {
            px = screenWidth;
        }
        if (py > screenHeight) {
            py = screenHeight;
        }
        if (px < 0.0) {
            px = 1.0;
        }
        if (py < 0.0) {
            py = 1.0;
        }
        double x = px / screenWidth * layoutBounds.width + layoutBounds.x;
        double y = py / screenHeight * layoutBounds.height + layoutBounds.y;
        this.tempLocationsX[i] = x;
        this.tempLocationsY[i] = y;
        entityToConvert.getInternalX();
    }

    private void checkPreferredLocation(InternalNode[] entitiesToLayout, DisplayIndependentRectangle realBounds) {
        double borderWidth = Math.min(realBounds.width, realBounds.height) / 10.0;
        DisplayIndependentRectangle screenBounds = new DisplayIndependentRectangle(realBounds.x + borderWidth / 2.0, realBounds.y + borderWidth / 2.0, realBounds.width - borderWidth, realBounds.height - borderWidth);
        DisplayIndependentRectangle layoutBounds = this.getLayoutBoundsTemp(entitiesToLayout, false);
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode layoutEntity = entitiesToLayout[i];
            if (layoutEntity.hasPreferredLocation()) {
                this.convertNodePositionsBack(i, layoutEntity, layoutEntity.getPreferredX(), layoutEntity.getPreferredY(), screenBounds.width, screenBounds.height, layoutBounds);
            }
            ++i;
        }
    }

    private void setSprIterationsBasedOnTime() {
        if (maxTimeMS <= 0L) {
            return;
        }
        long currentTime = this.date.getTime();
        double fractionComplete = (double)(currentTime - this.startTime) / (double)maxTimeMS;
        int currentIteration = (int)(fractionComplete * (double)sprIterations);
        if (currentIteration > this.iteration) {
            this.iteration = currentIteration;
        }
    }

    protected boolean performAnotherNonContinuousIteration() {
        this.setSprIterationsBasedOnTime();
        return this.iteration <= sprIterations && this.largestMovement >= sprMove;
    }

    protected int getCurrentLayoutStep() {
        return this.iteration;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return sprIterations;
    }

    protected void computeOneIteration(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        DisplayIndependentRectangle oldBounds = this.bounds;
        if (this.bounds == null) {
            this.bounds = new DisplayIndependentRectangle(x, y, width, height);
        }
        this.checkPreferredLocation(entitiesToLayout, this.bounds);
        this.computeForces(entitiesToLayout);
        this.largestMovement = Double.MAX_VALUE;
        this.computePositions(entitiesToLayout);
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode layoutEntity = entitiesToLayout[i];
            layoutEntity.setInternalLocation(this.tempLocationsX[i], this.tempLocationsY[i]);
            ++i;
        }
        if (!oldBounds.equals(this.bounds) || this.iteration % 10 == 0) {
            this.defaultFitWithinBounds(entitiesToLayout, this.bounds);
        }
        ++this.iteration;
    }

    public void placeRandomly(InternalNode[] entitiesToLayout) {
        if (entitiesToLayout.length == 1) {
            this.tempLocationsX[0] = 0.5;
            this.tempLocationsY[0] = 0.5;
        } else {
            int i = 0;
            while (i < entitiesToLayout.length) {
                if (this.tempLocationsX[i] == 0.0 || this.tempLocationsY[i] == 0.0) {
                    if (i == 0) {
                        this.tempLocationsX[i] = 0.0;
                        this.tempLocationsY[i] = 0.0;
                    } else if (i == 1) {
                        this.tempLocationsX[i] = 1.0;
                        this.tempLocationsY[i] = 1.0;
                    } else {
                        this.tempLocationsX[i] = Math.random();
                        this.tempLocationsY[i] = Math.random();
                    }
                }
                ++i;
            }
        }
    }

    protected void computeForces(InternalNode[] entitiesToLayout) {
        int i = 0;
        while (i < entitiesToLayout.length) {
            this.forcesX[i] = 0.0;
            this.forcesY[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < entitiesToLayout.length - 1) {
            InternalNode sourceEntity = entitiesToLayout[i];
            double srcLocationX = this.tempLocationsX[i];
            double srcLocationY = this.tempLocationsY[i];
            double fx = this.forcesX[i];
            double fy = this.forcesY[i];
            int j = i + 1;
            while (j < entitiesToLayout.length) {
                InternalNode destinationEntity = entitiesToLayout[j];
                if (!destinationEntity.equals(sourceEntity)) {
                    double f;
                    double destLocationX = this.tempLocationsX[j];
                    double destLocationY = this.tempLocationsY[j];
                    double dx = srcLocationX - destLocationX;
                    double dy = srcLocationY - destLocationY;
                    double distance = Math.sqrt(dx * dx + dy * dy);
                    double distance_sq = distance * distance;
                    distance = Math.max(0.001, distance);
                    int numRels = this.srcDestToNumRels[i][j];
                    double avgWeight = this.srcDestToRelsAvgWeight[i][j];
                    if (numRels > 0) {
                        f = sprStrain * Math.log(distance / sprLength) * (double)numRels * avgWeight;
                        fx -= f * dx / distance;
                        fy -= f * dy / distance;
                    } else {
                        f = sprGravitation / distance_sq;
                        fx += f * dx / distance;
                        fy += f * dy / distance;
                    }
                    this.forcesX[j] = this.forcesX[j] - fx;
                    this.forcesY[j] = this.forcesY[j] - fy;
                }
                ++j;
            }
            this.forcesX[i] = fx;
            this.forcesY[i] = fy;
            ++i;
        }
    }

    protected void computePositions(InternalNode[] entitiesToLayout) {
        int i = 0;
        while (i < entitiesToLayout.length) {
            if (!this.anchors[i] || entitiesToLayout[i].hasPreferredLocation()) {
                double oldX = this.tempLocationsX[i];
                double oldY = this.tempLocationsY[i];
                double deltaX = sprMove * this.forcesX[i];
                double deltaY = sprMove * this.forcesY[i];
                double maxMovement = 0.2 * sprMove;
                deltaX = deltaX >= 0.0 ? Math.min(deltaX, maxMovement) : Math.max(deltaX, -maxMovement);
                deltaY = deltaY >= 0.0 ? Math.min(deltaY, maxMovement) : Math.max(deltaY, -maxMovement);
                this.largestMovement = Math.max(this.largestMovement, Math.abs(deltaX));
                this.largestMovement = Math.max(this.largestMovement, Math.abs(deltaY));
                double newX = oldX + deltaX;
                double newY = oldY + deltaY;
                this.tempLocationsX[i] = newX;
                this.tempLocationsY[i] = newY;
            }
            ++i;
        }
    }

    protected void convertToUnitCoordinates(InternalNode[] entitiesToLayout) {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode layoutEntity = entitiesToLayout[i];
            minX = Math.min(minX, layoutEntity.getInternalX());
            minY = Math.min(minY, layoutEntity.getInternalY());
            maxX = Math.max(maxX, layoutEntity.getInternalX());
            maxY = Math.max(maxY, layoutEntity.getInternalY());
            ++i;
        }
        double spanX = maxX - minX;
        double spanY = maxY - minY;
        double maxSpan = Math.max(spanX, spanY);
        if (maxSpan > 0.001) {
            int i2 = 0;
            while (i2 < entitiesToLayout.length) {
                InternalNode layoutEntity = entitiesToLayout[i2];
                double x = (layoutEntity.getInternalX() - minX) / spanX;
                double y = (layoutEntity.getInternalY() - minY) / spanY;
                this.tempLocationsX[i2] = x;
                this.tempLocationsY[i2] = y;
                ++i2;
            }
        } else {
            this.placeRandomly(entitiesToLayout);
        }
    }

    private int numRelations(Object src, Object dest) {
        String key = String.valueOf(src.toString()) + dest.toString();
        Integer count = (Integer)this.srcDestToNumRelsMap.get(key);
        int intCount = count == null ? 0 : count;
        return intCount;
    }

    private double avgWeight(Object src, Object dest) {
        String key = String.valueOf(src.toString()) + dest.toString();
        Double avgWeight = (Double)this.srcDestToRelsAvgWeightMap.get(key);
        double doubleWeight = avgWeight == null ? 1.0 : avgWeight;
        return doubleWeight;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continueous) {
        if (asynchronous && continueous) {
            return true;
        }
        if (asynchronous && !continueous) {
            return true;
        }
        if (!asynchronous && continueous) {
            return false;
        }
        return !asynchronous && !continueous;
    }
}

