/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.zest.layouts.Filter;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutItem;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.Stoppable;
import org.eclipse.zest.layouts.constraints.BasicEntityConstraint;
import org.eclipse.zest.layouts.dataStructures.BendPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;
import org.eclipse.zest.layouts.progress.ProgressEvent;
import org.eclipse.zest.layouts.progress.ProgressListener;

public abstract class AbstractLayoutAlgorithm
implements LayoutAlgorithm,
Stoppable {
    public static final int MIN_ENTITY_SIZE = 5;
    private static final int MIN_TIME_DELAY_BETWEEN_PROGRESS_EVENTS = 1;
    private Thread creationThread = Thread.currentThread();
    protected Comparator comparator;
    protected Filter filter;
    private List progressListeners = new ArrayList();
    private Calendar lastProgressEventFired = Calendar.getInstance();
    private double widthToHeightRatio = 1.0;
    private InternalNode[] internalNodes;
    private InternalRelationship[] internalRelationships;
    private double internalX;
    private double internalY;
    private double internalWidth;
    private double internalHeight;
    protected boolean internalContinuous;
    protected boolean internalAsynchronous;
    private List entitiesToRemove = new ArrayList();
    private List relationshipsToRemove = new ArrayList();
    private List entitiesToAdd = new ArrayList();
    private List relationshipsToAdd = new ArrayList();
    protected boolean layoutStopped = true;
    protected int layout_styles = 0;
    protected boolean resizeEntitiesAfterLayout = true;

    public void removeRelationships(Collection collection) {
    }

    public AbstractLayoutAlgorithm(int styles) {
        this.layout_styles = styles;
    }

    public void addEntity(LayoutEntity entity) {
        if (entity != null && !this.entitiesToAdd.contains(entity)) {
            this.entitiesToAdd.add(entity);
        }
    }

    public void addRelationship(LayoutRelationship relationship) {
        if (relationship != null && !this.relationshipsToAdd.contains(relationship)) {
            this.relationshipsToAdd.add(relationship);
        }
    }

    public void removeEntity(LayoutEntity entity) {
        if (entity != null && !this.entitiesToRemove.contains(entity)) {
            this.entitiesToRemove.add(entity);
        }
    }

    public void removeRelationship(LayoutRelationship relationship) {
        if (relationship != null && !this.relationshipsToRemove.contains(relationship)) {
            this.relationshipsToRemove.add(relationship);
        }
    }

    public void removeRelationships(List relationships) {
        this.relationshipsToRemove.addAll(relationships);
    }

    public void setStyle(int style) {
        this.layout_styles = style;
    }

    public int getStyle() {
        return this.layout_styles;
    }

    public abstract void setLayoutArea(double var1, double var3, double var5, double var7);

    protected abstract boolean isValidConfiguration(boolean var1, boolean var2);

    protected abstract void applyLayoutInternal(InternalNode[] var1, InternalRelationship[] var2, double var3, double var5, double var7, double var9);

    protected InternalNode[] updateEntities(InternalNode[] entities) {
        if (this.entitiesToRemove.size() > 0 || this.entitiesToAdd.size() > 0) {
            ArrayList<InternalNode> internalNodesList = new ArrayList<InternalNode>(Arrays.asList(entities));
            Iterator iter = this.entitiesToRemove.iterator();
            while (iter.hasNext()) {
                LayoutEntity entity = (LayoutEntity)iter.next();
                if (entity.getLayoutInformation() == null) continue;
                internalNodesList.remove(entity.getLayoutInformation());
            }
            ArrayList<InternalNode> updatedEntities = new ArrayList<InternalNode>(this.internalNodes.length - this.entitiesToRemove.size() + this.entitiesToAdd.size());
            int i = 0;
            while (i < this.internalNodes.length) {
                InternalNode node = this.internalNodes[i];
                if (this.entitiesToRemove.contains(node.getLayoutEntity())) {
                    this.entitiesToRemove.remove(node.getLayoutEntity());
                } else {
                    updatedEntities.add(node);
                }
                ++i;
            }
            this.entitiesToRemove.clear();
            LayoutEntity[] entitiesArray = new LayoutEntity[this.entitiesToAdd.size()];
            entitiesArray = this.entitiesToAdd.toArray(entitiesArray);
            InternalNode[] newNodes = this.createInternalNodes(entitiesArray);
            int i2 = 0;
            while (i2 < newNodes.length) {
                internalNodesList.add(newNodes[i2]);
                updatedEntities.add(newNodes[i2]);
                ++i2;
            }
            this.entitiesToAdd.clear();
            entities = new InternalNode[internalNodesList.size()];
            entities = internalNodesList.toArray(entities);
            this.internalNodes = new InternalNode[updatedEntities.size()];
            this.internalNodes = updatedEntities.toArray(this.internalNodes);
        }
        return entities;
    }

    protected InternalRelationship[] updateRelationships(InternalRelationship[] relationships) {
        if (this.relationshipsToRemove.size() > 0 || this.relationshipsToAdd.size() > 0) {
            ArrayList<InternalRelationship> internalRelsList = new ArrayList<InternalRelationship>(Arrays.asList(relationships));
            if (this.relationshipsToRemove.size() > 0) {
                Iterator iter = this.relationshipsToRemove.iterator();
                while (iter.hasNext()) {
                    LayoutRelationship relation = (LayoutRelationship)iter.next();
                    if (relation.getLayoutInformation() == null) continue;
                    internalRelsList.remove(relation.getLayoutInformation());
                }
            }
            ArrayList<InternalRelationship> updatedRelationships = new ArrayList<InternalRelationship>(this.internalRelationships.length - this.relationshipsToRemove.size() + this.relationshipsToAdd.size());
            int i = 0;
            while (i < this.internalRelationships.length) {
                InternalRelationship relation = this.internalRelationships[i];
                if (this.relationshipsToRemove.contains(relation.getLayoutRelationship())) {
                    this.relationshipsToRemove.remove(relation.getLayoutRelationship());
                } else {
                    updatedRelationships.add(relation);
                }
                ++i;
            }
            this.relationshipsToRemove.clear();
            if (this.relationshipsToAdd.size() > 0) {
                LayoutRelationship[] relsArray = new LayoutRelationship[this.relationshipsToAdd.size()];
                relsArray = this.relationshipsToAdd.toArray(relsArray);
                InternalRelationship[] newRelationships = this.createInternalRelationships(relsArray);
                int i2 = 0;
                while (i2 < newRelationships.length) {
                    internalRelsList.add(newRelationships[i2]);
                    updatedRelationships.add(newRelationships[i2]);
                    ++i2;
                }
            }
            this.relationshipsToAdd.clear();
            relationships = new InternalRelationship[internalRelsList.size()];
            relationships = internalRelsList.toArray(relationships);
            this.internalRelationships = new InternalRelationship[updatedRelationships.size()];
            this.internalRelationships = updatedRelationships.toArray(this.internalRelationships);
        }
        return relationships;
    }

    public synchronized boolean isRunning() {
        return !this.layoutStopped;
    }

    public synchronized void stop() {
        this.layoutStopped = true;
        this.postLayoutAlgorithm(this.internalNodes, this.internalRelationships);
        this.fireProgressEnded(this.getTotalNumberOfLayoutSteps());
    }

    private void setupLayout(LayoutEntity[] entitiesToLayout, LayoutRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        this.internalX = x;
        this.internalY = y;
        this.internalHeight = height;
        this.internalWidth = width;
        if (!AbstractLayoutAlgorithm.verifyInput(entitiesToLayout = (LayoutEntity[])this.filterUnwantedObjects(entitiesToLayout), relationshipsToConsider = (LayoutRelationship[])this.filterUnwantedObjects(relationshipsToConsider))) {
            this.layoutStopped = true;
            throw new RuntimeException("The relationships in relationshipsToConsider don't contain the entities in entitiesToLayout");
        }
        this.internalNodes = this.createInternalNodes(entitiesToLayout);
        this.internalRelationships = this.createInternalRelationships(relationshipsToConsider);
    }

    protected abstract void preLayoutAlgorithm(InternalNode[] var1, InternalRelationship[] var2, double var3, double var5, double var7, double var9);

    protected abstract void postLayoutAlgorithm(InternalNode[] var1, InternalRelationship[] var2);

    protected abstract int getTotalNumberOfLayoutSteps();

    protected abstract int getCurrentLayoutStep();

    public synchronized void applyLayout(final LayoutEntity[] entitiesToLayout, final LayoutRelationship[] relationshipsToConsider, final double x, final double y, final double width, final double height, boolean asynchronous, boolean continuous) throws InvalidLayoutConfiguration {
        this.checkThread();
        this.internalAsynchronous = asynchronous;
        this.internalContinuous = continuous;
        if (!this.isValidConfiguration(asynchronous, continuous)) {
            throw new InvalidLayoutConfiguration();
        }
        this.clearBendPoints(relationshipsToConsider);
        this.layoutStopped = false;
        this.lastProgressEventFired = Calendar.getInstance();
        if (asynchronous) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    AbstractLayoutAlgorithm.this.setupLayout(entitiesToLayout, relationshipsToConsider, x, y, width, height);
                    AbstractLayoutAlgorithm.this.preLayoutAlgorithm(AbstractLayoutAlgorithm.this.internalNodes, AbstractLayoutAlgorithm.this.internalRelationships, AbstractLayoutAlgorithm.this.internalX, AbstractLayoutAlgorithm.this.internalY, AbstractLayoutAlgorithm.this.internalWidth, AbstractLayoutAlgorithm.this.internalHeight);
                    AbstractLayoutAlgorithm.this.fireProgressStarted(AbstractLayoutAlgorithm.this.getTotalNumberOfLayoutSteps());
                    AbstractLayoutAlgorithm.this.applyLayoutInternal(AbstractLayoutAlgorithm.this.internalNodes, AbstractLayoutAlgorithm.this.internalRelationships, AbstractLayoutAlgorithm.this.internalX, AbstractLayoutAlgorithm.this.internalY, AbstractLayoutAlgorithm.this.internalWidth, AbstractLayoutAlgorithm.this.internalHeight);
                    AbstractLayoutAlgorithm.this.stop();
                }
            });
            thread.setPriority(1);
            thread.start();
        } else {
            this.setupLayout(entitiesToLayout, relationshipsToConsider, x, y, width, height);
            this.preLayoutAlgorithm(this.internalNodes, this.internalRelationships, this.internalX, this.internalY, this.internalWidth, this.internalHeight);
            this.fireProgressStarted(this.getTotalNumberOfLayoutSteps());
            this.applyLayoutInternal(this.internalNodes, this.internalRelationships, this.internalX, this.internalY, this.internalWidth, this.internalHeight);
            this.stop();
        }
    }

    private void clearBendPoints(LayoutRelationship[] relationships) {
        int i = 0;
        while (i < relationships.length) {
            LayoutRelationship rel = relationships[i];
            rel.clearBendPoints();
            ++i;
        }
    }

    protected void updateBendPoints(InternalRelationship[] relationshipsToConsider) {
        int i = 0;
        while (i < relationshipsToConsider.length) {
            InternalRelationship relationship = relationshipsToConsider[i];
            List bendPoints = relationship.getBendPoints();
            if (bendPoints.size() > 0) {
                LayoutBendPoint[] externalBendPoints = new BendPoint[bendPoints.size() + 2];
                InternalNode sourceNode = relationship.getSource();
                externalBendPoints[0] = new BendPoint(sourceNode.getInternalX(), sourceNode.getInternalY());
                InternalNode destNode = relationship.getDestination();
                externalBendPoints[externalBendPoints.length - 1] = new BendPoint(destNode.getInternalX(), destNode.getInternalY());
                int j = 0;
                while (j < bendPoints.size()) {
                    BendPoint bp = (BendPoint)bendPoints.get(j);
                    externalBendPoints[j + 1] = new BendPoint(bp.x, bp.y, bp.getIsControlPoint());
                    ++j;
                }
                relationship.getLayoutRelationship().setBendPoints(externalBendPoints);
            }
            ++i;
        }
    }

    private InternalNode[] createInternalNodes(LayoutEntity[] nodes) {
        InternalNode[] internalNodes = new InternalNode[nodes.length];
        BasicEntityConstraint basicEntityConstraint = new BasicEntityConstraint();
        int i = 0;
        while (i < nodes.length) {
            basicEntityConstraint.clear();
            LayoutEntity externalNode = nodes[i];
            InternalNode internalNode = new InternalNode(externalNode);
            externalNode.populateLayoutConstraint(basicEntityConstraint);
            internalNode.setInternalLocation(externalNode.getXInLayout(), externalNode.getYInLayout());
            internalNodes[i] = internalNode;
            ++i;
        }
        return internalNodes;
    }

    private InternalRelationship[] createInternalRelationships(LayoutRelationship[] rels) {
        ArrayList<InternalRelationship> listOfInternalRelationships = new ArrayList<InternalRelationship>(rels.length);
        int i = 0;
        while (i < rels.length) {
            LayoutRelationship relation = rels[i];
            InternalNode src = (InternalNode)relation.getSourceInLayout().getLayoutInformation();
            InternalNode dest = (InternalNode)relation.getDestinationInLayout().getLayoutInformation();
            if (src == null || dest == null) {
                throw new RuntimeException("Error creating internal relationship, one of the nodes is null: src=" + src + ", dest=" + dest);
            }
            InternalRelationship internalRelationship = new InternalRelationship(relation, src, dest);
            listOfInternalRelationships.add(internalRelationship);
            ++i;
        }
        InternalRelationship[] internalRelationships = new InternalRelationship[listOfInternalRelationships.size()];
        listOfInternalRelationships.toArray(internalRelationships);
        return internalRelationships;
    }

    private Object[] filterUnwantedObjects(LayoutItem[] objects) {
        ArrayList<LayoutItem> unfilteredObjsList = new ArrayList<LayoutItem>();
        if (this.filter != null) {
            int i = 0;
            while (i < objects.length) {
                LayoutItem object = objects[i];
                if (!this.filter.isObjectFiltered(object)) {
                    unfilteredObjsList.add(object);
                }
                ++i;
            }
            Object[] unfilteredObjs = (Object[])Array.newInstance(objects.getClass().getComponentType(), unfilteredObjsList.size());
            unfilteredObjsList.toArray(unfilteredObjs);
            return unfilteredObjs;
        }
        return objects;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = new InternalComparator(comparator);
    }

    public static boolean verifyInput(LayoutEntity[] entitiesToLayout, LayoutRelationship[] relationshipsToConsider) {
        boolean stillValid = true;
        int i = 0;
        while (i < relationshipsToConsider.length) {
            LayoutRelationship relationship = relationshipsToConsider[i];
            LayoutEntity source = relationship.getSourceInLayout();
            LayoutEntity destination = relationship.getDestinationInLayout();
            boolean containsSrc = false;
            boolean containsDest = false;
            int j = 0;
            while (!(j >= entitiesToLayout.length || containsSrc && containsDest)) {
                if (entitiesToLayout[j].equals(source)) {
                    containsSrc = true;
                }
                if (entitiesToLayout[j].equals(destination)) {
                    containsDest = true;
                }
                ++j;
            }
            stillValid = containsSrc && containsDest;
            ++i;
        }
        return stillValid;
    }

    protected DisplayIndependentPoint getLocalLocation(InternalNode[] entitiesToLayout, double x, double y, DisplayIndependentRectangle realBounds) {
        double screenWidth = realBounds.width;
        double screenHeight = realBounds.height;
        DisplayIndependentRectangle layoutBounds = this.getLayoutBounds(entitiesToLayout, false);
        double localX = x / screenWidth * layoutBounds.width + layoutBounds.x;
        double localY = y / screenHeight * layoutBounds.height + layoutBounds.y;
        return new DisplayIndependentPoint(localX, localY);
    }

    protected void defaultFitWithinBounds(InternalNode[] entitiesToLayout, DisplayIndependentRectangle realBounds) {
        this.defaultFitWithinBounds(entitiesToLayout, new InternalRelationship[0], realBounds);
    }

    protected void defaultFitWithinBounds(InternalNode[] entitiesToLayout, InternalRelationship[] relationships, DisplayIndependentRectangle realBounds) {
        DisplayIndependentRectangle layoutBounds;
        if (this.resizeEntitiesAfterLayout) {
            layoutBounds = this.getLayoutBounds(entitiesToLayout, false);
            this.convertPositionsToPercentage(entitiesToLayout, relationships, layoutBounds, false);
            this.resizeAndShiftNodes(entitiesToLayout);
        }
        layoutBounds = this.getLayoutBounds(entitiesToLayout, true);
        this.convertPositionsToPercentage(entitiesToLayout, relationships, layoutBounds, true);
        DisplayIndependentRectangle screenBounds = this.calcScreenBounds(realBounds, layoutBounds);
        this.convertPositionsToCoords(entitiesToLayout, relationships, screenBounds);
    }

    private DisplayIndependentRectangle calcScreenBounds(DisplayIndependentRectangle realBounds, DisplayIndependentRectangle layoutBounds) {
        if (this.resizeEntitiesAfterLayout) {
            double borderWidth = Math.min(realBounds.width, realBounds.height) / 10.0;
            return new DisplayIndependentRectangle(realBounds.x + borderWidth / 2.0, realBounds.y + borderWidth / 2.0, realBounds.width - borderWidth, realBounds.height - borderWidth);
        }
        double heightAdjustment = realBounds.height / layoutBounds.height;
        double widthAdjustment = realBounds.width / layoutBounds.width;
        double ratio = Math.min(heightAdjustment, widthAdjustment);
        double adjustedHeight = layoutBounds.height * ratio;
        double adjustedWidth = layoutBounds.width * ratio;
        double adjustedX = realBounds.x + (realBounds.width - adjustedWidth) / 2.0;
        double adjustedY = realBounds.y + (realBounds.height - adjustedHeight) / 2.0;
        double borderWidth = Math.min(adjustedWidth, adjustedHeight) / 10.0;
        return new DisplayIndependentRectangle(adjustedX + borderWidth / 2.0, adjustedY + borderWidth / 2.0, adjustedWidth - borderWidth, adjustedHeight - borderWidth);
    }

    private void resizeAndShiftNodes(InternalNode[] entitiesToLayout) {
        double nodeSize = this.getNodeSize(entitiesToLayout);
        double halfNodeSize = nodeSize / 2.0;
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode node = entitiesToLayout[i];
            node.setInternalSize(nodeSize, nodeSize);
            node.setInternalLocation(node.getInternalX() + halfNodeSize, node.getInternalY() + halfNodeSize);
            ++i;
        }
    }

    private void convertPositionsToPercentage(InternalNode[] entitiesToLayout, InternalRelationship[] relationships, DisplayIndependentRectangle layoutBounds, boolean includeNodeSize) {
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode node = entitiesToLayout[i];
            DisplayIndependentPoint location = node.getInternalLocation().convertToPercent(layoutBounds);
            node.setInternalLocation(location.x, location.y);
            if (includeNodeSize) {
                double width = node.getInternalWidth() / layoutBounds.width;
                double height = node.getInternalHeight() / layoutBounds.height;
                node.setInternalSize(width, height);
            }
            ++i;
        }
        i = 0;
        while (i < relationships.length) {
            InternalRelationship rel = relationships[i];
            int j = 0;
            while (j < rel.getBendPoints().size()) {
                BendPoint bp = (BendPoint)rel.getBendPoints().get(j);
                DisplayIndependentPoint toPercent = bp.convertToPercent(layoutBounds);
                bp.setX(toPercent.x);
                bp.setY(toPercent.y);
                ++j;
            }
            ++i;
        }
    }

    private void convertPositionsToCoords(InternalNode[] entitiesToLayout, InternalRelationship[] relationships, DisplayIndependentRectangle screenBounds) {
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode node = entitiesToLayout[i];
            double width = node.getInternalWidth() * screenBounds.width;
            double height = node.getInternalHeight() * screenBounds.height;
            DisplayIndependentPoint location = node.getInternalLocation().convertFromPercent(screenBounds);
            node.setInternalLocation(location.x - width / 2.0, location.y - height / 2.0);
            if (this.resizeEntitiesAfterLayout) {
                this.adjustNodeSizeAndPos(node, height, width);
            } else {
                node.setInternalSize(width, height);
            }
            ++i;
        }
        i = 0;
        while (i < relationships.length) {
            InternalRelationship rel = relationships[i];
            int j = 0;
            while (j < rel.getBendPoints().size()) {
                BendPoint bp = (BendPoint)rel.getBendPoints().get(j);
                DisplayIndependentPoint fromPercent = bp.convertFromPercent(screenBounds);
                bp.setX(fromPercent.x);
                bp.setY(fromPercent.y);
                ++j;
            }
            ++i;
        }
    }

    private void adjustNodeSizeAndPos(InternalNode node, double height, double width) {
        double widthUsingHeight = height * this.widthToHeightRatio;
        if (this.widthToHeightRatio <= 1.0 && widthUsingHeight <= width) {
            double widthToUse = height * this.widthToHeightRatio;
            double leftOut = width - widthToUse;
            node.setInternalSize(Math.max(height * this.widthToHeightRatio, 5.0), Math.max(height, 5.0));
            node.setInternalLocation(node.getInternalX() + leftOut / 2.0, node.getInternalY());
        } else {
            double heightToUse = height / this.widthToHeightRatio;
            double leftOut = height - heightToUse;
            node.setInternalSize(Math.max(width, 5.0), Math.max(width / this.widthToHeightRatio, 5.0));
            node.setInternalLocation(node.getInternalX(), node.getInternalY() + leftOut / 2.0);
        }
    }

    private double getNodeSize(InternalNode[] entitiesToLayout) {
        double height;
        double width;
        if (entitiesToLayout.length == 1) {
            width = 0.8;
            height = 0.8;
        } else {
            DisplayIndependentDimension minimumDistance = this.getMinimumDistance(entitiesToLayout);
            width = 0.8 * minimumDistance.width;
            height = 0.8 * minimumDistance.height;
        }
        return Math.max(width, height);
    }

    protected DisplayIndependentRectangle getLayoutBounds(InternalNode[] entitiesToLayout, boolean includeNodeSize) {
        double rightSide = Double.MIN_VALUE;
        double bottomSide = Double.MIN_VALUE;
        double leftSide = Double.MAX_VALUE;
        double topSide = Double.MAX_VALUE;
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode entity = entitiesToLayout[i];
            if (!entity.hasPreferredLocation()) {
                if (includeNodeSize) {
                    leftSide = Math.min(entity.getInternalX() - entity.getInternalWidth() / 2.0, leftSide);
                    topSide = Math.min(entity.getInternalY() - entity.getInternalHeight() / 2.0, topSide);
                    rightSide = Math.max(entity.getInternalX() + entity.getInternalWidth() / 2.0, rightSide);
                    bottomSide = Math.max(entity.getInternalY() + entity.getInternalHeight() / 2.0, bottomSide);
                } else {
                    leftSide = Math.min(entity.getInternalX(), leftSide);
                    topSide = Math.min(entity.getInternalY(), topSide);
                    rightSide = Math.max(entity.getInternalX(), rightSide);
                    bottomSide = Math.max(entity.getInternalY(), bottomSide);
                }
            }
            ++i;
        }
        return new DisplayIndependentRectangle(leftSide, topSide, rightSide - leftSide, bottomSide - topSide);
    }

    private DisplayIndependentDimension getMinimumDistance(InternalNode[] entitiesToLayout) {
        DisplayIndependentDimension horAndVertdistance = new DisplayIndependentDimension(Double.MAX_VALUE, Double.MAX_VALUE);
        double minDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode layoutEntity1 = entitiesToLayout[i];
            double x1 = layoutEntity1.getInternalX();
            double y1 = layoutEntity1.getInternalY();
            int j = i + 1;
            while (j < entitiesToLayout.length) {
                InternalNode layoutEntity2 = entitiesToLayout[j];
                double x2 = layoutEntity2.getInternalX();
                double y2 = layoutEntity2.getInternalY();
                double distanceX = Math.abs(x1 - x2);
                double distanceY = Math.abs(y1 - y2);
                double distance = Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
                if (distance < minDistance) {
                    minDistance = distance;
                    horAndVertdistance.width = distanceX;
                    horAndVertdistance.height = distanceY;
                }
                ++j;
            }
            ++i;
        }
        return horAndVertdistance;
    }

    public void setEntityAspectRatio(double ratio) {
        this.widthToHeightRatio = ratio;
    }

    public double getEntityAspectRatio() {
        return this.widthToHeightRatio;
    }

    public void addProgressListener(ProgressListener listener) {
        if (!this.progressListeners.contains(listener)) {
            this.progressListeners.add(listener);
        }
    }

    public void removeProgressListener(ProgressListener listener) {
        if (this.progressListeners.contains(listener)) {
            this.progressListeners.remove(listener);
        }
    }

    protected void updateLayoutLocations(InternalNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            InternalNode node = nodes[i];
            if (!node.hasPreferredLocation()) {
                node.setLocation(node.getInternalX(), node.getInternalY());
                if ((this.layout_styles & 1) != 1) {
                    node.setSize(node.getInternalWidth(), node.getInternalHeight());
                }
            }
            ++i;
        }
    }

    protected void fireProgressStarted(int totalNumberOfSteps) {
        ProgressEvent event = new ProgressEvent(0, totalNumberOfSteps);
        int i = 0;
        while (i < this.progressListeners.size()) {
            ProgressListener listener = (ProgressListener)this.progressListeners.get(i);
            listener.progressStarted(event);
            ++i;
        }
    }

    protected void fireProgressEnded(int totalNumberOfSteps) {
        ProgressEvent event = new ProgressEvent(totalNumberOfSteps, totalNumberOfSteps);
        int i = 0;
        while (i < this.progressListeners.size()) {
            ProgressListener listener = (ProgressListener)this.progressListeners.get(i);
            listener.progressEnded(event);
            ++i;
        }
    }

    protected void fireProgressEvent(int currentStep, int totalNumberOfSteps) {
        Calendar now = Calendar.getInstance();
        now.add(14, -1);
        if (now.after(this.lastProgressEventFired) || currentStep == totalNumberOfSteps) {
            ProgressEvent event = new ProgressEvent(currentStep, totalNumberOfSteps);
            int i = 0;
            while (i < this.progressListeners.size()) {
                ProgressListener listener = (ProgressListener)this.progressListeners.get(i);
                listener.progressUpdated(event);
                ++i;
            }
            this.lastProgressEventFired = Calendar.getInstance();
        }
    }

    protected int getNumberOfProgressListeners() {
        return this.progressListeners.size();
    }

    private void checkThread() {
        if (this.creationThread != Thread.currentThread()) {
            throw new RuntimeException("Invalid Thread Access.");
        }
    }

    class InternalComparator
    implements Comparator {
        Comparator externalComparator = null;

        public InternalComparator(Comparator externalComparator) {
            this.externalComparator = externalComparator;
        }

        public int compare(Object o1, Object o2) {
            InternalNode internalNode1 = (InternalNode)o1;
            InternalNode internalNode2 = (InternalNode)o2;
            return this.externalComparator.compare(internalNode1.getLayoutEntity(), internalNode2.getLayoutEntity());
        }
    }
}

