/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class EObjectAtOffsetHelper {
    public EObject resolveElementAt(XtextResource resource, int offset) {
        return this.internalResolveElementAt(resource, offset, true);
    }

    public EObject resolveCrossReferencedElementAt(XtextResource resource, int offset) {
        return this.internalResolveElementAt(resource, offset, false);
    }

    protected EObject internalResolveElementAt(XtextResource resource, int offset, boolean isContainment) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && parseResult.getRootNode() != null) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset(parseResult.getRootNode(), offset);
            if (leaf.isHidden() && leaf.getOffset() == offset) {
                leaf = NodeModelUtils.findLeafNodeAtOffset(parseResult.getRootNode(), offset - 1);
            }
            INode node = leaf;
            while (node != null) {
                if (node.getGrammarElement() instanceof CrossReference) {
                    return this.resolveCrossReferencedElement(node);
                }
                if (isContainment && node.hasDirectSemanticElement()) {
                    return node.getSemanticElement();
                }
                node = node.getParent();
            }
        }
        return null;
    }

    protected EObject resolveCrossReferencedElement(INode node) {
        EObject referenceOwner = node.getSemanticElement();
        EReference crossReference = GrammarUtil.getReference((CrossReference)node.getGrammarElement(), referenceOwner.eClass());
        if (!crossReference.isMany()) {
            return (EObject)referenceOwner.eGet((EStructuralFeature)crossReference);
        }
        List listValue = (List)referenceOwner.eGet((EStructuralFeature)crossReference);
        ICompositeNode ownerNode = NodeModelUtils.getNode(referenceOwner);
        int currentIndex = 0;
        BidiTreeIterator<INode> childrenIterator = ownerNode.getAsTreeIterable().iterator();
        while (childrenIterator.hasNext()) {
            INode ownerChildNode = (INode)childrenIterator.next();
            if (ownerChildNode == node) {
                if (currentIndex >= listValue.size()) {
                    return null;
                }
                return (EObject)listValue.get(currentIndex);
            }
            EObject grammarElement = ownerChildNode.getGrammarElement();
            if (grammarElement instanceof CrossReference) {
                EReference crossReference2 = GrammarUtil.getReference((CrossReference)grammarElement, referenceOwner.eClass());
                if (crossReference == crossReference2) {
                    ++currentIndex;
                }
                childrenIterator.prune();
            }
            if (!(grammarElement instanceof TypeRef) && !(grammarElement instanceof RuleCall) || ownerNode == ownerChildNode) continue;
            childrenIterator.prune();
        }
        return null;
    }
}

