/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ImageHyperlink
extends Hyperlink {
    public int textSpacing = 5;
    private Image image;
    private Image hoverImage;
    private Image activeImage;
    private int state;
    private static final int HOVER = 2;
    private static final int ACTIVE = 4;
    private int verticalAlignment = 0x1000000;
    private int horizontalAlignment = 16384;

    public ImageHyperlink(Composite parent, int style) {
        super(parent, ImageHyperlink.removeAlignment(style));
        this.extractAlignment(style);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point isize = this.computeMaxImageSize();
        int spacing = isize.x > 0 ? this.textSpacing : 0;
        Point textSize = null;
        if (this.getText() != null) {
            int innerWHint = wHint;
            if (wHint != -1) {
                innerWHint = wHint - 2 * this.marginWidth - isize.x - spacing;
            }
            textSize = super.computeSize(innerWHint, hHint, changed);
        }
        int width = isize.x;
        int height = isize.y;
        if (textSize != null) {
            width += spacing;
            width += textSize.x;
            height = Math.max(height, textSize.y);
        }
        return new Point(width += 2 * this.marginWidth, height += 2 * this.marginHeight);
    }

    protected void handleEnter(Event e) {
        this.state = 2;
        super.handleEnter(e);
    }

    protected void handleExit(Event e) {
        this.state = 0;
        super.handleExit(e);
    }

    protected void handleActivate(Event e) {
        this.state &= 4;
        this.redraw();
        super.handleActivate(e);
        this.state &= 0xFFFFFFFB;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public Image getActiveImage() {
        return this.activeImage;
    }

    public void setActiveImage(Image activeImage) {
        this.activeImage = activeImage;
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public void setHoverImage(Image hoverImage) {
        this.hoverImage = hoverImage;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private Point computeMaxImageSize() {
        int x = 0;
        int y = 0;
        if (this.image != null) {
            x = Math.max(this.image.getBounds().width, x);
            y = Math.max(this.image.getBounds().height, y);
        }
        if (this.hoverImage != null) {
            x = Math.max(this.hoverImage.getBounds().width, x);
            y = Math.max(this.hoverImage.getBounds().height, y);
        }
        if (this.activeImage != null) {
            x = Math.max(this.activeImage.getBounds().width, x);
            y = Math.max(this.activeImage.getBounds().height, y);
        }
        return new Point(x, y);
    }

    private static int removeAlignment(int style) {
        int resultStyle = style;
        if ((style & 0x1000000) != 0) {
            resultStyle &= 0xFEFFFFFF;
        }
        if ((style & 0x80) != 0) {
            resultStyle &= 0xFFFFFF7F;
        }
        if ((style & 0x400) != 0) {
            resultStyle &= 0xFFFFFBFF;
        }
        if ((style & 0x4000) != 0) {
            resultStyle &= 0xFFFFBFFF;
        }
        if ((style & 0x20000) != 0) {
            resultStyle &= 0xFFFDFFFF;
        }
        return resultStyle;
    }

    private void extractAlignment(int style) {
        if ((style & 0x1000000) != 0) {
            this.verticalAlignment = 0x1000000;
        } else if ((style & 0x80) != 0) {
            this.verticalAlignment = 128;
        } else if ((style & 0x400) != 0) {
            this.verticalAlignment = 1024;
        }
        if ((style & 0x4000) != 0) {
            this.horizontalAlignment = 16384;
        } else if ((style & 0x20000) != 0) {
            this.horizontalAlignment = 131072;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }
}

