/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.pde.internal.ui.editor.text.XMLPartitionScanner;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;

public class PluginContentMergeViewer
extends TextMergeViewer {
    private IColorManager fColorManager;
    private ArrayList fPropertyChangedListeners;
    static /* synthetic */ Class class$0;

    public PluginContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(parent, config);
    }

    protected void configureTextViewer(final TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            Font font;
            if (this.fColorManager == null) {
                this.fColorManager = ColorManager.getDefault();
            }
            final XMLConfiguration configuration = new XMLConfiguration(this.fColorManager);
            textViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    configuration.dispose();
                }
            });
            IPropertyChangeListener propertyChangedListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (configuration.affectsColorPresentation(event) || configuration.affectsTextPresentation(event)) {
                        configuration.adaptToPreferenceChange(event);
                        textViewer.invalidateTextPresentation();
                    }
                }
            };
            PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(propertyChangedListener);
            if (this.fPropertyChangedListeners == null) {
                this.fPropertyChangedListeners = new ArrayList(3);
            }
            this.fPropertyChangedListeners.add(propertyChangedListener);
            ((SourceViewer)textViewer).configure((SourceViewerConfiguration)configuration);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.ui.compare.PluginContentMergeViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((font = JFaceResources.getFont((String)clazz.getName())) != null) {
                ((SourceViewer)textViewer).getTextWidget().setFont(font);
            }
        }
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), XMLPartitionScanner.PARTITIONS);
    }

    protected String getDocumentPartitioning() {
        return "_pde_xml_partitioning";
    }

    public String getTitle() {
        return PDEUIMessages.PluginContentMergeViewer_title;
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
        }
        if (this.fPropertyChangedListeners != null) {
            Iterator iter = this.fPropertyChangedListeners.iterator();
            while (iter.hasNext()) {
                PDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)iter.next());
            }
            this.fPropertyChangedListeners = null;
        }
    }
}

