/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenJarExportWizardEditorLauncher
implements IEditorLauncher {
    public void open(IPath filePath) {
        IJarDescriptionReader reader = null;
        JarPackageData jarPackage = null;
        try {
            File file = filePath.toFile();
            if (!file.isFile() || !file.getName().endsWith(".jardesc")) {
                this.openErrorDialog(Messages.format(JarPackagerMessages.OpenJarPackageWizardDelegate_onlyJardesc, "jardesc"));
                return;
            }
            jarPackage = new JarPackageData();
            try {
                reader = jarPackage.createJarDescriptionReader(new FileInputStream(file));
                reader.read(jarPackage);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ex) {
            this.openErrorDialog(ex.getLocalizedMessage());
            return;
        }
        catch (CoreException ex) {
            this.openErrorDialog(ex.getLocalizedMessage());
            return;
        }
        Shell parent = JavaPlugin.getActiveWorkbenchShell();
        if (reader != null && !reader.getStatus().isOK()) {
            ErrorDialog.openError((Shell)parent, (String)JarPackagerMessages.OpenJarPackageWizardDelegate_jarDescriptionReaderWarnings_title, null, (IStatus)reader.getStatus());
        }
        JarPackageWizard wizard = new JarPackageWizard();
        wizard.init(PlatformUI.getWorkbench(), jarPackage);
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private void openErrorDialog(String errorDetail) {
        MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_title, (String)(String.valueOf(JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_message) + errorDetail));
    }
}

