/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import com.sun.jdi.IncompatibleThreadStateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaContendedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwnedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwningThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaWaitingThread;
import org.eclipse.jdt.internal.debug.ui.monitors.ThreadMonitorManager;

public class JavaMonitorThread
extends PlatformObject {
    private IJavaThread fThread;
    private IThread fOriginalThread;
    private JavaMonitor fContendedMonitor;
    private JavaMonitor[] fOwnedMonitors = new JavaMonitor[0];
    private boolean fIsInDeadlock;
    private boolean fToUpdate = true;
    private List fElements = new ArrayList();
    private JavaWaitingThread fBaseWaitingThread;
    private JavaOwningThread fBaseOwningThread;

    public JavaMonitorThread(IJavaThread underlyingThread, IThread originalThread) {
        this.fThread = underlyingThread;
        this.fOriginalThread = originalThread;
    }

    public IJavaThread getThread() {
        return this.fThread;
    }

    public IThread getOriginalThread() {
        return this.fOriginalThread;
    }

    protected void setOriginalThread(IThread originalThread) {
        this.fOriginalThread = originalThread;
    }

    public String getModelIdentifier() {
        return this.fThread.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fThread.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fThread.getLaunch();
    }

    public boolean isSuspended() {
        return this.fThread.isSuspended();
    }

    public JavaContendedMonitor getContendedMonitor() {
        if (this.fBaseOwningThread == null) {
            this.fBaseOwningThread = new JavaOwningThread(this, null);
        }
        return this.fBaseOwningThread.getContendedMonitor();
    }

    public JavaOwnedMonitor[] getOwnedMonitors() {
        if (this.fBaseWaitingThread == null) {
            this.fBaseWaitingThread = new JavaWaitingThread(this, null);
        }
        return this.fBaseWaitingThread.getOwnedMonitors();
    }

    protected JavaMonitor getContendedMonitor0() {
        if (this.fToUpdate) {
            this.update();
        }
        return this.fContendedMonitor;
    }

    protected JavaMonitor[] getOwnedMonitors0() {
        if (this.fToUpdate) {
            this.update();
        }
        return this.fOwnedMonitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update() {
        boolean changed = false;
        JavaMonitorThread javaMonitorThread = this;
        synchronized (javaMonitorThread) {
            block22: {
                block20: {
                    if (this.fToUpdate) break block20;
                    return false;
                }
                try {
                    try {
                        IJavaObject contendedMonitor = this.fThread.getContendedMonitor();
                        if (contendedMonitor == null) {
                            changed = this.fContendedMonitor != null;
                            this.fContendedMonitor = null;
                        } else {
                            changed = this.fContendedMonitor == null || !contendedMonitor.equals(this.fContendedMonitor.getMonitor());
                            this.fContendedMonitor = ThreadMonitorManager.getDefault().getJavaMonitor(contendedMonitor);
                        }
                        IJavaObject[] ownedMonitors = this.fThread.getOwnedMonitors();
                        if (ownedMonitors == null || ownedMonitors.length == 0) {
                            changed = this.fOwnedMonitors != null && this.fOwnedMonitors.length != 0;
                            this.fOwnedMonitors = new JavaMonitor[0];
                        } else {
                            JavaMonitor[] tmp = new JavaMonitor[ownedMonitors.length];
                            ThreadMonitorManager threadMonitorManager = ThreadMonitorManager.getDefault();
                            if (changed || this.fOwnedMonitors.length != ownedMonitors.length) {
                                int i = 0;
                                while (i < ownedMonitors.length) {
                                    tmp[i] = threadMonitorManager.getJavaMonitor(ownedMonitors[i]);
                                    ++i;
                                }
                                changed = true;
                            } else {
                                int sameMonitor = 0;
                                int i = 0;
                                while (i < ownedMonitors.length) {
                                    int j = 0;
                                    while (j < this.fOwnedMonitors.length) {
                                        if (ownedMonitors[i].equals(this.fOwnedMonitors[i].getMonitor())) {
                                            ++sameMonitor;
                                            break;
                                        }
                                        ++j;
                                    }
                                    tmp[i] = threadMonitorManager.getJavaMonitor(ownedMonitors[i]);
                                    ++i;
                                }
                                changed = sameMonitor != ownedMonitors.length;
                            }
                            this.fOwnedMonitors = tmp;
                        }
                    }
                    catch (DebugException e) {
                        Throwable cause = e.getStatus().getException();
                        if (!(cause instanceof IncompatibleThreadStateException)) {
                            this.fContendedMonitor = null;
                            changed = this.fOwnedMonitors != null && this.fOwnedMonitors.length != 0;
                            this.fOwnedMonitors = new JavaMonitor[0];
                        }
                        this.fToUpdate = false;
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    this.fToUpdate = false;
                    throw throwable;
                }
                this.fToUpdate = false;
            }
        }
        if (changed) {
            this.fireChangeEvent(512);
        }
        return changed;
    }

    private void fireChangeEvent(int detail) {
        Object[] elements = this.fElements.toArray();
        ArrayList<Object> changedElement = new ArrayList<Object>();
        if (this.fOriginalThread != null) {
            changedElement.add(this.fOriginalThread);
        }
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element != this.fBaseOwningThread && element != this.fBaseWaitingThread) {
                changedElement.add(element);
            }
            ++i;
        }
        DebugEvent[] changeEvents = new DebugEvent[changedElement.size()];
        int i2 = 0;
        Iterator iter = changedElement.iterator();
        while (iter.hasNext()) {
            changeEvents[i2++] = new DebugEvent(iter.next(), 16, detail);
        }
        DebugPlugin.getDefault().fireDebugEventSet(changeEvents);
    }

    public synchronized void setToUpdate() {
        if (!this.fToUpdate) {
            this.fToUpdate = true;
            if (this.fContendedMonitor != null) {
                this.fContendedMonitor.setToUpdate();
            }
            if (this.fOwnedMonitors != null) {
                int i = 0;
                while (i < this.fOwnedMonitors.length) {
                    this.fOwnedMonitors[i].setToUpdate();
                    ++i;
                }
            }
        }
    }

    protected void addElement(JavaOwningThread thread) {
        this.fElements.add(thread);
    }

    protected void addElement(JavaWaitingThread thread) {
        this.fElements.add(thread);
    }

    public void refresh() {
        if (this.fToUpdate && !this.update()) {
            if (this.fContendedMonitor != null) {
                this.fContendedMonitor.refresh();
            }
            int i = 0;
            while (i < this.fOwnedMonitors.length) {
                this.fOwnedMonitors[i].refresh();
                ++i;
            }
        }
    }

    public boolean isInDeadlock() {
        return this.fIsInDeadlock;
    }

    public void setInDeadlock(boolean isInDeadlock) {
        boolean oldValue = this.fIsInDeadlock;
        this.fIsInDeadlock = isInDeadlock;
        if (oldValue != isInDeadlock) {
            this.fireChangeEvent(256);
        }
    }
}

