/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.fieldassist;

import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.plugin.ChartUIExtensionPlugin;
import org.eclipse.birt.chart.ui.swt.fieldassist.AssistField;
import org.eclipse.birt.chart.ui.swt.fieldassist.preferences.FieldAssistPreferenceInitializer;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class FieldAssistHelper {
    private static FieldAssistHelper foInstance = null;
    private String DEC_CONTENTASSIST_ID = "org.eclipse.birt.chart.ui.swt.fieldassist.contentAssistDecoration";
    private static final int DECORATION_MARGIN = 7;
    private IPreferenceStore soPreferenceStore = null;

    public static FieldAssistHelper getInstance() {
        if (foInstance == null) {
            foInstance = new FieldAssistHelper();
        }
        return foInstance;
    }

    private FieldAssistHelper() {
        if (this.soPreferenceStore == null) {
            if (ChartUIExtensionPlugin.getDefault() == null) {
                this.soPreferenceStore = new PreferenceStore();
                FieldAssistPreferenceInitializer.setDefaultPreferences(this.soPreferenceStore);
                return;
            }
            this.soPreferenceStore = ChartUIExtensionPlugin.getDefault().getPreferenceStore();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return this.soPreferenceStore;
    }

    private String getTriggerKey() {
        IPreferenceStore store = this.getPreferenceStore();
        String triggerKey = store.getString("prefContentAssistKey");
        if (triggerKey.equals("preContentAssistKeyAnyKey")) {
            return null;
        }
        if (triggerKey.equals("preContentAssistKeyCustom")) {
            return this.getPreferenceStore().getString("preContentAssistKeyCustomKey");
        }
        return triggerKey;
    }

    private String getTriggerKeyText() {
        IPreferenceStore store = this.getPreferenceStore();
        String triggerKey = store.getString("prefContentAssistKey");
        if (triggerKey.equals("preContentAssistKeyAnyKey")) {
            return "alphanumeric key";
        }
        if (triggerKey.equals("preContentAssistKeyCustom")) {
            return this.getPreferenceStore().getString("preContentAssistKeyCustomKey");
        }
        return triggerKey;
    }

    private int getMarginWidth() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getInt("prefDecoratorMarginWidth");
    }

    public ControlDecoration createControlDecoration(Control control, Composite composite) {
        ControlDecoration cd = new ControlDecoration(control, this.getDecorationLocationBits(), composite);
        cd.setMarginWidth(this.getMarginWidth());
        return cd;
    }

    public void installContentProposalAdapter(Control control, IControlContentAdapter contentAdapter, String[] values) {
        IPreferenceStore store = this.getPreferenceStore();
        boolean propagate = store.getBoolean("prefContentAssistKeyPropagate");
        KeyStroke keyStroke = null;
        char[] autoActivationCharacters = null;
        int autoActivationDelay = store.getInt("prefContentAssistDelay");
        String triggerKey = this.getTriggerKey();
        keyStroke = triggerKey == null ? null : this.getKeyStroke(triggerKey);
        ContentProposalAdapter adapter = new ContentProposalAdapter(control, contentAdapter, this.getContentProposalProvider(values), keyStroke, autoActivationCharacters);
        adapter.setAutoActivationDelay(autoActivationDelay);
        adapter.setPropagateKeys(propagate);
        adapter.setFilterStyle(this.getContentAssistFilterStyle());
        adapter.setProposalAcceptanceStyle(this.getContentAssistAcceptance());
    }

    private KeyStroke getKeyStroke(String triggerKey) {
        try {
            return KeyStroke.getInstance((String)triggerKey);
        }
        catch (ParseException parseException) {
            return KeyStroke.getInstance((int)0x1000013);
        }
    }

    private IContentProposalProvider getContentProposalProvider(final String[] values) {
        return new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                IContentProposal[] proposals = new IContentProposal[values.length];
                int i = 0;
                while (i < values.length) {
                    final String user = values[i];
                    proposals[i] = new IContentProposal(){

                        public String getContent() {
                            return user;
                        }

                        public String getLabel() {
                            return user;
                        }

                        public String getDescription() {
                            return null;
                        }

                        public int getCursorPosition() {
                            return user.length();
                        }
                    };
                    ++i;
                }
                return proposals;
            }
        };
    }

    private int getContentAssistAcceptance() {
        IPreferenceStore store = this.getPreferenceStore();
        String acceptanceStyle = store.getString("prefContentResult");
        if (acceptanceStyle.equals("insert")) {
            return 1;
        }
        if (acceptanceStyle.equals("replace")) {
            return 2;
        }
        return 3;
    }

    private int getContentAssistFilterStyle() {
        IPreferenceStore store = this.getPreferenceStore();
        String acceptanceStyle = store.getString("prefContentAssistFilter");
        if (acceptanceStyle.equals("character filter")) {
            return 2;
        }
        if (acceptanceStyle.equals("cumulative filter")) {
            return 3;
        }
        return 1;
    }

    private int getDecorationLocationBits() {
        IPreferenceStore store = this.getPreferenceStore();
        int bits = 0;
        String vert = store.getString("prefDecoratorVerticalLocation");
        bits = vert.equals("prefDecoratorVerticalBottom") ? 1024 : (vert.equals("prefDecoratorVerticalCenter") ? 0x1000000 : 128);
        String horz = store.getString("prefDecoratorHorizontalLocation");
        bits = horz.equals("prefDecoratorHorizontalRight") ? (bits |= 0x20000) : (bits |= 0x4000);
        return bits;
    }

    public void handleFieldModify(AssistField assistField) {
        if (!assistField.isValid()) {
            this.showError(assistField);
        } else {
            this.hideError(assistField);
            if (assistField.isWarning()) {
                this.showWarning(assistField);
            } else {
                this.hideWarning(assistField);
                if (assistField.hasContentAssist()) {
                    this.showContentAssistDecoration(assistField, true);
                }
            }
        }
    }

    public Menu createQuickFixMenu(final AssistField field) {
        Menu newMenu = new Menu(field.control);
        MenuItem item = new MenuItem(newMenu, 8);
        item.setText(Messages.getString("ssDecorationMenuItem"));
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                field.quickFix();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return newMenu;
    }

    private void showErrorDecoration(AssistField smartField, boolean show) {
        FieldDecoration dec = smartField.getErrorDecoration();
        ControlDecoration cd = smartField.controlDecoration;
        if (show) {
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(false);
            cd.show();
        } else {
            cd.hide();
        }
    }

    private void showWarningDecoration(AssistField smartField, boolean show) {
        FieldDecoration dec = smartField.getWarningDecoration();
        ControlDecoration cd = smartField.controlDecoration;
        if (show) {
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(false);
            cd.show();
        } else {
            cd.hide();
        }
    }

    private void showContentAssistDecoration(AssistField smartField, boolean show) {
        FieldDecoration dec = this.getCueDecoration();
        ControlDecoration cd = smartField.controlDecoration;
        if (show) {
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(true);
            cd.show();
        } else {
            cd.hide();
        }
    }

    private void showError(AssistField smartField) {
        this.showErrorDecoration(smartField, true);
    }

    private void hideError(AssistField smartField) {
        this.showErrorDecoration(smartField, false);
    }

    private void showWarning(AssistField smartField) {
        this.showWarningDecoration(smartField, true);
    }

    private void hideWarning(AssistField smartField) {
        this.showWarningDecoration(smartField, false);
    }

    private boolean isDecorationRight() {
        return (this.getDecorationLocationBits() & 0x20000) == 131072;
    }

    private boolean isDecorationLeft() {
        return (this.getDecorationLocationBits() & 0x4000) == 16384;
    }

    private FieldDecoration getCueDecoration() {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration dec = registry.getFieldDecoration(this.DEC_CONTENTASSIST_ID);
        if (dec == null) {
            FieldDecoration standardDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
            registry.registerFieldDecoration(this.DEC_CONTENTASSIST_ID, Messages.getFormattedString("ssDecoratorContentAssist", this.getTriggerKeyText()), standardDecoration.getImage());
            dec = registry.getFieldDecoration(this.DEC_CONTENTASSIST_ID);
        } else {
            dec.setDescription(Messages.getFormattedString("ssDecoratorContentAssist", this.getTriggerKeyText()));
        }
        return dec;
    }

    private int getHorizontialDecorationMargin() {
        return 7 + this.getMarginWidth();
    }

    public void initDecorationMargin(GridLayout gl) {
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = this.isDecorationLeft() ? this.getHorizontialDecorationMargin() : 0;
        gl.marginRight = this.isDecorationRight() ? this.getHorizontialDecorationMargin() : 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
    }

    public void addRequiredFieldIndicator(AssistField assistField, Label label) {
        boolean showRequiredFieldLabelIndicator = this.isShowingRequiredFieldIndicator();
        if (showRequiredFieldLabelIndicator && assistField.isRequiredField()) {
            String text = label.getText();
            text = text.concat("*");
            label.setText(text);
        }
    }

    public void addRequiredFieldIndicator(Label label) {
        boolean showRequiredFieldLabelIndicator = this.isShowingRequiredFieldIndicator();
        if (showRequiredFieldLabelIndicator) {
            String text = label.getText();
            text = text.concat("*");
            label.setText(text);
        }
    }

    public boolean isShowingRequiredFieldIndicator() {
        return this.getPreferenceStore().getBoolean("prefShowRequiredFieldLabelIndicator");
    }
}

