/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.PatternImage;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillCanvas;
import org.eclipse.birt.chart.ui.swt.composites.GradientEditorDialog;
import org.eclipse.birt.chart.ui.swt.composites.ImageDialog;
import org.eclipse.birt.chart.ui.swt.composites.PatternImageEditorDialog;
import org.eclipse.birt.chart.ui.swt.composites.PositiveNegativeColorDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

public class FillChooserComposite
extends Composite
implements SelectionListener,
DisposeListener,
Listener {
    private transient Composite cmpContentInner = null;
    private transient Composite cmpContentOuter = null;
    private transient Composite cmpDropDown = null;
    private transient Composite cmpButtons = null;
    private transient FillCanvas cnvSelection = null;
    private transient Button btnDown = null;
    private transient Label lblTransparency = null;
    private transient Slider srTransparency = null;
    private transient Button btnCustom = null;
    private transient Button btnGradient = null;
    private transient Button btnImage = null;
    private transient Button btnPN = null;
    private Button btnPatternFill;
    private transient Button btnReset = null;
    private transient Button btnAuto = null;
    private static Color[] colorArray = null;
    private transient boolean bGradientEnabled = true;
    private boolean bGradientAngleEnabled = true;
    private transient boolean bImageEnabled = true;
    private transient boolean bTransparentEnabled = true;
    private transient boolean bAutoEnabled = false;
    private transient Fill fCurrent = null;
    private transient boolean bTransparencyChanged = false;
    private transient boolean bTransparencySliderEnable = true;
    private transient boolean bPositiveNegativeEnabled = false;
    private boolean bPatternFillEnabled = true;
    private transient int iTransparency = 0;
    private transient Vector<Listener> vListeners = null;
    public static final int FILL_CHANGED_EVENT = 1;
    public static final int MOUSE_CLICKED_EVENT = 2;
    private transient boolean bEnabled = true;
    private transient int iSize = 18;
    private boolean bJustFocusLost = false;
    private transient ChartWizardContext wizardContext;
    boolean isPressingKey = false;
    private int selectedIndex = -1;
    public static final int ENABLE_GRADIENT = 1;
    public static final int ENABLE_IMAGE = 2;
    public static final int ENABLE_AUTO = 4;
    public static final int ENABLE_TRANSPARENT = 8;
    public static final int ENABLE_TRANSPARENT_SLIDER = 16;
    public static final int ENABLE_POSITIVE_NEGATIVE = 32;
    public static final int DISABLE_GRADIENT_ANGLE = 64;
    public static final int DISABLE_PATTERN_FILL = 128;

    public FillChooserComposite(Composite parent, int style, int optionalStyle, ChartWizardContext wizardContext, Fill fCurrent) {
        this(parent, style, wizardContext, fCurrent, (1 & optionalStyle) == 1, (2 & optionalStyle) == 2, (4 & optionalStyle) == 4, (8 & optionalStyle) == 8, (0x20 & optionalStyle) == 32, (0x80 & optionalStyle) != 128);
        this.bTransparencySliderEnable = (0x10 & optionalStyle) == 16;
        this.bGradientAngleEnabled = (0x40 & optionalStyle) != 64;
    }

    public FillChooserComposite(Composite parent, int style, ChartWizardContext wizardContext, Fill fCurrent, boolean bEnableGradient, boolean bEnableImage, boolean bEnableAuto, boolean bEnableTransparent) {
        super(parent, style);
        this.fCurrent = fCurrent;
        this.bGradientEnabled = bEnableGradient;
        this.bImageEnabled = bEnableImage;
        this.bAutoEnabled = bEnableAuto;
        this.bTransparentEnabled = bEnableTransparent;
        this.wizardContext = wizardContext;
        this.bPatternFillEnabled = bEnableImage;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    public FillChooserComposite(Composite parent, int style, ChartWizardContext wizardContext, Fill fCurrent, boolean bEnableGradient, boolean bEnableImage) {
        this(parent, style, wizardContext, fCurrent, bEnableGradient, bEnableImage, true);
    }

    public FillChooserComposite(Composite parent, int style, ChartWizardContext wizardContext, Fill fCurrent, boolean bEnableGradient, boolean bEnableImage, boolean bEnablePattern) {
        super(parent, style);
        this.fCurrent = fCurrent;
        this.bGradientEnabled = bEnableGradient;
        this.bImageEnabled = bEnableImage;
        this.bPatternFillEnabled = bEnablePattern;
        this.wizardContext = wizardContext;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    public FillChooserComposite(Composite parent, int style, ChartWizardContext wizardContext, Fill fCurrent, boolean bEnableGradient, boolean bEnableImage, boolean bEnableAuto, boolean bEnableTransparent, boolean bPositiveNegative, boolean bEnablePattern) {
        super(parent, style);
        this.fCurrent = fCurrent;
        this.bGradientEnabled = bEnableGradient;
        this.bImageEnabled = bEnableImage;
        this.bAutoEnabled = bEnableAuto;
        this.bTransparentEnabled = bEnableTransparent;
        this.bPositiveNegativeEnabled = bPositiveNegative;
        this.bPatternFillEnabled = bEnablePattern;
        this.wizardContext = wizardContext;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    private void init() {
        if (Display.getCurrent().getHighContrast()) {
            GC gc = new GC((Drawable)this);
            this.iSize = gc.getFontMetrics().getHeight() + 2;
        }
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        Display display = Display.getDefault();
        colorArray = this.createColorMap(display);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        this.setLayout((Layout)flMain);
        this.cmpContentOuter = new Composite((Composite)this, 0);
        GridLayout glContentOuter = new GridLayout();
        glContentOuter.verticalSpacing = 0;
        glContentOuter.horizontalSpacing = 0;
        glContentOuter.marginHeight = 0;
        glContentOuter.marginWidth = 0;
        glContentOuter.numColumns = 1;
        this.cmpContentOuter.setLayout((Layout)glContentOuter);
        this.cmpContentInner = new Composite(this.cmpContentOuter, 2048);
        GridLayout glContentInner = new GridLayout();
        glContentInner.verticalSpacing = 0;
        glContentInner.horizontalSpacing = 0;
        glContentInner.marginHeight = 0;
        glContentInner.marginWidth = 0;
        glContentInner.numColumns = 2;
        this.cmpContentInner.setLayout((Layout)glContentInner);
        GridData gdContentInner = new GridData(768);
        this.cmpContentInner.setLayoutData((Object)gdContentInner);
        this.cnvSelection = new FillCanvas(this.cmpContentInner, 0, this.bAutoEnabled);
        GridData gdCNVSelection = new GridData(1808);
        gdCNVSelection.heightHint = this.iSize;
        this.cnvSelection.setLayoutData(gdCNVSelection);
        this.cnvSelection.setFill(this.fCurrent);
        this.btnDown = new Button(this.cmpContentInner, 1028);
        GridData gdBDown = new GridData(4);
        gdBDown.verticalAlignment = 1;
        gdBDown.widthHint = this.iSize - 2;
        gdBDown.heightHint = this.iSize;
        this.btnDown.setLayoutData((Object)gdBDown);
        this.btnDown.addSelectionListener((SelectionListener)this);
        this.addDisposeListener(this);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                FillChooserComposite.this.handleEventCanvas(event);
            }
        };
        int[] textEvents = new int[]{1, 3, 31, 15, 16};
        int i = 0;
        while (i < textEvents.length) {
            this.cnvSelection.addListener(textEvents[i], listener);
            ++i;
        }
    }

    void handleEventCanvas(Event event) {
        block0 : switch (event.type) {
            case 15: {
                this.cnvSelection.redraw();
                break;
            }
            case 16: {
                this.cnvSelection.redraw();
                break;
            }
            case 1: {
                if (event.keyCode != 0x1000050 && event.keyCode != 13 && event.keyCode != 32) break;
                event.doit = true;
                this.toggleDropDown();
                break;
            }
            case 3: {
                if (!this.bEnabled) {
                    return;
                }
                this.toggleDropDown();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: {
                        this.getShell().close();
                        break block0;
                    }
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvSelection.redraw();
                    }
                }
            }
        }
    }

    private Color[] createColorMap(Display display) {
        return new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 154, 50, 0), new Color((Device)display, 51, 51, 0), new Color((Device)display, 0, 50, 0), new Color((Device)display, 0, 50, 100), new Color((Device)display, 0, 0, 128), new Color((Device)display, 51, 51, 153), new Color((Device)display, 51, 51, 51), new Color((Device)display, 128, 0, 0), new Color((Device)display, 255, 102, 0), new Color((Device)display, 124, 124, 0), new Color((Device)display, 0, 128, 0), new Color((Device)display, 0, 128, 128), new Color((Device)display, 0, 0, 255), new Color((Device)display, 102, 102, 153), new Color((Device)display, 128, 128, 128), new Color((Device)display, 255, 0, 0), new Color((Device)display, 255, 153, 0), new Color((Device)display, 154, 204, 0), new Color((Device)display, 51, 153, 102), new Color((Device)display, 51, 204, 204), new Color((Device)display, 51, 102, 255), new Color((Device)display, 128, 0, 128), new Color((Device)display, 145, 145, 145), new Color((Device)display, 255, 0, 255), new Color((Device)display, 255, 204, 0), new Color((Device)display, 255, 255, 0), new Color((Device)display, 0, 255, 0), new Color((Device)display, 0, 255, 255), new Color((Device)display, 0, 204, 255), new Color((Device)display, 154, 50, 102), new Color((Device)display, 192, 192, 192), new Color((Device)display, 253, 153, 204), new Color((Device)display, 255, 204, 153), new Color((Device)display, 255, 255, 153), new Color((Device)display, 204, 255, 204), new Color((Device)display, 204, 255, 255), new Color((Device)display, 153, 204, 255), new Color((Device)display, 204, 153, 255), new Color((Device)display, 255, 255, 255)};
    }

    private void createDropDownComponent(int iXLoc, int iYLoc) {
        GridData gdGradient;
        if (!this.bEnabled) {
            return;
        }
        int iShellHeight = 170;
        int iShellWidth = 190;
        if (this.bGradientEnabled) {
            iShellHeight += 30;
        }
        if (this.bImageEnabled) {
            iShellHeight += 30;
        }
        if (this.bAutoEnabled) {
            iShellHeight += 30;
        }
        if (this.bTransparentEnabled) {
            iShellHeight += 30;
        }
        if (this.bPositiveNegativeEnabled) {
            iShellHeight += 30;
        }
        if (this.bPatternFillEnabled) {
            iShellHeight += 30;
        }
        Shell shell = new Shell(this.getShell(), 524288);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(iShellWidth, iShellHeight);
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= iShellWidth;
        }
        shell.setLocation(iXLoc, iYLoc);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FillChooserComposite.this.clearColorSelection();
            }
        });
        this.cmpDropDown = new Composite((Composite)shell, 524288);
        GridLayout glDropDown = new GridLayout();
        glDropDown.marginHeight = 2;
        glDropDown.marginWidth = 2;
        glDropDown.horizontalSpacing = 1;
        glDropDown.verticalSpacing = 4;
        this.cmpDropDown.setLayout((Layout)glDropDown);
        if (colorArray == null) {
            colorArray = this.createColorMap(this.getDisplay());
        }
        ColorSelectionCanvas cnv = new ColorSelectionCanvas(this.cmpDropDown, 2048, colorArray);
        GridData gdCnv = new GridData(1808);
        gdCnv.widthHint = 190;
        gdCnv.heightHint = 110;
        cnv.setLayoutData(gdCnv);
        cnv.addListener(31, this);
        cnv.addListener(16, this);
        if (this.fCurrent instanceof ColorDefinition) {
            cnv.setColor(new Color((Device)this.getDisplay(), ((ColorDefinition)this.fCurrent).getRed(), ((ColorDefinition)this.fCurrent).getGreen(), ((ColorDefinition)this.fCurrent).getBlue()));
        }
        this.cmpButtons = new Composite(this.cmpDropDown, 524288);
        GridLayout glButtons = new GridLayout();
        glButtons.marginHeight = 3;
        glButtons.marginWidth = 4;
        glButtons.horizontalSpacing = 1;
        glButtons.verticalSpacing = 4;
        glButtons.numColumns = 2;
        this.cmpButtons.setLayout((Layout)glButtons);
        GridData gdButtons = new GridData(768);
        this.cmpButtons.setLayoutData((Object)gdButtons);
        GridLayout glTransparency = new GridLayout();
        glTransparency.numColumns = 1;
        glTransparency.horizontalSpacing = 5;
        glTransparency.verticalSpacing = 3;
        glTransparency.marginHeight = 4;
        glTransparency.marginWidth = 0;
        Composite cmpTransparency = new Composite(this.cmpButtons, 524288);
        GridData gdTransparency = new GridData(1808);
        gdTransparency.horizontalSpan = 2;
        cmpTransparency.setLayoutData((Object)gdTransparency);
        cmpTransparency.setLayout((Layout)glTransparency);
        if (this.bTransparencySliderEnable) {
            this.lblTransparency = new Label(cmpTransparency, 0);
            GridData gdLBLTransparency = new GridData(768);
            gdLBLTransparency.horizontalIndent = 2;
            this.lblTransparency.setLayoutData((Object)gdLBLTransparency);
            this.lblTransparency.setText(Messages.getString("FillChooserComposite.Lbl.Opacity"));
            this.srTransparency = new Slider(cmpTransparency, 524544);
            GridData gdTransparent = new GridData(770);
            gdTransparent.horizontalSpan = 2;
            this.srTransparency.setLayoutData((Object)gdTransparent);
            if (this.fCurrent == null) {
                this.srTransparency.setValues(0, 0, 256, 1, 1, 10);
                this.srTransparency.setEnabled(false);
            } else {
                int iValue = 0;
                if (this.fCurrent instanceof ColorDefinition) {
                    iValue = ((ColorDefinition)this.fCurrent).getTransparency();
                    this.srTransparency.setValues(iValue, 0, 256, 1, 1, 10);
                } else if (this.fCurrent instanceof Gradient) {
                    iValue = ((Gradient)this.fCurrent).getTransparency();
                    this.srTransparency.setValues(iValue, 0, 256, 1, 1, 10);
                } else {
                    this.srTransparency.setEnabled(false);
                }
            }
            this.lblTransparency.setText(new MessageFormat(Messages.getString("FillChooserComposite.Lbl.Opacity")).format(new Object[]{this.srTransparency.getSelection()}));
            this.srTransparency.setToolTipText(String.valueOf(this.srTransparency.getSelection()));
            this.srTransparency.addSelectionListener((SelectionListener)this);
            this.srTransparency.addListener(16, (Listener)this);
            this.srTransparency.addListener(1, (Listener)this);
            this.srTransparency.addListener(31, (Listener)this);
        }
        if (this.bTransparentEnabled) {
            this.btnReset = new Button(this.cmpButtons, 0);
            GridData gdReset = new GridData(1808);
            gdReset.heightHint = 28;
            gdReset.horizontalSpan = 2;
            this.btnReset.setLayoutData((Object)gdReset);
            this.btnReset.setText(Messages.getString("FillChooserComposite.Lbl.Transparent"));
            this.btnReset.addSelectionListener((SelectionListener)this);
            this.btnReset.addListener(16, (Listener)this);
            this.btnReset.addListener(1, (Listener)this);
            this.btnReset.addListener(31, (Listener)this);
        }
        if (this.bAutoEnabled) {
            this.btnAuto = new Button(this.cmpButtons, 0);
            gdGradient = new GridData(1808);
            gdGradient.heightHint = 28;
            gdGradient.horizontalSpan = 2;
            this.btnAuto.setLayoutData((Object)gdGradient);
            this.btnAuto.setText(Messages.getString("FillChooserComposite.Lbl.Auto"));
            this.btnAuto.addSelectionListener((SelectionListener)this);
            this.btnAuto.addListener(16, (Listener)this);
            this.btnAuto.addListener(1, (Listener)this);
            this.btnAuto.addListener(31, (Listener)this);
        }
        if (this.bGradientEnabled) {
            this.btnGradient = new Button(this.cmpButtons, 0);
            gdGradient = new GridData(1808);
            gdGradient.heightHint = 28;
            gdGradient.horizontalSpan = 2;
            this.btnGradient.setLayoutData((Object)gdGradient);
            this.btnGradient.setText(Messages.getString("FillChooserComposite.Lbl.Gradient"));
            this.btnGradient.addSelectionListener((SelectionListener)this);
            this.btnGradient.addListener(16, (Listener)this);
            this.btnGradient.addListener(1, (Listener)this);
            this.btnGradient.addListener(31, (Listener)this);
        }
        this.btnCustom = new Button(this.cmpButtons, 0);
        GridData gdCustom = new GridData(1808);
        gdCustom.heightHint = 28;
        gdCustom.horizontalSpan = 2;
        this.btnCustom.setLayoutData((Object)gdCustom);
        this.btnCustom.setText(Messages.getString("FillChooserComposite.Lbl.CustomColor"));
        this.btnCustom.addSelectionListener((SelectionListener)this);
        this.btnCustom.addListener(16, (Listener)this);
        this.btnCustom.addListener(1, (Listener)this);
        this.btnCustom.addListener(31, (Listener)this);
        if (this.bImageEnabled) {
            this.btnImage = new Button(this.cmpButtons, 0);
            GridData gdImage = new GridData(1808);
            gdImage.heightHint = 28;
            gdImage.horizontalSpan = 2;
            this.btnImage.setLayoutData((Object)gdImage);
            this.btnImage.setText(Messages.getString("FillChooserComposite.Lbl.Image"));
            this.btnImage.addSelectionListener((SelectionListener)this);
            this.btnImage.addListener(16, (Listener)this);
            this.btnImage.addListener(1, (Listener)this);
            this.btnImage.addListener(31, (Listener)this);
        }
        if (this.bPositiveNegativeEnabled) {
            this.btnPN = new Button(this.cmpButtons, 0);
            GridData gdPN = new GridData(1808);
            gdPN.heightHint = 28;
            gdPN.horizontalSpan = 2;
            this.btnPN.setLayoutData((Object)gdPN);
            this.btnPN.setText(Messages.getString("FillChooserComposite.Lbl.PositiveNegative"));
            this.btnPN.addSelectionListener((SelectionListener)this);
            this.btnPN.addListener(16, (Listener)this);
            this.btnPN.addListener(1, (Listener)this);
            this.btnPN.addListener(31, (Listener)this);
        }
        if (this.bPatternFillEnabled) {
            this.btnPatternFill = new Button(this.cmpButtons, 0);
            GridData gd = new GridData(1808);
            gd.heightHint = 28;
            gd.horizontalSpan = 2;
            this.btnPatternFill.setLayoutData((Object)gd);
            this.btnPatternFill.setText(Messages.getString("FillChooserComposite.Button.Pattern"));
            this.btnPatternFill.addSelectionListener((SelectionListener)this);
            this.btnPatternFill.addListener(16, (Listener)this);
            this.btnPatternFill.addListener(1, (Listener)this);
            this.btnPatternFill.addListener(31, (Listener)this);
        }
        shell.pack();
        shell.layout();
        shell.open();
    }

    public void setFill(Fill fill) {
        this.fCurrent = fill;
        this.cnvSelection.setFill(fill);
        this.cnvSelection.redraw();
    }

    public Fill getFill() {
        return this.fCurrent;
    }

    public void setEnabled(boolean bState) {
        this.btnDown.setEnabled(bState);
        this.cnvSelection.setEnabled(bState);
        this.cnvSelection.redraw();
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public Point getPreferredSize() {
        return new Point(160, 24);
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void toggleDropDown() {
        if (this.bJustFocusLost) {
            this.bJustFocusLost = false;
            return;
        }
        if (this.cmpDropDown == null || this.cmpDropDown.isDisposed() || !this.cmpDropDown.isVisible()) {
            Point pLoc = UIHelper.getScreenLocation((Composite)this.cnvSelection);
            this.createDropDownComponent(pLoc.x, pLoc.y + this.cnvSelection.getSize().y + 1);
            this.cmpDropDown.setFocus();
        } else {
            this.cmpDropDown.getShell().close();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.btnDown)) {
            this.fireHandleEvent(2);
            this.toggleDropDown();
        } else if (oSource.equals(this.btnImage)) {
            Fill imgFill;
            ImageDialog idlg = new ImageDialog(this.getShell(), this.fCurrent);
            this.cmpDropDown.getShell().close();
            if (idlg.open() == 0 && (imgFill = idlg.getResult()) != null) {
                this.addAdapters((Notifier)imgFill);
                this.setFill(imgFill);
                this.fireHandleEvent(1);
            }
        } else if (oSource.equals(this.btnPN)) {
            PositiveNegativeColorDialog pncd = null;
            this.cmpDropDown.getShell().close();
            if (this.fCurrent instanceof MultipleFill) {
                pncd = new PositiveNegativeColorDialog(this.getShell(), this.wizardContext, (MultipleFill)this.fCurrent);
            } else if (this.fCurrent instanceof ColorDefinition) {
                ColorDefinition newCD = ((ColorDefinition)this.fCurrent).copyInstance();
                newCD.eAdapters().addAll((Collection)this.fCurrent.eAdapters());
                pncd = new PositiveNegativeColorDialog(this.getShell(), this.wizardContext, null, newCD);
            } else {
                pncd = new PositiveNegativeColorDialog(this.getShell(), this.wizardContext, null);
            }
            if (pncd.open() == 0) {
                MultipleFill fTmp = pncd.getMultipleColor();
                this.addAdapters((Notifier)fTmp);
                if (this.fCurrent == null || !this.fCurrent.equals(fTmp)) {
                    this.setFill((Fill)fTmp);
                    this.fireHandleEvent(1);
                }
            }
        } else if (oSource == this.btnPatternFill) {
            PatternImageEditorDialog dialog = new PatternImageEditorDialog(this.getShell(), this.fCurrent);
            this.cmpDropDown.getShell().close();
            if (dialog.open() == 0) {
                PatternImage fTmp = dialog.getPatternImage();
                this.addAdapters((Notifier)fTmp);
                this.setFill((Fill)dialog.getPatternImage());
                this.fireHandleEvent(1);
            }
        } else if (oSource.equals(this.btnReset)) {
            this.setFill((Fill)ColorDefinitionImpl.TRANSPARENT());
            this.fireHandleEvent(1);
            this.cmpDropDown.getShell().close();
        } else if (oSource.equals(this.btnAuto)) {
            this.setFill(null);
            this.fireHandleEvent(1);
            this.cmpDropDown.getShell().close();
        } else if (oSource.equals(this.btnCustom)) {
            RGB rgb;
            ColorDialog cDlg = new ColorDialog(this.getShell(), 65536);
            this.cmpDropDown.getShell().close();
            int iTrans = 255;
            if (this.fCurrent instanceof ColorDefinition) {
                if (!this.fCurrent.equals(ColorDefinitionImpl.TRANSPARENT())) {
                    this.iTransparency = ((ColorDefinition)this.fCurrent).getTransparency();
                }
                cDlg.setRGB(new RGB(((ColorDefinition)this.fCurrent).getRed(), ((ColorDefinition)this.fCurrent).getGreen(), ((ColorDefinition)this.fCurrent).getBlue()));
            }
            if ((rgb = cDlg.open()) != null) {
                ColorDefinition cdNew = AttributeFactory.eINSTANCE.createColorDefinition();
                cdNew.set(rgb.red, rgb.green, rgb.blue);
                cdNew.setTransparency(this.bTransparencyChanged ? this.iTransparency : iTrans);
                this.addAdapters((Notifier)cdNew);
                this.setFill((Fill)cdNew);
                this.fireHandleEvent(1);
            }
        } else if (oSource.equals(this.btnGradient)) {
            GradientEditorDialog ged = null;
            this.cmpDropDown.getShell().close();
            if (this.fCurrent instanceof Gradient) {
                ged = new GradientEditorDialog(this.getShell(), this.wizardContext, (Gradient)this.fCurrent, this.bGradientAngleEnabled);
            } else if (this.fCurrent instanceof ColorDefinition) {
                ColorDefinition newCD = (ColorDefinition)this.fCurrent.copyInstance();
                newCD.eAdapters().addAll((Collection)this.fCurrent.eAdapters());
                ged = new GradientEditorDialog(this.getShell(), this.wizardContext, newCD, this.bGradientAngleEnabled);
            } else {
                ged = new GradientEditorDialog(this.getShell(), this.wizardContext, ColorDefinitionImpl.create((int)0, (int)0, (int)254), this.bGradientAngleEnabled);
            }
            if (ged.open() == 0) {
                Gradient fTmp = ged.getGradient();
                this.addAdapters((Notifier)fTmp);
                if (this.fCurrent == null || !this.fCurrent.equals(fTmp)) {
                    this.setFill((Fill)fTmp);
                    this.fireHandleEvent(1);
                }
            }
        } else if (oSource.equals(this.srTransparency)) {
            this.iTransparency = this.srTransparency.getSelection();
            this.lblTransparency.setText(new MessageFormat(Messages.getString("FillChooserComposite.Lbl.Opacity")).format(new Object[]{this.srTransparency.getSelection()}));
            this.srTransparency.setToolTipText(String.valueOf(this.srTransparency.getSelection()));
            if (this.fCurrent instanceof ColorDefinition) {
                ((ColorDefinition)this.fCurrent).setTransparency(this.srTransparency.getSelection());
            }
            this.setFill(this.fCurrent);
            this.bTransparencyChanged = true;
            this.fireHandleEvent(1);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void fireHandleEvent(int iType) {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            Event se = new Event();
            se.widget = this;
            se.data = this.fCurrent;
            se.type = iType;
            this.vListeners.get(iL).handleEvent(se);
            ++iL;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (colorArray != null) {
            int iC = 0;
            while (iC < colorArray.length) {
                colorArray[iC].dispose();
                ++iC;
            }
            colorArray = null;
        }
    }

    private boolean isPopupControl(Object control) {
        return control != null && control instanceof Control && ((Control)control).getShell() == this.cmpDropDown.getShell();
    }

    private void addAdapters(Notifier notifier) {
        if (this.wizardContext != null) {
            notifier.eAdapters().addAll((Collection)this.wizardContext.getModel().eAdapters());
        }
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = FillChooserComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = FillChooserComposite.this.toControl(new Point(e.x, e.y));
                if (FillChooserComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FillChooserComposite.this.getBounds();
                Point pt = FillChooserComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 16: {
                if (event.widget instanceof ColorSelectionCanvas) {
                    ((ColorSelectionCanvas)event.widget).redraw();
                }
                if (!this.isPopupControl(event.widget)) break;
                Control cTmp = this.isPressingKey ? this.getDisplay().getFocusControl() : this.getDisplay().getCursorControl();
                this.isPressingKey = false;
                if (cTmp != null) {
                    if (this.isPopupControl(cTmp) || SWT.getPlatform().indexOf("win32") == 0 && (cTmp.equals((Object)this.cnvSelection) || cTmp.equals(this.btnDown))) {
                        return;
                    }
                    if (cTmp.equals((Object)this.cnvSelection) || cTmp.equals(this.btnDown)) {
                        this.bJustFocusLost = true;
                    }
                }
                this.cmpDropDown.getShell().close();
                break;
            }
            case 1: {
                if (this.cmpDropDown == null || this.cmpDropDown.getShell().isDisposed()) break;
                if (event.keyCode == 0x1000001) {
                    this.cmpDropDown.getShell().close();
                    break;
                }
                if (event.keyCode != 13 && event.keyCode != 0x1000050) break;
                if (this.srTransparency != null) {
                    this.iTransparency = this.srTransparency.getSelection();
                }
                if (this.fCurrent instanceof ColorDefinition && this.bTransparencyChanged) {
                    ((ColorDefinition)this.fCurrent).setTransparency(this.iTransparency);
                }
                this.setFill(this.fCurrent);
                this.cmpDropDown.getShell().close();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 8: 
                    case 16: {
                        this.isPressingKey = true;
                        event.doit = true;
                    }
                }
            }
        }
    }

    private void setColorToModel(Color clrTmp) {
        ColorDefinition cTmp = AttributeFactory.eINSTANCE.createColorDefinition();
        cTmp.set(clrTmp.getRed(), clrTmp.getGreen(), clrTmp.getBlue());
        int iTransparency = 255;
        if (this.fCurrent instanceof ColorDefinition && this.iTransparency != 0) {
            iTransparency = this.bTransparencyChanged ? this.iTransparency : ((ColorDefinition)this.fCurrent).getTransparency();
        }
        cTmp.setTransparency(iTransparency);
        this.addAdapters((Notifier)cTmp);
        this.setFill((Fill)cTmp);
        this.fireHandleEvent(1);
    }

    private void clearColorSelection() {
        this.selectedIndex = -1;
    }

    private class ColorSelectionCanvas
    extends Canvas
    implements Listener {
        static final int ROW_SIZE = 8;
        static final int COLUMN_SIZE = 5;
        final Color[] colorMap;
        Color colorSelection;

        public ColorSelectionCanvas(Composite parent, int iStyle, Color[] colorMap) {
            super(parent, iStyle);
            this.colorSelection = null;
            this.colorMap = colorMap;
            this.addListener(9, this);
            this.addListener(1, this);
            this.addListener(3, this);
            this.addListener(15, this);
        }

        public Color getColor() {
            return this.colorSelection;
        }

        public void setColor(Color color) {
            this.colorSelection = color;
        }

        void paintControl(PaintEvent pe) {
            Color cBlack = new Color((Device)this.getDisplay(), 0, 0, 0);
            Color cWhite = new Color((Device)this.getDisplay(), 255, 255, 255);
            GC gc = pe.gc;
            gc.setForeground(cBlack);
            int iCellWidth = this.getSize().x / 8;
            int iCellHeight = this.getSize().y / 5;
            boolean isFound = false;
            int iR = 0;
            while (iR < 5) {
                int iC = 0;
                while (iC < 8) {
                    int index = iR * 8 + iC;
                    try {
                        gc.setBackground(this.colorMap[index]);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    gc.fillRectangle(iC * iCellWidth, iR * iCellHeight, iCellWidth, iCellHeight);
                    if (FillChooserComposite.this.selectedIndex == index || !isFound && this.colorSelection != null && this.colorSelection.equals((Object)this.colorMap[index])) {
                        isFound = true;
                        FillChooserComposite.this.selectedIndex = index;
                        if (this.colorSelection == null) {
                            this.colorSelection = this.colorMap[index];
                        }
                        if (this.isFocusControl()) {
                            gc.setLineStyle(3);
                        }
                        gc.drawRectangle(iC * iCellWidth, iR * iCellHeight, iCellWidth - 2, iCellHeight - 2);
                        gc.setForeground(cWhite);
                        gc.drawRectangle(iC * iCellWidth + 1, iR * iCellHeight + 1, iCellWidth - 3, iCellHeight - 3);
                        gc.setForeground(cBlack);
                    }
                    ++iC;
                }
                ++iR;
            }
            if (!isFound) {
                FillChooserComposite.this.clearColorSelection();
            }
            cBlack.dispose();
            cWhite.dispose();
            gc.dispose();
        }

        public Color getColorAt(int x, int y) {
            int iCellWidth = this.getSize().x / 8;
            int iCellHeight = this.getSize().y / 5;
            int iHCell = x / iCellWidth;
            int iVCell = y / iCellHeight;
            int iArrayIndex = iVCell * 8 + iHCell;
            return this.colorMap[iArrayIndex];
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    this.paintControl(new PaintEvent(event));
                    break;
                }
                case 15: {
                    this.redraw();
                    break;
                }
                case 1: {
                    this.keyDown(event);
                    break;
                }
                case 3: {
                    if (!FillChooserComposite.this.bEnabled) {
                        return;
                    }
                    FillChooserComposite.this.fireHandleEvent(2);
                    FillChooserComposite.this.setColorToModel(this.getColorAt(event.x, event.y));
                    FillChooserComposite.this.cmpDropDown.getShell().close();
                }
            }
        }

        void keyDown(Event event) {
            if (event.keyCode == 27) {
                FillChooserComposite.this.cmpDropDown.getShell().close();
                return;
            }
            if (FillChooserComposite.this.selectedIndex == -1) {
                if (event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    FillChooserComposite.this.selectedIndex = 0;
                }
            } else {
                switch (event.keyCode) {
                    case 0x1000003: {
                        if (FillChooserComposite.this.selectedIndex - 1 < 0) break;
                        FillChooserComposite fillChooserComposite = FillChooserComposite.this;
                        fillChooserComposite.selectedIndex = fillChooserComposite.selectedIndex - 1;
                        break;
                    }
                    case 0x1000004: {
                        if (FillChooserComposite.this.selectedIndex + 1 >= 40) break;
                        FillChooserComposite fillChooserComposite = FillChooserComposite.this;
                        fillChooserComposite.selectedIndex = fillChooserComposite.selectedIndex + 1;
                        break;
                    }
                    case 0x1000001: {
                        if (FillChooserComposite.this.selectedIndex - 8 < 0) break;
                        FillChooserComposite fillChooserComposite = FillChooserComposite.this;
                        fillChooserComposite.selectedIndex = fillChooserComposite.selectedIndex - 8;
                        break;
                    }
                    case 0x1000002: {
                        if (FillChooserComposite.this.selectedIndex + 8 >= 40) break;
                        FillChooserComposite fillChooserComposite = FillChooserComposite.this;
                        fillChooserComposite.selectedIndex = fillChooserComposite.selectedIndex + 8;
                        break;
                    }
                    case 13: 
                    case 0x1000050: {
                        FillChooserComposite.this.setColorToModel(this.colorMap[FillChooserComposite.this.selectedIndex]);
                        FillChooserComposite.this.cmpDropDown.getShell().close();
                    }
                }
            }
            if (!FillChooserComposite.this.cmpDropDown.isDisposed()) {
                this.colorSelection = null;
                this.redraw();
            }
        }
    }
}

