/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.ide.IModelWorkbenchListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ModelManagerListeners {
    List<IModelWorkbenchListener> manangerListeners = new ArrayList<IModelWorkbenchListener>();

    ModelManagerListeners() {
    }

    public synchronized void addModelManagerListener(IModelWorkbenchListener listener) {
        this.manangerListeners.add(listener);
    }

    public synchronized void removeModelManagerListener(IModelWorkbenchListener listener) {
        this.manangerListeners.remove(listener);
    }

    protected synchronized void notifyViewAdded(IViewPart showViewPart) {
        for (IModelWorkbenchListener viewListener : this.manangerListeners) {
            viewListener.viewAdded((IWorkbenchPart)showViewPart);
        }
    }

    protected synchronized void notifyViewRemoved(IViewPart showViewPart) {
        for (IModelWorkbenchListener viewListener : this.manangerListeners) {
            viewListener.viewRemoved((IWorkbenchPart)showViewPart);
        }
    }

    protected synchronized void notifyModelActivated(IModel model) {
        for (IModelWorkbenchListener viewListener : this.manangerListeners) {
            viewListener.modelActivated(model);
        }
    }

    protected synchronized void notifyModelAdded(IModel model) {
        for (IModelWorkbenchListener viewListener : this.manangerListeners) {
            viewListener.modelAdded(model);
        }
    }

    protected synchronized void notifyModelRemoved(IModel model) {
        for (IModelWorkbenchListener viewListener : this.manangerListeners) {
            viewListener.modelRemoved(model);
        }
    }
}

