/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.ide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.metaabm.MetaABMFactory;
import org.metaabm.MetaABMPackage;
import org.metaabm.SContext;
import org.metaabm.SImplementationMode;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.provider.MetaABMActItemProviderAdapterFactory;
import org.metaabm.commands.AddAgentsActsCommand;
import org.metaabm.commands.AddImplementatedCommand;
import org.metaabm.function.provider.MetaABMFunctionItemProviderAdapterFactory;
import org.metaabm.ide.CustomModelWizardInitialObjectCreationPage;
import org.metaabm.ide.CustomModelWizardNewFileCreationPage;
import org.metaabm.ide.MetaABMModelerPlugin;
import org.metaabm.provider.MetaABMItemProviderAdapterFactory;

public class CustomMetaABMModelWizard
extends Wizard
implements INewWizard {
    public static final String copyright = "";
    protected MetaABMPackage metaabmPackage = MetaABMPackage.eINSTANCE;
    protected MetaABMFactory metaabmFactory = this.metaabmPackage.getMetaABMFactory();
    protected CustomModelWizardNewFileCreationPage newFileCreationPage;
    protected CustomModelWizardInitialObjectCreationPage contextPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(MetaABMModelerPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(MetaABMModelerPlugin.INSTANCE.getImage("full/wizban/MetaABMModelFile")));
    }

    protected EObject createInitialModel() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetaABMItemProviderAdapterFactory());
        factories.add(new MetaABMFunctionItemProviderAdapterFactory());
        MetaABMActItemProviderAdapterFactory metaabmActItemProviderAdapterFactory = new MetaABMActItemProviderAdapterFactory();
        factories.add(metaabmActItemProviderAdapterFactory);
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        SContext rootContext = MetaABMFactory.eINSTANCE.createSContext();
        AddImplementatedCommand implCmd = new AddImplementatedCommand((EditingDomain)domain, Collections.singleton(rootContext));
        domain.getCommandStack().execute((Command)implCmd);
        domain.getCommandStack().execute(SetCommand.create((EditingDomain)domain, (Object)rootContext, (Object)MetaABMPackage.Literals.SACTABLE__ROOT_ACTIVITY, (Object)MetaABMActFactory.eINSTANCE.createAGroup()));
        AddAgentsActsCommand actsCmd = new AddAgentsActsCommand((EditingDomain)domain, null, Collections.singleton(rootContext));
        domain.getCommandStack().execute((Command)actsCmd);
        Command setNameCmd = SetCommand.create((EditingDomain)domain, (Object)rootContext, (Object)MetaABMPackage.Literals.IID__LABEL, (Object)this.contextPage.getModelName());
        domain.getCommandStack().execute(setNameCmd);
        Command setBasePathCmd = SetCommand.create((EditingDomain)domain, (Object)rootContext.getImplementation(), (Object)MetaABMPackage.Literals.SIMPLEMENTATION__BASE_PATH, (Object)this.contextPage.getBaseDir());
        domain.getCommandStack().execute(setBasePathCmd);
        Command setPackage = SetCommand.create((EditingDomain)domain, (Object)rootContext.getImplementation(), (Object)MetaABMPackage.eINSTANCE.getSImplementation_Package(), (Object)this.contextPage.getPackage());
        domain.getCommandStack().execute(setPackage);
        Command setImplMode2 = SetCommand.create((EditingDomain)domain, (Object)rootContext.getImplementation(), (Object)MetaABMPackage.eINSTANCE.getSImplementation_Mode(), (Object)SImplementationMode.getByName((String)this.contextPage.getMode()));
        domain.getCommandStack().execute(setImplMode2);
        return rootContext;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)false);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = CustomMetaABMModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", CustomMetaABMModelWizard.this.contextPage.getEncoding());
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            MetaABMModelerPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)MetaABMModelerPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            MetaABMModelerPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new CustomModelWizardNewFileCreationPage("metaABM Model Name", this.selection);
        this.newFileCreationPage.setTitle(MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMModelWizard_label"));
        this.newFileCreationPage.setDescription(MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMEditorFilenameDefaultBase")) + "." + MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMEditorFilenameExtension");
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.contextPage = new CustomModelWizardInitialObjectCreationPage(this, "metaABM Model Setup");
        this.contextPage.setTitle(MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMModelWizard_label"));
        this.contextPage.setDescription(MetaABMModelerPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.contextPage);
    }

    public String getDefaultBaseDir() {
        return copyright;
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }
}

