/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.FloatBuffer;
import org.eclipse.draw3d.graphics.optimizer.primitive.OutlineRenderRule;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglLinePattern;
import org.lwjgl.opengl.GL11;

public class LineHelper {
    private float m_lineWidth;
    private int m_lineStyle;
    private int[] m_lineDash;
    private LwjglLinePattern m_linePattern;
    private int m_vertexLength;
    private int m_coordOffset;

    public boolean isTextured() {
        return this.m_lineStyle == 6;
    }

    public LineHelper(OutlineRenderRule i_renderRule) {
        this.m_lineWidth = i_renderRule.getLineWidth();
        this.m_lineStyle = i_renderRule.getLineStyle();
        if (this.isTextured()) {
            throw new IllegalArgumentException("must set vertex length and offset for custom line patterns");
        }
    }

    public LineHelper(OutlineRenderRule i_renderRule, int i_vertexLength, int i_coordOffset) {
        this.m_lineWidth = i_renderRule.getLineWidth();
        this.m_lineStyle = i_renderRule.getLineStyle();
        this.m_lineDash = i_renderRule.getLineDash();
        if (this.isTextured() && this.m_lineDash == null) {
            throw new IllegalArgumentException("cannot create custom line pattern without a dash pattern");
        }
    }

    public void addTextureCoordinate(float i_x1, float i_y1, float i_x2, float i_y2, FloatBuffer i_buffer) {
        if (!this.isTextured()) {
            return;
        }
        if (i_buffer == null) {
            throw new NullPointerException("i_buffer must not be null");
        }
        i_buffer.put(this.m_linePattern.getS(i_x1, i_y1, i_x2, i_y2));
    }

    public void initialize(Graphics3D i_g3d) {
        if (this.isTextured()) {
            this.m_linePattern = new LwjglLinePattern(this.m_lineDash, i_g3d.getDisplayListManager());
            this.m_lineDash = null;
        }
    }

    public void dispose() {
        if (this.m_linePattern != null) {
            this.m_linePattern.dispose();
            this.m_linePattern = null;
        }
    }

    public void prepare(Graphics3D i_g3d) {
        switch (this.m_lineStyle) {
            case 2: {
                GL11.glEnable((int)2852);
                GL11.glLineStipple((int)3, (short)16191);
                break;
            }
            case 3: {
                GL11.glEnable((int)2852);
                GL11.glLineStipple((int)3, (short)13107);
                break;
            }
            case 4: {
                GL11.glEnable((int)2852);
                GL11.glLineStipple((int)3, (short)28527);
                break;
            }
            case 5: {
                GL11.glEnable((int)2852);
                GL11.glLineStipple((int)3, (short)22359);
                break;
            }
            case 6: {
                this.m_linePattern.activate();
                GL11.glEnableClientState((int)32888);
                GL11.glTexCoordPointer((int)1, (int)5126, (int)this.m_vertexLength, (long)(this.m_coordOffset * 4));
            }
        }
        GL11.glLineWidth((float)this.m_lineWidth);
    }

    public void cleanup(Graphics3D i_g3d) {
        switch (this.m_lineStyle) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                GL11.glDisable((int)2852);
                break;
            }
            case 6: {
                GL11.glDisableClientState((int)32888);
                this.m_linePattern.deactivate();
            }
        }
    }
}

