/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.amf.ide;

import org.ascape.runtime.Runner;
import org.eclipse.amp.amf.parameters.AParFactory;
import org.eclipse.amp.amf.parameters.AParInterpreter;
import org.eclipse.amp.axf.time.ITimeGranularity;
import org.eclipse.amp.axf.time.TimeGranularity;
import org.eclipse.amp.escape.command.ExecuteHandler;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.metaabm.SContext;

public class ExecuteParameterHandler
extends ExecuteHandler {
    private AParInterpreter interpreter;
    protected IResource modelResource;
    private SContext model;

    public ExecuteParameterHandler(boolean headless) {
        super(headless);
    }

    public ExecuteParameterHandler() {
        super(false);
    }

    protected EclipseEscapeRunner executeOpen(Object executed, IProgressMonitor monitor) {
        if (executed instanceof IResource) {
            this.modelResource = (IResource)executed;
            IProject project = this.modelResource.getProject();
            if (this.modelResource.getFileExtension().equals("apar")) {
                this.setInterpreter((AParInterpreter)AParFactory.create(null).getInterpreter(this.modelResource));
                this.model = this.getInterpreter().getRootContext();
                EclipseEscapeRunner eclipseRunner = this.createRunner();
                if (this.isHeadless()) {
                    eclipseRunner.setUpdateGranularity((ITimeGranularity)TimeGranularity.createFrequencyGranularity((int)Integer.MAX_VALUE));
                }
                eclipseRunner.setMonitor(monitor);
                eclipseRunner.setAutoRestart(false);
                eclipseRunner.open((IResource)project, this.model.getImplementation().getQualifiedName(), this.getInterpreter().getRunName(), this.getInterpreter().getArgs());
                return eclipseRunner;
            }
        }
        return null;
    }

    protected EclipseEscapeRunner createRunner() {
        Runner.setDisplayGraphics((!this.isHeadless() ? 1 : 0) != 0);
        EclipseEscapeRunner runner = new EclipseEscapeRunner(){
            private static final long serialVersionUID = 1L;

            public void openImplementation(String[] args, boolean block) {
                ExecuteParameterHandler.this.getInterpreter().assignValues(new Object[]{this.getRootScape(), this}, null);
                super.openImplementation(args, block);
            }
        };
        return runner;
    }

    protected boolean handleSelect(Object sel) {
        return sel instanceof IResource && ((IResource)sel).getFileExtension() != null && ((IResource)sel).getFileExtension().equals("apar");
    }

    public void setInterpreter(AParInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public AParInterpreter getInterpreter() {
        return this.interpreter;
    }

    public SContext getModel() {
        return this.model;
    }
}

