/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.handles;

import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.shapes.CuboidFigureShape;
import org.eclipse.draw3d.shapes.CuboidShape;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef3d.handles.AbstractHandle3D;
import org.eclipse.gef3d.handles.MoveHandleLocator3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveHandle3D
extends AbstractHandle3D {
    private static final float INNER_PAD = 4.0f;
    private CuboidFigureShape m_shape = new CuboidFigureShape((IFigure3D)this, true);

    public MoveHandle3D(GraphicalEditPart owner) {
        this(owner, (Locator)new MoveHandleLocator3D(owner.getFigure()));
    }

    public MoveHandle3D(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
        this.initialize();
    }

    public void collectRenderFragments(RenderContext i_renderContext) {
        i_renderContext.addRenderFragment((RenderFragment)this.m_shape);
    }

    @Override
    protected DragTracker createDragTracker() {
        DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getOwner());
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        float outer = this.m_shape.getDistance(i_rayOrigin, i_rayDirection, i_context);
        if (!Float.isNaN(outer)) {
            float f;
            Position3D pos = Draw3DCache.getPosition3D();
            Vector3f v = Draw3DCache.getVector3f();
            try {
                pos.setPosition((IPosition3D)this.getPosition3D());
                v.set(pos.getSize3D());
                v.setX(v.getX() - 4.0f);
                v.setY(v.getY() - 4.0f);
                v.setZ(v.getZ() + 0.05f);
                pos.setSize3D((IVector3f)v);
                CuboidShape neg = new CuboidShape((IPosition3D)pos, false);
                float inner = neg.getDistance(i_rayOrigin, i_rayDirection, i_context);
                f = Float.isNaN(inner) ? outer : Float.NaN;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
                Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{pos});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
            Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{pos});
            return f;
        }
        return outer;
    }

    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        return this.m_shape.getParaxialBoundingBox(o_result);
    }

    protected void initialize() {
        this.setOpaque(false);
        this.setBorder((Border)new LineBorder(1));
        this.setCursor(Cursors.SIZEALL);
        this.setAlpha(100);
        this.setBackgroundColor(ColorConstants.green);
        this.setForegroundColor(ColorConstants.green);
        this.m_shape.setFill(false);
    }
}

