/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import org.ascape.model.Agent;
import org.ascape.model.Cell;
import org.ascape.model.LocatedAgent;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.space.Array2DBase;
import org.ascape.model.space.Coordinate2DDiscrete;
import org.ascape.util.vis.DrawFeature;
import org.ascape.view.vis.Overhead2DView;
import org.eclipse.draw2d.Graphics;

public class OverheadRelative2DView
extends Overhead2DView {
    private static final long serialVersionUID = -8028767901003500196L;
    private Coordinate2DDiscrete origin = new Coordinate2DDiscrete(0, 0);
    private int xOffset;
    private int yOffset;
    private int xMax;
    private int yMax;
    private boolean[][] cellSelected;
    boolean drawBorder = false;
    private int cellsSelected;

    public OverheadRelative2DView() {
        super("Overhead 2D Realtive View");
    }

    public OverheadRelative2DView(String name) {
    }

    public Coordinate2DDiscrete getOrigin() {
        return this.origin;
    }

    public void setOffset(Coordinate2DDiscrete origin) {
        this.origin = origin;
    }

    public void scapeStarted(ScapeEvent scapeEvent) {
        this.cellSelected = new boolean[((Array2DBase)this.getScape().getSpace()).getXSize()][((Array2DBase)this.getScape().getSpace()).getYSize()];
        this.cellsSelected = 0;
    }

    public void drawCellAtIfUpdate(Graphics graphics, int x, int y) {
        Cell cell = (Cell)((Array2DBase)this.getScape().getSpace()).get((x + this.xOffset) % this.xMax, (y + this.yOffset) % this.yMax);
        if (cell.isUpdateNeeded(this.getScape().getIterationsPerRedraw())) {
            Object[] objectArray = this.drawFeatures;
            int n = this.drawFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                Object drawFeature = objectArray[n2];
                ((DrawFeature)drawFeature).draw(graphics, cell, this.agentSize, this.agentSize);
                ++n2;
            }
        }
    }

    public void drawCellAt(Graphics graphics, int x, int y) {
        Cell cell = (Cell)((Array2DBase)this.getScape().getSpace()).get((x + this.xOffset) % this.xMax, (y + this.yOffset) % this.yMax);
        Object[] objectArray = this.drawFeatures;
        int n = this.drawFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            Object drawFeature = objectArray[n2];
            ((DrawFeature)drawFeature).draw(graphics, cell, this.agentSize, this.agentSize);
            ++n2;
        }
    }

    public void updateScapeGraphics(Graphics graphics) {
        this.xOffset = this.origin.getXValue();
        this.yOffset = this.origin.getYValue();
        super.updateScapeGraphics(graphics);
    }

    public Agent getAgentAtPixel(int x, int y) {
        int td = this.agentSize + this.borderSize;
        x = (x / td + this.origin.getXValue()) % ((Array2DBase)this.getScape().getSpace()).getXSize();
        y = (y / td + this.origin.getYValue()) % ((Array2DBase)this.getScape().getSpace()).getYSize();
        return (Cell)((Array2DBase)this.getScape().getSpace()).get(x, y);
    }

    public void drawSelectedAgent(Graphics g, LocatedAgent a) {
        int y;
        Coordinate2DDiscrete coor = (Coordinate2DDiscrete)a.getCoordinate();
        int x = coor.getXValue() - this.xOffset;
        if (x < 0) {
            x += ((Array2DBase)this.getScape().getSpace()).getXSize();
        }
        if ((y = coor.getYValue() - this.yOffset) < 0) {
            y += ((Array2DBase)this.getScape().getSpace()).getYSize();
        }
        int td = this.agentSize + this.borderSize;
        g.translate(x * td, y * td);
        this.drawSelectedAgentAt(g, a);
        if (this.drawSelectedNeighbors) {
            this.drawNeighborsFor(g, a);
        }
        g.translate(-x * td, -y * td);
        if (this.getScape().isCellsRequestUpdates()) {
            int xmin = x - 1 < 0 ? (x = 0) : x - 1;
            int xmax = x + 1 < ((Array2DBase)this.getScape().getSpace()).getXSize() ? x + 1 : x;
            int ymin = y - 1 < 0 ? (y = 0) : y - 1;
            int ymax = y + 1 < ((Array2DBase)this.getScape().getSpace()).getXSize() ? y + 1 : y;
            int i = xmin;
            while (i <= xmax) {
                int j = ymin;
                while (j <= ymax) {
                    ((Cell)((Array2DBase)this.getScape().getSpace()).get(i, j)).requestUpdateNext();
                    ++j;
                }
                ++i;
            }
        }
    }
}

