/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.engine;

import org.ascape.model.Agent;
import org.ascape.model.Scape;
import org.ascape.model.engine.AgentSelector;
import org.ascape.model.engine.ExecutionStrategy;
import org.ascape.model.engine.RuleSelector;
import org.ascape.model.engine.StrategyFactory;
import org.ascape.model.rule.Rule;
import org.ascape.util.ResetableIterator;

public abstract class IncrementalExecutionStrategy
extends ExecutionStrategy {
    private static final long serialVersionUID = 1L;
    StrategyFactory factory;
    private ResetableIterator agentIterator;
    AgentSelector agentSelector;
    RuleSelector ruleSelector;
    Rule currentRule;
    Agent currentAgent;

    public IncrementalExecutionStrategy(StrategyFactory factory) {
        this.factory = factory;
    }

    public void execute() {
        this.reset();
        while (this.hasNext()) {
            this.increment();
            this.fire();
        }
    }

    public void fire() {
        this.currentRule.execute(this.currentAgent);
    }

    public void reset() {
        this.getAgentSelector().reset();
        this.getRuleSelector().reset();
    }

    public Agent getCurrentAgent() {
        return this.currentAgent;
    }

    public Rule getCurrentRule() {
        return this.currentRule;
    }

    public abstract boolean hasNext();

    public abstract void increment();

    public ResetableIterator getAgentIterator() {
        return this.agentIterator;
    }

    public void setAgentIterator(ResetableIterator agentIterator) {
        this.agentIterator = agentIterator;
    }

    public final Object[] getRules() {
        return this.factory.getRules();
    }

    public AgentSelector getAgentSelector() {
        return this.agentSelector;
    }

    public RuleSelector getRuleSelector() {
        return this.ruleSelector;
    }

    public void setAgentSelector(AgentSelector agentSelector) {
        this.agentSelector = agentSelector;
    }

    public void setRuleSelector(RuleSelector ruleSelector) {
        this.ruleSelector = ruleSelector;
    }

    public final Scape getScape() {
        return this.factory.getScape();
    }

    public Object clone() {
        IncrementalExecutionStrategy clone = (IncrementalExecutionStrategy)super.clone();
        clone.agentIterator = null;
        if (clone.agentSelector != null) {
            clone.agentSelector = (AgentSelector)this.agentSelector.clone();
            clone.agentSelector.setStrategy(clone);
        } else {
            clone.agentSelector = null;
        }
        clone.ruleSelector = clone.ruleSelector != null ? (RuleSelector)this.ruleSelector.clone() : null;
        return clone;
    }
}

