/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.chart;

import java.util.HashMap;
import java.util.Map;
import org.ascape.model.Scape;
import org.ascape.util.data.DataSelection;
import org.ascape.util.data.DataSeries;
import org.ascape.util.data.StatCollector;
import org.eclipse.amp.agf.chart.ChartEditPart;
import org.eclipse.amp.agf.chart.ChartViewPart;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModel;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ChartCustomizer
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.amp.view.customizer.Chart";
    protected Scape scape;
    protected DataSelection dataSelection;
    protected ChartEditPart chartEditPart;
    private TableViewer selectTable;
    private Composite control;
    private DisposeListener chartDisposeListener;
    private ArrayContentProvider statTableProvider;
    private StatTableItemProvider statTableLabelProvider;

    void checkEnabledState() {
        if (this.control != null) {
            this.control.setEnabled(this.chartEditPart != null);
        }
    }

    public void createPartControl(Composite parent) {
        this.control = new Composite(parent, 256);
        GridLayout allLayout = new GridLayout();
        allLayout.numColumns = 2;
        this.control.setLayout((Layout)allLayout);
        this.checkEnabledState();
        Composite general = new Composite(this.control, 16);
        GridLayout generalLayout = new GridLayout();
        generalLayout.numColumns = 1;
        general.setLayout((Layout)generalLayout);
        general.setLayoutData((Object)new GridData(1, 4, false, true));
        this.chartDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChartCustomizer.this.setInput(null);
            }
        };
        this.buildTable();
        this.getViewSite().getPage().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof ChartViewPart) {
                    ChartCustomizer.this.setInput(((ChartViewPart)part).getEditPart());
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        });
    }

    private void buildTable() {
        this.selectTable = new TableViewer(this.control, 256);
        this.statTableProvider = new ArrayContentProvider();
        this.selectTable.setContentProvider((IContentProvider)this.statTableProvider);
        this.statTableLabelProvider = new StatTableItemProvider();
        this.selectTable.setLabelProvider((IBaseLabelProvider)this.statTableLabelProvider);
        Table statTable = this.selectTable.getTable();
        statTable.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        statTable.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200));
        this.selectTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn statNameColumn = new TableViewerColumn(this.selectTable, 16384);
        statNameColumn.getColumn().setText("Name");
        statNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((StatCollector)element).getName();
            }
        });
        int i = 0;
        String[] stringArray = StatCollector.getAllMeasureNamesShort();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(40));
            TableViewerColumn viewerColumn = new TableViewerColumn(this.selectTable, 0x1000000);
            viewerColumn.getColumn().setText(name);
            viewerColumn.setLabelProvider((CellLabelProvider)new MeasureLabelProvider(i));
            viewerColumn.setEditingSupport((EditingSupport)new MeasureEditSupport((ColumnViewer)this.selectTable, i));
            ++i;
            ++n2;
        }
        this.selectTable.refresh();
    }

    public void setInput(Object object) {
        if (object instanceof ChartEditPart) {
            if (this.chartEditPart != null && this.chartEditPart.getViewer().getControl() != null) {
                this.chartEditPart.getViewer().getControl().removeDisposeListener(this.chartDisposeListener);
            }
            this.chartEditPart = (ChartEditPart)object;
            this.scape = ((ScapeWrapperModel)this.chartEditPart.getModel()).getScape();
            if (this.scape.getData() != null) {
                this.dataSelection = (DataSelection)this.chartEditPart.getDataProvider().getDataSource(this.chartEditPart.getModel());
                this.selectTable.setContentProvider((IContentProvider)this.statTableProvider);
                this.selectTable.setInput((Object)this.scape.getData().getStatCollectors());
            }
            this.chartEditPart.getViewer().getControl().addDisposeListener(this.chartDisposeListener);
        } else if (object == null && this.chartEditPart != null) {
            if (this.chartEditPart.getViewer().getControl() != null) {
                this.chartEditPart.getViewer().getControl().removeDisposeListener(this.chartDisposeListener);
            }
            this.chartEditPart = null;
            this.dataSelection = null;
            if (this.control != null) {
                this.control.setEnabled(false);
            }
            this.selectTable.setInput(null);
        }
        this.checkEnabledState();
        this.selectTable.refresh(true);
    }

    public void setFocus() {
    }

    public ChartEditPart getChartEditPart() {
        return this.chartEditPart;
    }

    public void refresh() {
        this.selectTable.refresh();
    }

    TableViewer getSelectTable() {
        return this.selectTable;
    }

    class MeasureEditSupport
    extends EditingSupport {
        int measureNumber;
        Map<Object, CheckboxCellEditor> checkBoxFor;

        public MeasureEditSupport(ColumnViewer viewer, int measureNumber) {
            super(viewer);
            this.checkBoxFor = new HashMap<Object, CheckboxCellEditor>();
            this.measureNumber = measureNumber;
        }

        private DataSeries getDataSeries(Object id) {
            return ((StatCollector)id).getAllDataSeries()[this.measureNumber];
        }

        protected boolean canEdit(Object element) {
            return this.getDataSeries(element) != null;
        }

        protected CellEditor getCellEditor(Object element) {
            CheckboxCellEditor checkboxCellEditor = this.checkBoxFor.get(element);
            if (checkboxCellEditor == null) {
                checkboxCellEditor = new CheckboxCellEditor((Composite)ChartCustomizer.this.getSelectTable().getTable());
            }
            return checkboxCellEditor;
        }

        protected Object getValue(Object element) {
            if (ChartCustomizer.this.dataSelection != null && this.getDataSeries(element) != null) {
                return ChartCustomizer.this.dataSelection.isSelected(this.getDataSeries(element));
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            if (ChartCustomizer.this.dataSelection != null) {
                DataSeries dataSeries = this.getDataSeries(element);
                if (dataSeries != null) {
                    ChartCustomizer.this.dataSelection.setSelected(dataSeries, ((Boolean)value).booleanValue());
                }
                ChartCustomizer.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((MeasureEditSupport)MeasureEditSupport.this).ChartCustomizer.this.chartEditPart.refresh();
                    }
                });
                ChartCustomizer.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ChartCustomizer.this.getSelectTable().getTable().deselectAll();
                        ChartCustomizer.this.getSelectTable().refresh(true);
                    }
                });
            }
        }
    }

    class MeasureLabelProvider
    extends ColumnLabelProvider {
        int measureNumber;

        public MeasureLabelProvider(int measureNumber) {
            this.measureNumber = measureNumber;
        }

        private DataSeries getDataSeries(Object id) {
            return ((StatCollector)id).getAllDataSeries()[this.measureNumber];
        }

        public String getText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            DataSeries dataSeries = this.getDataSeries(element);
            if (dataSeries == null) {
                return ColorConstants.lightGray;
            }
            if (ChartCustomizer.this.dataSelection.isSelected(dataSeries)) {
                return ChartCustomizer.this.chartEditPart.getSeriesColorProvider().getForeground((Object)dataSeries.getName());
            }
            return ColorConstants.white;
        }
    }

    class StatTableItemProvider
    extends LabelProvider
    implements ITableLabelProvider {
        StatTableItemProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex > 0) {
                return StatCollector.getAllMeasureNamesShort()[columnIndex - 1];
            }
            return ((StatCollector)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

