/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

public interface Locator1D {
    public float getLocation(float var1);

    public static class Absolute
    implements Locator1D {
        private float m_offset;
        private Position m_position;

        public Absolute(Position i_position, float i_offset) {
            if (i_position == null) {
                throw new NullPointerException("i_position must not be null");
            }
            this.m_position = i_position;
            this.m_offset = Math.max(0.0f, i_offset);
        }

        public float getLocation(float i_length) {
            if (this.m_position == Position.BEGINNING) {
                return Math.min(this.m_offset, i_length);
            }
            return Math.max(0.0f, i_length - this.m_offset);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Position {
            BEGINNING,
            END;

        }
    }

    public static class Relative
    implements Locator1D {
        private float m_weight;

        public Relative(float i_weight) {
            if (i_weight < 0.0f || i_weight > 1.0f) {
                throw new IllegalArgumentException("weights must be 0 <= weights <= 1, was " + i_weight);
            }
            this.m_weight = i_weight;
        }

        public float getLocation(float i_length) {
            return this.m_weight * i_length;
        }
    }
}

