/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer.primitive;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.graphics.GraphicsState;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveBounds;
import org.eclipse.draw3d.graphics.optimizer.primitive.AbstractPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextRenderRule;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class TextPrimitive
extends AbstractPrimitive {
    private boolean m_expand;
    private Point m_position;
    private String m_text;
    private Dimension m_extent;

    public TextPrimitive(GraphicsState i_state, String i_text, boolean i_expand, Point i_position) {
        super((IMatrix3f)i_state.getTransformation(), new TextRenderRule(i_state));
        if (i_text == null) {
            throw new NullPointerException("i_text must not be null");
        }
        if (i_position == null) {
            throw new NullPointerException("i_position must not be null");
        }
        this.m_text = i_text;
        this.m_expand = i_expand;
        this.m_position = i_position;
    }

    public Dimension getExtent() {
        if (this.m_extent == null) {
            Device device = ((TextRenderRule)this.getRenderRule()).getFont().getDevice();
            Image image = new Image(device, 1, 1);
            GC gc = new GC((Drawable)image);
            try {
                org.eclipse.swt.graphics.Point extent = gc.textExtent(this.m_text, this.m_expand ? 6 : 0);
                int w = extent.x;
                int h = extent.y;
                this.m_extent = new Dimension(w, h);
            }
            finally {
                gc.dispose();
                image.dispose();
            }
        }
        return this.m_extent;
    }

    protected PrimitiveBounds calculateBounds() {
        Dimension extent = this.getExtent();
        float[] vertices = this.getTransformedVertices(this.m_position.x, this.m_position.y, extent.width, extent.height);
        return new PrimitiveBounds(vertices);
    }

    public Point getPosition() {
        return this.m_position;
    }

    public String getText() {
        return this.m_text;
    }

    private float[] getTransformedVertices(int i_x, int i_y, int i_w, int i_h) {
        IMatrix3f t = this.getTransformation();
        float[] vertices = new float[8];
        if (t != null && !IMatrix3f.IDENTITY.equals(t)) {
            Vector2f v = Draw3DCache.getVector2f();
            try {
                v.set((float)i_x, (float)i_y);
                Math3D.transform((IVector2f)v, (IMatrix3f)t, (Vector2f)v);
                vertices[0] = v.getX();
                vertices[1] = v.getY();
                v.set((float)i_x, (float)(i_y + i_h));
                Math3D.transform((IVector2f)v, (IMatrix3f)t, (Vector2f)v);
                vertices[2] = v.getX();
                vertices[3] = v.getY();
                v.set((float)(i_x + i_w), (float)(i_y + i_h));
                Math3D.transform((IVector2f)v, (IMatrix3f)t, (Vector2f)v);
                vertices[4] = v.getX();
                vertices[5] = v.getY();
                v.set((float)(i_x + i_w), (float)i_y);
                Math3D.transform((IVector2f)v, (IMatrix3f)t, (Vector2f)v);
                vertices[6] = v.getX();
                vertices[7] = v.getY();
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{v});
                throw throwable;
            }
            Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{v});
        } else {
            vertices[0] = i_x;
            vertices[1] = i_y;
            vertices[2] = i_x;
            vertices[3] = i_y + i_h;
            vertices[4] = i_x + i_w;
            vertices[5] = i_y + i_h;
            vertices[6] = i_x + i_h;
            vertices[7] = i_y;
        }
        return vertices;
    }

    public boolean isExpand() {
        return this.m_expand;
    }

    public String toString() {
        return "TextPrimitive [m_expand=" + this.m_expand + ", m_position=" + this.m_position + ", m_text=" + this.m_text + "]";
    }
}

