/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera;

import org.eclipse.draw3d.camera.AbstractCameraPosition;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.camera.ICameraPosition;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class CameraPosition
extends AbstractCameraPosition {
    protected Vector3fImpl position = new Vector3fImpl();
    protected Vector3fImpl viewDir = new Vector3fImpl();
    protected Vector3fImpl upVector = new Vector3fImpl();

    public CameraPosition() {
        this.position.set(0.0f, 0.0f, -1000.0f);
        this.viewDir.set(ICamera.VIEW_REF);
        this.upVector.set(ICamera.UP_REF);
    }

    public CameraPosition(ICameraPosition src) {
        this.setCameraPosition(src);
    }

    public void setCameraPosition(ICameraPosition cameraPos) {
        if (cameraPos == null) {
            throw new NullPointerException("cameraPos must not be null");
        }
        cameraPos.getPosition((Vector3f)this.position);
        cameraPos.getViewDirection((Vector3f)this.viewDir);
        cameraPos.getUpVector((Vector3f)this.upVector);
    }

    public IVector3f getPosition(Vector3f o_result) {
        if (o_result != null) {
            o_result.set((IVector3f)this.position);
        }
        return this.position;
    }

    public void setPosition(IVector3f i_position) {
        this.position.set(i_position);
    }

    public IVector3f getViewDirection(Vector3f o_result) {
        if (o_result != null) {
            o_result.set((IVector3f)this.viewDir);
        }
        return this.viewDir;
    }

    public void setViewDirection(IVector3f i_viewDir) {
        Math3D.normalise((IVector3f)i_viewDir, (Vector3f)this.viewDir);
    }

    public IVector3f getUpVector(Vector3f o_result) {
        if (o_result != null) {
            o_result.set((IVector3f)this.upVector);
        }
        return this.upVector;
    }

    public void setUpVector(IVector3f i_upVector) {
        Math3D.normalise((IVector3f)i_upVector, (Vector3f)this.upVector);
    }

    public IVector3f getRightVector(Vector3f o_result) {
        Vector3f rightVector = o_result;
        if (rightVector == null) {
            rightVector = new Vector3fImpl();
        }
        Math3D.cross((IVector3f)this.viewDir, (IVector3f)this.upVector, (Vector3f)rightVector);
        return rightVector;
    }

    public void lookAt(IVector3f i_to) {
        Math3D.sub((IVector3f)i_to, (IVector3f)this.position, (Vector3f)this.viewDir);
        Math3D.normalise((IVector3f)this.viewDir, (Vector3f)this.viewDir);
    }

    public void orbit(IVector3f i_center, float i_hAngle, float i_vAngle) {
        Matrix4f rot = Math3DCache.getMatrix4f();
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            rot.setIdentity();
            if (i_hAngle != 0.0f) {
                Math3D.rotate((float)i_hAngle, (IVector3f)this.upVector, (IMatrix4f)rot, (Matrix4f)rot);
            }
            if (i_vAngle != 0.0f) {
                Math3D.rotate((float)i_vAngle, (IVector3f)this.getRightVector(tmp), (IMatrix4f)rot, (Matrix4f)rot);
            }
            Math3D.sub((IVector3f)this.position, (IVector3f)i_center, (Vector3f)tmp);
            tmp.transform((IMatrix4f)rot);
            Math3D.add((IVector3f)tmp, (IVector3f)i_center, (Vector3f)this.position);
            this.viewDir.transform((IMatrix4f)rot);
            this.upVector.transform((IMatrix4f)rot);
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
    }
}

