/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.ShapeFigure3D;
import org.eclipse.draw3d.draw2dports.FreeformHelper;
import org.eclipse.draw3d.shapes.CuboidFigureShape;
import org.eclipse.draw3d.shapes.Shape;

public class FreeFormPanel3D
extends ShapeFigure3D
implements FreeformFigure {
    static final Logger log = Logger.getLogger(FreeFormPanel3D.class.getName());
    private final FreeformHelper freeformHelper = new FreeformHelper(this);
    private FreeformListener m_autosizeListener = new FreeformListener(){

        public void notifyFreeformExtentChanged() {
            Rectangle extent = FreeFormPanel3D.this.getFreeformExtent();
            log.info(extent.toString());
            FreeFormPanel3D.this.setBounds(extent);
        }
    };

    public FreeFormPanel3D() {
        this.addFreeformListener(this.m_autosizeListener);
    }

    public void add(IFigure i_figure, Object i_constraint, int i_index) {
        super.add(i_figure, i_constraint, i_index);
        this.freeformHelper.hookChild(i_figure);
    }

    public void addFreeformListener(FreeformListener i_listener) {
        this.addListener(FreeformListener.class, i_listener);
    }

    protected Shape createShape() {
        return new CuboidFigureShape(this);
    }

    public void fireExtentChanged() {
        Iterator iter = this.getListeners(FreeformListener.class);
        while (iter.hasNext()) {
            ((FreeformListener)iter.next()).notifyFreeformExtentChanged();
        }
    }

    public Rectangle getFreeformExtent() {
        return this.freeformHelper.getFreeformExtent();
    }

    protected void primTranslate(int i_dx, int i_dy) {
        this.bounds.translate(i_dx, i_dy);
    }

    public void remove(IFigure i_figure) {
        this.freeformHelper.unhookChild(i_figure);
        super.remove(i_figure);
    }

    public void removeFreeformListener(FreeformListener i_listener) {
        this.removeListener(FreeformListener.class, i_listener);
    }

    public void setFreeformBounds(Rectangle i_bounds) {
        this.freeformHelper.setFreeformBounds(this.bounds);
    }
}

