/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Logger;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.swt.opengl.GLCanvas;

public class DeferredUpdateManager3D
extends DeferredUpdateManager {
    private static Logger log = Logger.getLogger(DeferredUpdateManager3D.class.getName());
    protected GLCanvas canvas;
    protected IFigure3D root3D;

    public void dumpTree(IFigure fig, StringBuffer o_out, String level) {
        o_out.append("\n").append(level).append("+" + fig);
        String indentLevel = String.valueOf(level) + "  ";
        int i = 0;
        while (i < fig.getChildren().size()) {
            this.dumpTree((IFigure)fig.getChildren().get(i), o_out, indentLevel);
            ++i;
        }
    }

    public GLCanvas getCanvas() {
        return this.canvas;
    }

    protected void repairDamage() {
        if (this.root3D != null && this.canvas != null) {
            this.root3D.paint(null);
            this.repairDamageFinish();
        } else if (this.root3D == null && this.canvas == null) {
            log.warning("repairDamage called, but root figure and canvas are null");
        } else if (this.root3D == null) {
            log.warning("repairDamage called, but root figure is null");
        } else {
            log.warning("repairDamage called, but canvas is null. Hint: call LightweightSystem.setControl(..)");
        }
    }

    protected void repairDamageFinish() {
        if (this.canvas.isDisposed()) {
            return;
        }
        this.canvas.swapBuffers();
    }

    public void setCanvas(GLCanvas i_canvas) {
        this.canvas = i_canvas;
    }

    public void setRoot(IFigure i_figure) {
        this.root3D = (IFigure3D)i_figure;
        super.setRoot(i_figure);
    }
}

