/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate1DDiscrete;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.ListBase;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.util.RandomIterator;
import org.ascape.util.ResetableIterator;

public class Array1D
extends ListBase {
    private static final long serialVersionUID = 1L;
    private Node[] cells = new Node[10];
    private int[] order;

    public Array1D() {
        this.setGeometry(new Geometry(1, true));
    }

    public Array1D(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    @Override
    public void setGeometry(Geometry geometry) {
        super.setGeometry(geometry);
        if (geometry.getDimensionCount() != 1) {
            throw new RuntimeException("Tried to assign an inappropriate geometry.");
        }
    }

    @Override
    public void setExtent(int size) {
        this.setExtent(new Coordinate1DDiscrete(size));
    }

    @Override
    public void construct() {
        this.cells = new Node[((Coordinate1DDiscrete)this.extent).getValueAtDimension(1)];
        this.order = Array1D.createOrder(this.cells.length);
    }

    @Override
    public void populate() {
        int i = 0;
        while (i < this.cells.length) {
            this.cells[i] = (Node)this.getContext().getPrototype().clone();
            this.cells[i].setCoordinate(new Coordinate1DDiscrete(i));
            ++i;
        }
        this.collection = Arrays.asList(this.cells);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.order = Array1D.createOrder(this.cells.length);
    }

    public void randomizeCallingOrder() {
        this.order = Array1D.randomizeOrder(this.order, this.getRandom());
    }

    @Override
    public Iterator iterator() {
        return new Array1DIterator(null, null);
    }

    @Override
    public ResetableIterator safeIterator() {
        return new Array1DIterator(null, null);
    }

    @Override
    public ResetableIterator safeIterator(int start, int limit) {
        return new Array1DSubIterator(start, limit);
    }

    @Override
    public RandomIterator safeRandomIterator() {
        return new Array1DRandomIterator();
    }

    @Override
    public int getSize() {
        return ((Coordinate1DDiscrete)this.extent).getValueAtDimension(1);
    }

    @Override
    public Object get(int xPosition) {
        return this.cells[xPosition];
    }

    @Override
    public Location get(Coordinate coordinate) {
        return this.cells[((Coordinate1DDiscrete)coordinate).getValue()];
    }

    @Override
    public Location findRandom() {
        return this.cells[this.randomToLimit(this.cells.length)];
    }

    @Override
    public Coordinate findRandomCoordinate() {
        return new Coordinate1DDiscrete(this.findRandomIndex());
    }

    public int findRandomIndex() {
        return this.randomToLimit(this.cells.length);
    }

    @Override
    public List findWithinImpl(Coordinate origin, boolean includeSelf, double dist) {
        int distance = (int)dist;
        int xMid = ((Coordinate1DDiscrete)origin).getXValue();
        if (this.getGeometry().isPeriodic()) {
            int xMin = xMid - distance;
            int xMax = xMid + distance;
            if (distance * 2 + 1 > this.getSize()) {
                xMin = xMid - this.getSize() / 2;
                xMax = xMin < 1 ? xMin + this.getSize() - 1 : xMin - 1;
            }
            Node[] cellsNear = new Node[xMax - xMin + (includeSelf ? 1 : 0)];
            if (includeSelf) {
                if (xMin < 0) {
                    System.arraycopy(this.cells, this.getSize() + xMin, cellsNear, 0, -xMin);
                    System.arraycopy(this.cells, 0, cellsNear, -xMin, xMax + 1);
                } else if (xMax >= this.getSize()) {
                    System.arraycopy(this.cells, xMin, cellsNear, 0, this.getSize() - xMin);
                    System.arraycopy(this.cells, 0, cellsNear, this.getSize() - xMin, xMax - this.getSize() + 1);
                } else {
                    System.arraycopy(this.cells, xMin, cellsNear, 0, cellsNear.length);
                }
            } else if (xMin < 0) {
                System.arraycopy(this.cells, this.getSize() + xMin, cellsNear, 0, -xMin);
                System.arraycopy(this.cells, 0, cellsNear, -xMin, xMid);
                System.arraycopy(this.cells, xMid + 1, cellsNear, xMid - xMin, xMax - xMid);
            } else if (xMax >= this.getSize()) {
                System.arraycopy(this.cells, xMin, cellsNear, 0, xMid - xMin);
                System.arraycopy(this.cells, xMid + 1, cellsNear, xMid - xMin, this.getSize() - xMid - 1);
                System.arraycopy(this.cells, 0, cellsNear, cellsNear.length - (xMax - this.getSize() + 1), xMax - this.getSize() + 1);
            } else if (xMin != xMax) {
                System.arraycopy(this.cells, xMin, cellsNear, 0, xMid - xMin);
                System.arraycopy(this.cells, xMid + 1, cellsNear, xMid - xMin, xMax - xMid);
            }
            ArrayList<Node> found = new ArrayList<Node>();
            int i = 0;
            while (i < cellsNear.length) {
                found.add(cellsNear[i]);
                ++i;
            }
            return found;
        }
        int xMin = Math.max(0, xMid - distance);
        int xMax = Math.min(xMid + distance, this.getSize() - 1);
        Node[] cellsNear = new Node[xMax - xMin + (includeSelf ? 1 : 0)];
        if (includeSelf) {
            System.arraycopy(this.cells, xMin, cellsNear, 0, cellsNear.length);
        } else {
            System.arraycopy(this.cells, xMin, cellsNear, 0, xMid - xMin);
            System.arraycopy(this.cells, xMid + 1, cellsNear, xMid - xMin, xMax - xMid);
        }
        ArrayList<Node> found = new ArrayList<Node>();
        int i = 0;
        while (i < cellsNear.length) {
            found.add(cellsNear[i]);
            ++i;
        }
        return found;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isDeleteSweepNeeded() {
        return false;
    }

    @Override
    public boolean isCoordinateSweepNeeded() {
        return false;
    }

    @Override
    public Node[] getCells() {
        return this.cells;
    }

    public Location[] getLocations() {
        return this.cells;
    }

    private class Array1DIterator
    implements ResetableIterator {
        protected int i = 0;

        private Array1DIterator() {
        }

        @Override
        public void first() {
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < Array1D.this.cells.length;
        }

        public Object next() {
            return Array1D.this.cells[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove an object from a immutable space.");
        }

        /* synthetic */ Array1DIterator(Array1DIterator array1DIterator, Array1DIterator array1DIterator2) {
            this();
        }
    }

    private class Array1DRandomIterator
    extends Array1DIterator
    implements RandomIterator {
        private int[] iterOrder;

        public Array1DRandomIterator() {
            this.iterOrder = Array1D.createOrder(Array1D.this.getSize());
            this.randomize();
        }

        @Override
        public Object next() {
            return Array1D.this.cells[this.iterOrder[this.i++]];
        }

        @Override
        public void randomize() {
            this.first();
            this.iterOrder = Array1D.randomizeOrder(this.iterOrder, Array1D.this.getRandom());
        }
    }

    private class Array1DSubIterator
    extends Array1DIterator {
        int start;
        int limit;

        public Array1DSubIterator(int start, int limit) {
            this.start = start;
            this.limit = limit;
            this.first();
        }

        @Override
        public void first() {
            this.i = this.start;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.limit;
        }
    }
}

