/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.vis;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorIndex {
    private Display display;
    private Random colorStream;
    private Map<Object, Color> colorForObject = new HashMap<Object, Color>();
    private Map<RGB, Color> colorForRGB = new HashMap<RGB, Color>();

    public ColorIndex(Display display, long seed) {
        this.display = display;
        this.colorStream = new Random(seed);
    }

    public ColorIndex() {
        this(Display.getCurrent(), 123L);
    }

    public final Color getIndexedColor(RGB rgb) {
        Color color = this.colorForRGB.get(rgb);
        if (color == null) {
            color = new Color((Device)this.display, rgb);
            this.colorForRGB.put(rgb, color);
        }
        return color;
    }

    public final Color getColorFor(Object model, RGB proposed) {
        Color color = this.colorForObject.get(model);
        if (color == null) {
            color = new Color((Device)this.display, proposed);
            this.colorForObject.put(model, color);
        }
        return color;
    }

    public final Color getGeneratedColorFor(Object model, float sat, float brightness) {
        Color color = this.colorForObject.get(model);
        if (color == null) {
            RGB hsb = new RGB(this.colorStream.nextFloat() * 360.0f, sat, brightness);
            color = new Color((Device)this.display, hsb);
            this.colorForObject.put(model, color);
        }
        return color;
    }
}

