/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import org.eclipse.amp.agf.gef.DefaultFigureProvider;
import org.eclipse.amp.agf.gef.IFigureProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class Shapes {
    public static final Dimension SIZE_FULL = new Dimension(20, 20);
    public static final Dimension SIZE_INSET_1 = new Dimension(19, 19);
    public static IFigureProvider EMPTY_PROVIDER = new DefaultFigureProvider(){

        @Override
        public IFigure getFigure(Object object) {
            return new Figure();
        }
    };
    public static IFigureProvider OVAL_SHAPE_PROVIDER = new DefaultFigureProvider(){

        @Override
        public IFigure getFigure(Object object) {
            return Shapes.createOval();
        }
    };
    public static IFigureProvider RECTANGLE_SHAPE_PROVIDER = new DefaultFigureProvider(){

        @Override
        public IFigure getFigure(Object object) {
            return Shapes.createRectangle();
        }
    };
    public static IFigureProvider ROUNDED_RECTANGLE_SHAPE_PROVIDER = new DefaultFigureProvider(){

        @Override
        public IFigure getFigure(Object object) {
            return Shapes.createRoundedRectangle();
        }
    };
    public static Point UPPER_LEFT = new Point(2, 2);
    public static Point UPPER_RIGHT = new Point(12, 2);
    public static Point LOWER_LEFT = new Point(2, 12);
    public static Point LOWER_RIGHT = new Point(12, 12);

    private static void setupShared(Shape figure) {
        figure.setFill(true);
        figure.setOutline(true);
        figure.setLineWidth(1);
    }

    public static Shape createOval() {
        Ellipse figure = new Ellipse(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        Shapes.setupShared((Shape)figure);
        figure.setSize(SIZE_INSET_1);
        return figure;
    }

    public static Shape createRoundedRectangle() {
        RoundedRectangle figure = new RoundedRectangle(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        Shapes.setupShared((Shape)figure);
        figure.setSize(SIZE_FULL);
        return figure;
    }

    public static Shape createRectangle() {
        RectangleFigure figure = new RectangleFigure(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        Shapes.setupShared((Shape)figure);
        figure.setSize(SIZE_FULL);
        return figure;
    }

    public static Point getLocationFor(int i) {
        switch (i) {
            case 0: {
                return UPPER_LEFT;
            }
            case 1: {
                return UPPER_RIGHT;
            }
            case 2: {
                return LOWER_LEFT;
            }
            case 3: {
                return LOWER_RIGHT;
            }
        }
        return UPPER_LEFT;
    }

    public static Shape getMarkerShape(IFigure parent, int position) {
        Ellipse markerFigure;
        Assert.isNotNull((Object)parent, (String)"Marker parent cannot be null.");
        int i = parent.getChildren().size();
        while (i <= position) {
            markerFigure = new Ellipse();
            markerFigure.setFill(false);
            markerFigure.setOutline(false);
            parent.add((IFigure)markerFigure);
            parent.setConstraint((IFigure)markerFigure, (Object)Shapes.getLocationFor(i));
            markerFigure.setSize(new Dimension(6, 6));
            Shapes.setupShared((Shape)markerFigure);
            ++i;
        }
        markerFigure = (Shape)parent.getChildren().get(position);
        Assert.isNotNull((Object)markerFigure);
        return markerFigure;
    }
}

