/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.handles;

import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.ParaxialBoundingBoxImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.shapes.CuboidFigureShape;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef3d.handles.AbstractHandle3D;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CubeHandle
extends AbstractHandle3D {
    protected static final float DEFAULT_HANDLE_SIZE = 7.0f;
    private static final Logger log = Logger.getLogger(CubeHandle.class.getName());
    private CuboidFigureShape m_alphaCube = new CuboidFigureShape((IFigure3D)this, false);
    private CuboidFigureShape m_superCube = new CuboidFigureShape((IFigure3D)this, true);

    public CubeHandle() {
        this.init();
    }

    public CubeHandle(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
        this.init();
    }

    public CubeHandle(GraphicalEditPart owner, Locator loc, Cursor c) {
        super(owner, loc, c);
        this.init();
    }

    public void collectRenderFragments(RenderContext i_renderContext) {
        i_renderContext.addRenderFragment((RenderFragment)this.m_alphaCube);
        i_renderContext.addRenderFragment((RenderFragment)this.m_superCube);
    }

    @Override
    protected DragTracker createDragTracker() {
        return null;
    }

    public Color getBackgroundColor() {
        return this.isPrimary() ? ColorConstants.darkGray : ColorConstants.white;
    }

    public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        return this.m_alphaCube.getDistance(i_rayOrigin, i_rayDirection, i_context);
    }

    public Color getForegroundColor() {
        return this.isPrimary() ? ColorConstants.red : ColorConstants.black;
    }

    /*
     * Unable to fully structure code
     */
    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        block4: {
            result = o_result;
            if (o_result == null) {
                result = new ParaxialBoundingBoxImpl();
            }
            location = Draw3DCache.getVector3f();
            size = Draw3DCache.getVector3f();
            try {
                if (this.m_paraxialBounds != null) ** GOTO lbl18
                this.m_paraxialBounds = this.m_alphaCube.getParaxialBoundingBox(null);
                if (this.m_paraxialBounds != null) break block4;
            }
            catch (Throwable var5_6) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
                throw var5_6;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
            return null;
        }
        this.helper.unionWithChildParaxialBounds(this.m_paraxialBounds);
lbl18:
        // 2 sources

        this.m_paraxialBounds.getLocation(location);
        this.m_paraxialBounds.getSize(size);
        result.setLocation((IVector3f)location);
        result.setSize((IVector3f)size);
        var6_5 = result;
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
        return var6_5;
    }

    protected void init() {
        this.setPreferredSize3D((IVector3f)new Vector3fImpl(7.0f, 7.0f, 7.0f));
        this.setAlpha(40);
    }

    protected boolean isPrimary() {
        return this.getOwner().getSelected() == 2;
    }
}

