/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector4f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.geometry.Vector4f;

public class Vector4fImpl
implements Vector4f,
Serializable,
Cloneable {
    public float x;
    public float y;
    public float z;
    public float w;
    private static final long serialVersionUID = 1L;

    static Vector4fImpl cast(IVector4f i_sourceVector4f) {
        if (i_sourceVector4f instanceof Vector4fImpl) {
            return (Vector4fImpl)i_sourceVector4f;
        }
        return new Vector4fImpl(i_sourceVector4f);
    }

    public Vector4fImpl() {
    }

    public Vector4fImpl(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4fImpl(IVector4f i_sourceVector4f) {
        this(i_sourceVector4f.getX(), i_sourceVector4f.getY(), i_sourceVector4f.getZ(), i_sourceVector4f.getW());
    }

    public Vector4fImpl(FloatBuffer i_floatBuffer) {
        this(i_floatBuffer.get(), i_floatBuffer.get(), i_floatBuffer.get(), i_floatBuffer.get());
    }

    public Vector4fImpl(float[] i_arrayOfFloat) {
        this(i_arrayOfFloat[0], i_arrayOfFloat[1], i_arrayOfFloat[2], i_arrayOfFloat[3]);
    }

    public Vector4fImpl(float[] i_arrayOfFloat, int i_iOffset) {
        this(i_arrayOfFloat[i_iOffset++], i_arrayOfFloat[i_iOffset++], i_arrayOfFloat[i_iOffset++], i_arrayOfFloat[i_iOffset]);
    }

    public Object clone() throws CloneNotSupportedException {
        return new Vector4fImpl(this);
    }

    public String toString() {
        return String.format("(%s, %s, %s, %s)", String.valueOf(this.x), String.valueOf(this.y), String.valueOf(this.z), String.valueOf(this.w));
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }

    public void set(float i_x, float i_y, float i_z, float i_w) {
        this.x = i_x;
        this.y = i_y;
        this.z = i_z;
        this.w = i_w;
    }

    public void set(IVector4f i_sourceVector4f) {
        this.x = i_sourceVector4f.getX();
        this.y = i_sourceVector4f.getY();
        this.z = i_sourceVector4f.getZ();
        this.w = i_sourceVector4f.getW();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public void toBuffer(FloatBuffer o_floatBuffer) {
        o_floatBuffer.put(this.x);
        o_floatBuffer.put(this.y);
        o_floatBuffer.put(this.z);
        o_floatBuffer.put(this.w);
    }

    public void toArray(float[] o_arrayOfFloat) {
        o_arrayOfFloat[0] = this.x;
        o_arrayOfFloat[1] = this.y;
        o_arrayOfFloat[2] = this.z;
        o_arrayOfFloat[3] = this.w;
    }

    public void toArray(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.x;
        o_arrayOfFloat[i_iOffset++] = this.y;
        o_arrayOfFloat[i_iOffset++] = this.z;
        o_arrayOfFloat[i_iOffset] = this.w;
    }

    public boolean equals(IVector4f v) {
        if (v == this) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return this.x == v.getX() && this.y == v.getY() && this.z == v.getZ() && this.w == v.getW();
    }

    public boolean equals(IVector4f v, float epsilon) {
        if (v == this) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return Math.abs(this.x - v.getX()) <= epsilon && Math.abs(this.y - v.getY()) <= epsilon && Math.abs(this.z - v.getZ()) <= epsilon && Math.abs(this.w - v.getW()) <= epsilon;
    }

    public int hashCode() {
        float[] af = new float[3];
        this.toArray(af);
        return Arrays.hashCode(af);
    }

    public void translate(float i_dx, float i_dy, float i_dz) {
        Math3D.translate(this, i_dx, i_dy, i_dz, 0.0f, this);
    }

    public void scale(float i_factor) {
        Math3D.scale(i_factor, this, this);
    }

    public void transform(IMatrix4f i_transformationMatrix4f) {
        Math3D.transform(this, i_transformationMatrix4f, this);
    }

    public Vector3f toVector3f(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(this.x, this.y, this.z);
        result.scale(1.0f / this.w);
        return result;
    }
}

