/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer;

public class PrimitiveBounds {
    private float m_x;
    private float m_y;
    private float m_width;
    private float m_height;
    private float m_xPlusWidth;
    private float m_yPlusHeight;

    public PrimitiveBounds(float[] i_vertices) {
        if (i_vertices == null) {
            throw new NullPointerException("i_vertices must not be null");
        }
        if (i_vertices.length < 2) {
            throw new IllegalArgumentException("i_vertices must contain at least one vertex");
        }
        if (i_vertices.length % 2 != 0) {
            throw new IllegalArgumentException("i_vertices must contain an equal number of elements");
        }
        this.m_x = i_vertices[0];
        this.m_y = i_vertices[1];
        this.m_width = 0.0f;
        this.m_height = 0.0f;
        this.m_xPlusWidth = this.m_x;
        this.m_yPlusHeight = this.m_y;
        int i = 1;
        while (i < i_vertices.length / 2) {
            float x = i_vertices[2 * i];
            float y = i_vertices[2 * i + 1];
            if (x < this.m_x) {
                this.m_x = x;
                this.m_xPlusWidth = this.m_x + this.m_width;
            } else if (x > this.m_xPlusWidth) {
                this.m_width = x - this.m_x;
                this.m_xPlusWidth = this.m_x + this.m_width;
            }
            if (y < this.m_y) {
                this.m_y = y;
                this.m_yPlusHeight = y + this.m_height;
            } else if (y > this.m_yPlusHeight) {
                this.m_height = y - this.m_y;
                this.m_yPlusHeight = this.m_y + this.m_height;
            }
            ++i;
        }
    }

    public boolean contains(PrimitiveBounds i_bounds) {
        if (i_bounds == null) {
            throw new NullPointerException("i_bounds must not be null");
        }
        if (i_bounds.getX() <= this.m_x) {
            return false;
        }
        if (i_bounds.getXPlusWidth() >= this.getXPlusWidth()) {
            return false;
        }
        if (i_bounds.getY() <= this.m_y) {
            return false;
        }
        return !(i_bounds.getYPlusHeight() >= this.getYPlusHeight());
    }

    public float getHeight() {
        return this.m_height;
    }

    public float getWidth() {
        return this.m_width;
    }

    public float getX() {
        return this.m_x;
    }

    public float getXPlusWidth() {
        return this.m_xPlusWidth;
    }

    public float getY() {
        return this.m_y;
    }

    public float getYPlusHeight() {
        return this.m_yPlusHeight;
    }

    public boolean intersects(PrimitiveBounds i_bounds) {
        if (i_bounds == null) {
            throw new NullPointerException("i_bounds must not be null");
        }
        if (i_bounds.getX() > this.getXPlusWidth()) {
            return false;
        }
        if (i_bounds.getXPlusWidth() < this.m_x) {
            return false;
        }
        if (i_bounds.getY() > this.getYPlusHeight()) {
            return false;
        }
        return !(i_bounds.getYPlusHeight() < this.m_y);
    }

    public String toString() {
        return "PrimitiveBounds [m_x=" + this.m_x + ", m_y=" + this.m_y + ", m_width=" + this.m_width + ", m_height=" + this.m_height + "]";
    }
}

