/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.eclipse.draw3d.geometry.IMatrix2f;
import org.eclipse.draw3d.geometry.Matrix2f;

public class Matrix2fImpl
implements Matrix2f,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float a11;
    public float a12;
    public float a21;
    public float a22;

    static Matrix2fImpl cast(IMatrix2f i_sourceMatrix2f) {
        if (i_sourceMatrix2f instanceof Matrix2fImpl) {
            return (Matrix2fImpl)i_sourceMatrix2f;
        }
        return new Matrix2fImpl(i_sourceMatrix2f);
    }

    public Matrix2fImpl() {
        this.a11 = 1.0f;
        this.a22 = 1.0f;
    }

    public Matrix2fImpl(float a, float b, float c, float d, boolean i_bColumnMajor) {
        if (!i_bColumnMajor) {
            this.a11 = a;
            this.a12 = b;
            this.a21 = c;
            this.a22 = d;
        } else {
            this.a11 = a;
            this.a21 = b;
            this.a12 = c;
            this.a22 = d;
        }
    }

    public Matrix2fImpl(float a11, float a12, float a21, float a22) {
        this.a11 = a11;
        this.a12 = a12;
        this.a21 = a21;
        this.a22 = a22;
    }

    public Matrix2fImpl(float[] i_floats, boolean i_bColumnMajor) {
        if (!i_bColumnMajor) {
            this.a11 = i_floats[0];
            this.a12 = i_floats[1];
            this.a21 = i_floats[2];
            this.a22 = i_floats[3];
        } else {
            this.a11 = i_floats[0];
            this.a21 = i_floats[1];
            this.a12 = i_floats[2];
            this.a22 = i_floats[3];
        }
    }

    public Matrix2fImpl(float[] i_floats, boolean i_bColumnMajor, int i_iOffset) {
        if (!i_bColumnMajor) {
            this.a11 = i_floats[i_iOffset++];
            this.a12 = i_floats[i_iOffset++];
            this.a21 = i_floats[i_iOffset++];
            this.a22 = i_floats[i_iOffset];
        } else {
            this.a11 = i_floats[i_iOffset++];
            this.a21 = i_floats[i_iOffset++];
            this.a12 = i_floats[i_iOffset++];
            this.a22 = i_floats[i_iOffset];
        }
    }

    public Matrix2fImpl(FloatBuffer i_buffer, boolean i_bColumnMajor) {
        if (!i_bColumnMajor) {
            this.setRowMajor(i_buffer);
        } else {
            this.setColumnMajor(i_buffer);
        }
    }

    public Matrix2fImpl(IMatrix2f src) {
        this.set(src);
    }

    public Matrix2fImpl(Matrix2fImpl src) {
        this.a11 = src.a11;
        this.a12 = src.a12;
        this.a21 = src.a21;
        this.a22 = src.a22;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Matrix2fImpl(this);
    }

    public boolean equals(IMatrix2f i_anotherMatrix2f) {
        if (this == i_anotherMatrix2f) {
            return true;
        }
        if (i_anotherMatrix2f == null) {
            return false;
        }
        Matrix2fImpl sm = Matrix2fImpl.cast(i_anotherMatrix2f);
        return this.a11 == sm.a11 && this.a12 == sm.a12 && this.a21 == sm.a21 && this.a22 == sm.a22;
    }

    public float get(int i_row, int i_column) {
        if (i_row < 0 || i_row >= 2) {
            throw new IllegalArgumentException("row index out of bounds: " + i_row);
        }
        if (i_column < 0 || i_column >= 2) {
            throw new IllegalArgumentException("column index out of bounds: " + i_column);
        }
        if (i_row == 0) {
            if (i_column == 0) {
                return this.a11;
            }
            return this.a12;
        }
        if (i_column == 0) {
            return this.a21;
        }
        return this.a22;
    }

    public int hashCode() {
        float[] af = new float[9];
        this.toArrayRowMajor(af);
        return Arrays.hashCode(af);
    }

    public void set(IMatrix2f i_sourceMatrix2f) {
        Matrix2fImpl sm = Matrix2fImpl.cast(i_sourceMatrix2f);
        this.a11 = sm.a11;
        this.a12 = sm.a12;
        this.a21 = sm.a21;
        this.a22 = sm.a22;
    }

    public void set(int i_row, int i_column, float i_value) {
        if (i_row < 0 || i_row >= 2) {
            throw new IllegalArgumentException("row index out of bounds: " + i_row);
        }
        if (i_column < 0 || i_column >= 2) {
            throw new IllegalArgumentException("column index out of bounds: " + i_column);
        }
        if (i_row == 0) {
            if (i_column == 0) {
                this.a11 = i_value;
            } else {
                this.a12 = i_value;
            }
        } else if (i_column == 0) {
            this.a21 = i_value;
        } else {
            this.a22 = i_value;
        }
    }

    public void setColumnMajor(float[] i_arrayOfFloat) {
        this.a11 = i_arrayOfFloat[0];
        this.a21 = i_arrayOfFloat[1];
        this.a12 = i_arrayOfFloat[2];
        this.a22 = i_arrayOfFloat[3];
    }

    public void setColumnMajor(FloatBuffer i_floatBuffer) {
        this.a11 = i_floatBuffer.get();
        this.a21 = i_floatBuffer.get();
        this.a12 = i_floatBuffer.get();
        this.a22 = i_floatBuffer.get();
    }

    public void setIdentity() {
        this.a11 = 1.0f;
        this.a12 = 0.0f;
        this.a21 = 0.0f;
        this.a22 = 1.0f;
    }

    public void setRowMajor(float[] i_arrayOfFloat) {
        this.a11 = i_arrayOfFloat[0];
        this.a12 = i_arrayOfFloat[1];
        this.a21 = i_arrayOfFloat[2];
        this.a22 = i_arrayOfFloat[3];
    }

    public void setRowMajor(FloatBuffer i_floatBuffer) {
        this.a11 = i_floatBuffer.get();
        this.a12 = i_floatBuffer.get();
        this.a21 = i_floatBuffer.get();
        this.a22 = i_floatBuffer.get();
    }

    public void setZero() {
        this.a11 = 0.0f;
        this.a12 = 0.0f;
        this.a21 = 0.0f;
        this.a22 = 0.0f;
    }

    public int size() {
        return 4;
    }

    public void toArrayColumnMajor(float[] o_arrayOfFloat) {
        o_arrayOfFloat[0] = this.a11;
        o_arrayOfFloat[1] = this.a21;
        o_arrayOfFloat[2] = this.a12;
        o_arrayOfFloat[3] = this.a22;
    }

    public void toArrayColumnMajor(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.a11;
        o_arrayOfFloat[i_iOffset++] = this.a21;
        o_arrayOfFloat[i_iOffset++] = this.a12;
        o_arrayOfFloat[i_iOffset] = this.a22;
    }

    public void toArrayRowMajor(float[] o_arrayOfFloat) {
        o_arrayOfFloat[0] = this.a11;
        o_arrayOfFloat[1] = this.a12;
        o_arrayOfFloat[2] = this.a21;
        o_arrayOfFloat[3] = this.a22;
    }

    public void toArrayRowMajor(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.a11;
        o_arrayOfFloat[i_iOffset++] = this.a12;
        o_arrayOfFloat[i_iOffset++] = this.a21;
        o_arrayOfFloat[i_iOffset] = this.a22;
    }

    public void toBufferColumnMajor(FloatBuffer o_buffer) {
        o_buffer.put(this.a11);
        o_buffer.put(this.a21);
        o_buffer.put(this.a12);
        o_buffer.put(this.a22);
    }

    public void toBufferRowMajor(FloatBuffer o_buffer) {
        o_buffer.put(this.a11);
        o_buffer.put(this.a12);
        o_buffer.put(this.a21);
        o_buffer.put(this.a22);
    }

    public String toString() {
        return String.format("%n(%s, %s, %n %s, %s)%n", String.valueOf(this.a11), String.valueOf(this.a12), String.valueOf(this.a21), String.valueOf(this.a22));
    }
}

