/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.preferences;

import org.eclipse.draw3d.ui.camera.CameraInputHandler;
import org.eclipse.draw3d.ui.preferences.Draw3DPreferenceDistributor;
import org.eclipse.draw3d.ui.preferences.PrefNames;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CameraPreferenceDistributor
extends Draw3DPreferenceDistributor
implements PrefNames {
    private CameraInputHandler m_handler;

    public CameraPreferenceDistributor(CameraInputHandler i_handler) {
        this.m_handler = i_handler;
    }

    private KeySequence getSequence(String i_string) {
        try {
            return KeySequence.getInstance((String)i_string);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Error while updating from preferences", ex);
        }
    }

    public void init(IPreferenceStore i_store) {
        this.m_handler.setMoveForwardKey(this.getSequence(i_store.getString("moveForwardKey")));
        this.m_handler.setMoveBackwardKey(this.getSequence(i_store.getString("moveBackwardKey")));
        this.m_handler.setMoveUpKey(this.getSequence(i_store.getString("upKey")));
        this.m_handler.setMoveDownKey(this.getSequence(i_store.getString("downKey")));
        this.m_handler.setMoveLeftKey(this.getSequence(i_store.getString("leftKey")));
        this.m_handler.setMoveRightKey(this.getSequence(i_store.getString("rightKey")));
        this.m_handler.setRollCCWKey(this.getSequence(i_store.getString("rollLeftKey")));
        this.m_handler.setRollCWKey(this.getSequence(i_store.getString("rollRightKey")));
        this.m_handler.setCenterKey(this.getSequence(i_store.getString("centerKey")));
        this.m_handler.setOrbitModifiers(i_store.getInt("cameraOrbitMode"));
        this.m_handler.setSensitivity(i_store.getInt("mouseSensitivity"));
    }

    public void propertyChange(PropertyChangeEvent i_event) {
        String name = i_event.getProperty();
        String newValue = i_event.getNewValue().toString();
        if (name == null || newValue == null) {
            return;
        }
        if (newValue.equals(i_event.getOldValue())) {
            return;
        }
        if (name.equals("moveForwardKey")) {
            this.m_handler.setMoveForwardKey(this.getSequence(newValue));
        } else if (name.equals("moveBackwardKey")) {
            this.m_handler.setMoveBackwardKey(this.getSequence(newValue));
        } else if (name.equals("upKey")) {
            this.m_handler.setMoveUpKey(this.getSequence(newValue));
        } else if (name.equals("downKey")) {
            this.m_handler.setMoveDownKey(this.getSequence(newValue));
        } else if (name.equals("leftKey")) {
            this.m_handler.setMoveLeftKey(this.getSequence(newValue));
        } else if (name.equals("rightKey")) {
            this.m_handler.setMoveRightKey(this.getSequence(newValue));
        } else if (name.equals("rollLeftKey")) {
            this.m_handler.setRollCCWKey(this.getSequence(newValue));
        } else if (name.equals("rollRightKey")) {
            this.m_handler.setRollCWKey(this.getSequence(newValue));
        } else if (name.equals("centerKey")) {
            this.m_handler.setCenterKey(this.getSequence(newValue));
        } else if (name.equals("cameraOrbitMode")) {
            this.m_handler.setOrbitModifiers(StringConverter.asInt((String)newValue));
        } else if (name.equals("mouseSensitivity")) {
            this.m_handler.setSensitivity(StringConverter.asInt((String)newValue));
        }
    }
}

