/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractFileWizard
extends Wizard
implements INewWizard {
    private WizardNewFileCreationPage page;
    private ISelection selection;
    private String fileTypeName;
    private String fileExtension;

    public AbstractFileWizard(String fileTypeName, String fileExtension, String fileDescription) {
        this.fileTypeName = fileTypeName;
        this.fileExtension = fileExtension;
        this.setNeedsProgressMonitor(false);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void addPages() {
        if (!(this.selection instanceof IStructuredSelection)) {
            this.selection = new StructuredSelection();
        }
        this.page = new WizardNewFileCreationPage("New " + this.fileTypeName + " File", (IStructuredSelection)this.selection){

            protected InputStream getInitialContents() {
                return new ByteArrayInputStream(new byte[0]);
            }

            public IWizardPage getPreviousPage() {
                this.validatePage();
                return super.getPreviousPage();
            }
        };
        this.page.setFileName("MyParameters." + this.getFileExtension());
        this.page.setTitle("Create " + this.fileTypeName + " File");
        this.page.setDescription("This wizard creates a new file with *." + this.getFileExtension() + " extension that can be opened by the " + this.fileTypeName + " editor.");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        boolean retValue = false;
        IFile f = this.page.createNewFile();
        if (f != null && f.exists()) {
            this.doOpenFile(f);
            retValue = true;
        }
        return retValue;
    }

    private void doOpenFile(final IFile f) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)f, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

