/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf;

import org.eclipse.amp.agf.GenericGraphicsProvider;
import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.gef.IFigureProvider;
import org.eclipse.amp.agf.gef.Shapes;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;

public class GraphicsAdapter
implements IGraphicsAdapter {
    private static IGraphicsAdapter singleton;
    public static Class[] GRAPHICS_ADAPTERS;
    public static final IColorProvider[] DEFAULT_COLOR_PROVIDERS;
    public static final ILabelProvider[] DEFAULT_LABEL_PROVIDERS;
    public static final IFigureProvider[] EMPTY_FIGURE_PROVIDERS;
    private static final IFigureProvider[] DEFAULT_FIGURE_PROVIDERS;

    static {
        GRAPHICS_ADAPTERS = new Class[]{IFigureProvider.class, IColorProvider.class, ILabelProvider.class};
        DEFAULT_COLOR_PROVIDERS = new IColorProvider[]{GenericGraphicsProvider.getDefault()};
        DEFAULT_LABEL_PROVIDERS = new ILabelProvider[]{GenericGraphicsProvider.getDefault()};
        EMPTY_FIGURE_PROVIDERS = new IFigureProvider[0];
        DEFAULT_FIGURE_PROVIDERS = new IFigureProvider[]{Shapes.RECTANGLE_SHAPE_PROVIDER};
    }

    @Override
    public IColorProvider[] getColors(Object object) {
        return this.getColorsForClass(object.getClass());
    }

    @Override
    public IFigureProvider[] getFigures(Object object) {
        return this.getFiguresForClass(object.getClass());
    }

    @Override
    public ILabelProvider[] getLabels(Object object) {
        return this.getLabelsForClass(object.getClass());
    }

    @Override
    public IColorProvider[] getColorsForClass(Class type) {
        return DEFAULT_COLOR_PROVIDERS;
    }

    @Override
    public IFigureProvider[] getFiguresForClass(Class type) {
        return DEFAULT_FIGURE_PROVIDERS;
    }

    @Override
    public ILabelProvider[] getLabelsForClass(Class type) {
        return DEFAULT_LABEL_PROVIDERS;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IColorProvider[] colorProviders;
        ILabelProvider[] labelProviders;
        if (adaptableObject instanceof IModel) {
            return Platform.getAdapterManager().getAdapter(((IModel)adaptableObject).getRoot(), adapterType);
        }
        if (adapterType == IFigureProvider.class) {
            IFigureProvider[] figureProviders = this.getFigures(adaptableObject);
            if (figureProviders != null && figureProviders.length > 0) {
                return figureProviders[0];
            }
            if (figureProviders != null) {
                return null;
            }
        }
        if (adapterType == ILabelProvider.class && (labelProviders = this.getLabels(adaptableObject)) != null && labelProviders.length > 0) {
            return labelProviders[0];
        }
        if (adapterType == IColorProvider.class && (colorProviders = this.getColors(adaptableObject)) != null && colorProviders.length > 0) {
            return colorProviders[0];
        }
        return Platform.getAdapterManager().getAdapter(adaptableObject, adapterType);
    }

    public Class[] getAdapterList() {
        return GRAPHICS_ADAPTERS;
    }

    public static IGraphicsAdapter getDefault() {
        if (singleton == null) {
            singleton = new GraphicsAdapter();
        }
        return singleton;
    }
}

