/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.io.Serializable;
import java.util.Arrays;
import org.ascape.model.space.Coordinate;

public abstract class CoordinateDiscrete
extends Coordinate
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int[] values;

    public CoordinateDiscrete() {
    }

    public CoordinateDiscrete(int[] values) {
        this.values = values;
    }

    public CoordinateDiscrete(int value) {
        this.values = new int[1];
        this.values[0] = value;
    }

    public int getDimensionCount() {
        return this.values.length;
    }

    public final int[] getValues() {
        return this.values;
    }

    public final void setValues(int[] values) {
        this.values = values;
    }

    public final int getValueAtDimension(int dimension) {
        return this.values[dimension - 1];
    }

    public final void setValueAtDimension(int dimension, int value) {
        this.values[dimension - 1] = value;
    }

    public final int getProduct() {
        int size = this.values[0];
        int i = 1;
        while (i < this.values.length) {
            size *= this.values[i];
            ++i;
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CoordinateDiscrete)) {
            return false;
        }
        CoordinateDiscrete coordinateDiscrete = (CoordinateDiscrete)o;
        return Arrays.equals(this.values, coordinateDiscrete.values);
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.values.length) {
            hash ^= this.values[i];
            hash <<= 2;
            ++i;
        }
        return hash;
    }

    public String toString() {
        String desc = "Coordinate with values: [";
        int i = 0;
        while (i < this.values.length) {
            desc = String.valueOf(desc) + this.values[i];
            if (i < this.values.length - 1) {
                desc = String.valueOf(desc) + ", ";
            }
            ++i;
        }
        desc = String.valueOf(desc) + this.values.length + "-dimensional geometry.";
        return desc;
    }
}

