/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import java.util.LinkedList;
import java.util.List;
import org.ascape.model.Agent;
import org.ascape.model.Cell;
import org.ascape.model.CellOccupant;
import org.ascape.model.LocatedAgent;
import org.ascape.model.space.Array2DBase;
import org.ascape.model.space.Coordinate2DDiscrete;
import org.ascape.util.vis.ColorFeature;
import org.ascape.util.vis.DrawFeature;
import org.ascape.view.vis.HostedAgentView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;

public class Overhead2DView
extends HostedAgentView {
    private static final long serialVersionUID = 4333847136610603354L;
    protected boolean drawSelectedNeighbors = false;
    private boolean drawFarNeighbors = false;
    private boolean drawNetwork = false;
    private boolean drawByFeature = false;
    Object[] drawFeatures;

    public Overhead2DView() {
        this("Overhead 2D View");
    }

    public Overhead2DView(String name) {
        super(name);
    }

    protected void drawCellAtIfUpdate(Graphics graphics, int x, int y) {
        Cell cell = (Cell)((Array2DBase)this.getScape().getSpace()).get(x, y);
        if (cell.isUpdateNeeded(this.getScape().getIterationsPerRedraw())) {
            Object[] objectArray = this.drawFeatures;
            int n = this.drawFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                Object drawFeature = objectArray[n2];
                ((DrawFeature)drawFeature).draw(graphics, cell, this.agentSize, this.agentSize);
                ++n2;
            }
        }
    }

    protected void drawCellAt(Graphics graphics, int x, int y) {
        Object[] objectArray = this.drawFeatures;
        int n = this.drawFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            Object drawFeature = objectArray[n2];
            ((DrawFeature)drawFeature).draw(graphics, ((Array2DBase)this.getScape().getSpace()).get(x, y), this.agentSize, this.agentSize);
            ++n2;
        }
    }

    protected void drawCellAtIfUpdate(Graphics graphics, int x, int y, DrawFeature feature) {
        Cell cell = (Cell)((Array2DBase)this.getScape().getSpace()).get(x, y);
        if (cell.isUpdateNeeded(this.getScape().getIterationsPerRedraw())) {
            feature.draw(graphics, cell, this.agentSize, this.agentSize);
        }
    }

    protected void drawCellAt(Graphics graphics, int x, int y, DrawFeature feature) {
        feature.draw(graphics, ((Array2DBase)this.getScape().getSpace()).get(x, y), this.agentSize, this.agentSize);
    }

    @Override
    public Agent getAgentAtPixel(int x, int y) {
        int td = this.agentSize + this.borderSize;
        if (x == this.getSize().width - 1) {
            this.getAgentAtPixel(--x, y);
        }
        if (y == this.getSize().width - 1) {
            this.getAgentAtPixel(x, --y);
        }
        return (Cell)((Array2DBase)this.getScape().getSpace()).get(x / td, y / td);
    }

    protected void drawNeighborsFor(Graphics g, LocatedAgent agent) {
        int td = this.agentSize + this.borderSize;
        g.setForegroundColor(ColorFeature.BLACK);
        LinkedList neighbors = new LinkedList(((Cell)agent).findNeighbors());
        neighbors.removeAll(agent.findWithin(1.0));
        int i = 0;
        while (i < neighbors.size()) {
            if (((Cell)neighbors.get(i)).getCoordinate() != null) {
                int dx = ((Coordinate2DDiscrete)((Cell)neighbors.get(i)).getCoordinate()).getXValue() - ((Coordinate2DDiscrete)agent.getCoordinate()).getXValue();
                int dy = ((Coordinate2DDiscrete)((Cell)neighbors.get(i)).getCoordinate()).getYValue() - ((Coordinate2DDiscrete)agent.getCoordinate()).getYValue();
                g.drawLine(td / 2 - 1, td / 2 - 1, dx * td + td / 2 - 1, dy * td + td / 2 - 1);
            }
            ++i;
        }
    }

    protected synchronized void drawSelectedAgentAt(Graphics g, LocatedAgent a) {
    }

    @Override
    public synchronized void drawSelectedAgent(Graphics graphics, LocatedAgent a) {
        Coordinate2DDiscrete coor = (Coordinate2DDiscrete)a.getCoordinate();
        int x = coor.getXValue();
        int y = coor.getYValue();
        int td = this.agentSize + this.borderSize;
        graphics.translate(x * td, y * td);
        this.drawSelectedAgentAt(graphics, a);
        graphics.translate(-x * td, -y * td);
        if (this.getScape().isCellsRequestUpdates()) {
            int xmin = x - 1 < 0 ? (x = 0) : x - 1;
            int xmax = x + 1 < ((Array2DBase)this.getScape().getSpace()).getXSize() ? x + 1 : x;
            int ymin = y - 1 < 0 ? (y = 0) : y - 1;
            int ymax = y + 1 < ((Array2DBase)this.getScape().getSpace()).getXSize() ? y + 1 : y;
            int i = xmin;
            while (i <= xmax) {
                int j = ymin;
                while (j <= ymax) {
                    ((Cell)((Array2DBase)this.getScape().getSpace()).get(i, j)).requestUpdateNext();
                    ++j;
                }
                ++i;
            }
        }
        graphics.dispose();
    }

    public void updateScapeGraphics(Graphics graphics) {
        int y;
        super.updateScapeGraphics(graphics);
        Coordinate2DDiscrete extent = (Coordinate2DDiscrete)this.getScape().getExtent();
        this.drawFeatures = this.getDrawSelection().getSelection();
        int td = this.agentSize + this.borderSize;
        if (!this.drawByFeature) {
            int x;
            if (this.getScape().isCellsRequestUpdates() && !this.getScape().isUpdateNeeded(this.getScape().getIterationsPerRedraw()) && !this.drawNetwork && !this.drawFarNeighbors) {
                x = 0;
                while (x < extent.getXValue()) {
                    y = 0;
                    while (y < extent.getYValue()) {
                        this.drawCellAtIfUpdate(graphics, x, y);
                        graphics.translate(0, td);
                        ++y;
                    }
                    graphics.translate(td, -extent.getYValue() * td);
                    ++x;
                }
            } else {
                x = 0;
                while (x < extent.getXValue()) {
                    y = 0;
                    while (y < extent.getYValue()) {
                        this.drawCellAt(graphics, x, y);
                        graphics.translate(0, td);
                        ++y;
                    }
                    graphics.translate(td, -extent.getYValue() * td);
                    ++x;
                }
            }
            graphics.translate(-extent.getXValue() * td, 0);
        } else {
            Object[] objectArray = this.drawFeatures;
            int n = this.drawFeatures.length;
            y = 0;
            while (y < n) {
                int y2;
                int x;
                Object drawFeature = objectArray[y];
                if (this.getScape().isCellsRequestUpdates() && !this.getScape().isUpdateNeeded(this.getScape().getIterationsPerRedraw()) && !this.drawNetwork) {
                    x = 0;
                    while (x < extent.getXValue()) {
                        y2 = 0;
                        while (y2 < extent.getYValue()) {
                            this.drawCellAtIfUpdate(graphics, x, y2, (DrawFeature)drawFeature);
                            graphics.translate(0, td);
                            ++y2;
                        }
                        graphics.translate(td, -extent.getYValue() * td);
                        ++x;
                    }
                } else {
                    x = 0;
                    while (x < extent.getXValue()) {
                        y2 = 0;
                        while (y2 < extent.getYValue()) {
                            this.drawCellAt(graphics, x, y2, (DrawFeature)drawFeature);
                            graphics.translate(0, td);
                            ++y2;
                        }
                        graphics.translate(td, -extent.getYValue() * td);
                        ++x;
                    }
                }
                graphics.translate(-extent.getXValue() * td, 0);
                ++y;
            }
        }
        if (this.drawNetwork) {
            int x = 0;
            while (x < extent.getXValue()) {
                y = 0;
                while (y < extent.getYValue()) {
                    Cell cell = (Cell)((Array2DBase)this.getScape().getSpace()).get(x, y);
                    CellOccupant occupant = (CellOccupant)cell.getOccupant();
                    if (occupant != null) {
                        List network = occupant.getNetwork();
                        graphics.setForegroundColor(ColorFeature.DARK_GRAY);
                        for (Cell target : network) {
                            int x2 = ((Coordinate2DDiscrete)target.getCoordinate()).getXValue();
                            int y2 = ((Coordinate2DDiscrete)target.getCoordinate()).getYValue();
                            graphics.drawLine(x * this.agentSize + this.agentSize / 2 - 1, y * this.agentSize + this.agentSize / 2 - 1, x2 * this.agentSize + this.agentSize / 2 - 1, y2 * this.agentSize + this.agentSize / 2 - 1);
                        }
                    }
                    ++y;
                }
                ++x;
            }
        }
        if (this.drawFarNeighbors) {
            graphics.setForegroundColor(ColorFeature.DARK_YELLOW);
            int x = 0;
            while (x < extent.getXValue()) {
                y = 0;
                while (y < extent.getYValue()) {
                    this.drawNeighborsFor(graphics, (LocatedAgent)((Cell)((Array2DBase)this.getScape().getSpace()).get(x, y)));
                    graphics.translate(0, td);
                    ++y;
                }
                graphics.translate(td, -extent.getYValue() * td);
                ++x;
            }
            graphics.translate(-extent.getXValue() * td, 0);
        }
        this.drawSelectedAgents();
    }

    private void drawSelectedAgents() {
    }

    @Override
    public Dimension calculateViewSizeForAgentSize(Dimension availableSize, int cellSize) {
        return new Dimension(((Coordinate2DDiscrete)this.getScape().getExtent()).getXValue() * (cellSize + this.borderSize) + this.borderSize, ((Coordinate2DDiscrete)this.getScape().getExtent()).getYValue() * (cellSize + this.borderSize) + this.borderSize);
    }

    @Override
    public int calculateAgentSizeForViewSize(Dimension d) {
        int width = (d.width - this.borderSize) / ((Array2DBase)this.getScape().getSpace()).getXSize() - this.borderSize;
        int height = (d.height - this.borderSize) / ((Array2DBase)this.getScape().getSpace()).getYSize() - this.borderSize;
        return Math.max(1, Math.min(width, height));
    }

    public boolean isDrawByFeature() {
        return this.drawByFeature;
    }

    public void setDrawByFeature(boolean drawByFeature) {
        this.drawByFeature = drawByFeature;
    }

    public boolean isDrawNetwork() {
        return this.drawNetwork;
    }

    public boolean isDrawSelectedNeighbors() {
        return this.drawSelectedNeighbors;
    }

    public boolean isDrawFarNeighbors() {
        return this.drawFarNeighbors;
    }

    public void setDrawNetwork(boolean drawNetwork) {
        this.drawNetwork = drawNetwork;
    }

    public void setDrawSelectedNeighbors(boolean drawSelectedNeighbors) {
        this.drawSelectedNeighbors = drawSelectedNeighbors;
    }

    public void setDrawFarNeighbors(boolean drawFarNeighbors) {
        this.drawFarNeighbors = drawFarNeighbors;
    }
}

