/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util.converter;

public class ConversionPolicySpecs {
    private int m_bufferDataType;
    private int m_bufferPixelFormat;
    private ConversionDirection m_direction;
    private int m_hashCode;
    private int m_imageDepth;

    public ConversionPolicySpecs(ConversionDirection i_direction, int i_bufferPixelFormat, int i_bufferDataType, int i_imageDepth) {
        if (i_direction == null) {
            throw new NullPointerException("i_direction must not be null");
        }
        this.m_direction = i_direction;
        this.m_bufferPixelFormat = i_bufferPixelFormat;
        this.m_bufferDataType = i_bufferDataType;
        this.m_imageDepth = i_imageDepth;
        this.m_hashCode = 17;
        this.m_hashCode = 37 * this.m_hashCode + this.m_direction.hashCode();
        this.m_hashCode = 37 * this.m_hashCode + this.m_bufferPixelFormat;
        this.m_hashCode = 37 * this.m_hashCode + this.m_bufferDataType;
        this.m_hashCode = 37 * this.m_hashCode + this.m_imageDepth;
    }

    public boolean equals(Object i_obj) {
        if (i_obj == null) {
            return false;
        }
        if (!(i_obj instanceof ConversionPolicySpecs)) {
            return false;
        }
        ConversionPolicySpecs other = (ConversionPolicySpecs)i_obj;
        if (this.m_direction != other.m_direction) {
            return false;
        }
        if (this.m_bufferPixelFormat != other.m_bufferPixelFormat) {
            return false;
        }
        return this.m_bufferDataType == other.m_bufferDataType;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("direction: ");
        builder.append((Object)this.m_direction);
        builder.append(", pixel format: ");
        builder.append(this.m_bufferPixelFormat);
        builder.append(", data type: ");
        builder.append(this.m_bufferDataType);
        builder.append(", image depth: ");
        builder.append(this.m_imageDepth);
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConversionDirection {
        BUFFER_TO_IMAGE,
        IMAGE_TO_BUFFER;

    }
}

