/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.sd.model;

import org.eclipse.amp.axf.sd.calculators.EulerIntegration;
import org.eclipse.amp.axf.sd.model.AbstractSDModel;
import org.eclipse.amp.axf.sd.model.result.SimResult;

public abstract class AbstractVariable {
    private static EulerIntegration integrationMethod = new EulerIntegration();
    private AbstractSDModel parent;
    private int currentTime;
    private SimResult simResult;

    public AbstractVariable() {
        this.startSimulation();
    }

    protected static EulerIntegration getIntegrationMethod() {
        return integrationMethod;
    }

    public void init(AbstractSDModel parentModel) {
        this.parent = parentModel;
    }

    public AbstractSDModel getParent() {
        return this.parent;
    }

    public final double calculate(int time) {
        int oldTime = this.currentTime;
        this.currentTime = time;
        double retValue = this.equation();
        if (this.simResult.getValue(time) == null) {
            this.simResult.put(time, retValue);
        }
        this.currentTime = oldTime;
        return retValue;
    }

    protected abstract double equation();

    public void startSimulation() {
        this.simResult = new SimResult();
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(int currentTime) {
        this.currentTime = currentTime;
    }

    public SimResult getSimResult() {
        return this.simResult;
    }
}

