/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.RenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.VertexPrimitive;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LineHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVBO;
import org.lwjgl.BufferUtils;

public abstract class LwjglVertexPrimitiveVBO
extends LwjglVBO {
    private LineHelper m_lineHelper;
    private PrimitiveSet m_primitives;
    private int m_vertexCount;

    protected int getVertexCount() {
        return this.m_vertexCount;
    }

    protected PrimitiveSet getPrimitives() {
        return this.m_primitives;
    }

    protected LwjglVertexPrimitiveVBO(PrimitiveSet i_primitives) {
        if (i_primitives == null) {
            throw new NullPointerException("i_primitives must not be null");
        }
        if (i_primitives.getSize() == 0) {
            throw new IllegalArgumentException(i_primitives + " must not be empty");
        }
        this.m_primitives = i_primitives;
        this.m_vertexCount = i_primitives.getVertexCount();
        RenderRule renderRule = i_primitives.getPrimitiveClass().getRenderRule();
        if (renderRule.isOutline()) {
            this.m_lineHelper = new LineHelper(renderRule.asOutline());
        }
    }

    protected void cleanup(Graphics3D i_g3d, ILodHelper i_lodContext) {
        if (this.m_lineHelper != null) {
            this.m_lineHelper.cleanup(i_g3d);
        }
    }

    protected abstract void doRender(Graphics3D var1, ILodHelper var2);

    protected Buffer getBuffer(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.VERTEX) {
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)(2 * this.m_primitives.getVertexCount()));
            for (Primitive primitive : this.m_primitives.getPrimitives()) {
                VertexPrimitive vertexPrimitive = (VertexPrimitive)primitive;
                float[] vertices = vertexPrimitive.getVertices();
                if (this.m_lineHelper != null && this.m_lineHelper.isTextured()) {
                    float lx = vertices[0];
                    float ly = vertices[1];
                    int i = 0;
                    while (i < vertexPrimitive.getVertexCount()) {
                        float x = vertices[2 * i];
                        float y = vertices[2 * i + 1];
                        buf.put(x);
                        buf.put(y);
                        this.m_lineHelper.addTextureCoordinate(lx, ly, x, y, buf);
                        lx = x;
                        ly = y;
                        ++i;
                    }
                    continue;
                }
                buf.put(vertices);
            }
            return buf;
        }
        return null;
    }

    protected LwjglVBO.BufferInfo getBufferInfo(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.VERTEX) {
            return new LwjglVBO.BufferInfo(5126, 35041, 2, 0, 0);
        }
        return null;
    }

    protected boolean hasBuffer(LwjglVBO.BufferType i_type) {
        return i_type == LwjglVBO.BufferType.VERTEX;
    }

    public void initialize(Graphics3D i_g3d) {
        super.initialize(i_g3d);
        if (this.m_lineHelper != null) {
            this.m_lineHelper.initialize(i_g3d);
        }
    }

    protected void prepare(Graphics3D i_g3d, ILodHelper i_lodContext) {
        if (this.m_lineHelper != null) {
            this.m_lineHelper.prepare(i_g3d);
        }
    }

    protected void stateChanged(LwjglVBO.State i_oldState, LwjglVBO.State i_newState) {
        super.stateChanged(i_oldState, i_newState);
        if (i_newState == LwjglVBO.State.READY) {
            this.m_primitives = null;
        }
    }
}

