/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.preferences.dialog;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BitFieldEditor
extends FieldEditor {
    private Button[] checkboxes;
    private Composite groupBox;
    private int indent = 8;
    private String[] labels;
    private int numColumns;
    private boolean useGroup;
    private int value;
    private int[] values;

    public BitFieldEditor(String i_name, String i_labelText, int i_numColumns, String[] i_labels, int[] i_values, Composite i_parent) {
        this(i_name, i_labelText, i_numColumns, i_labels, i_values, i_parent, false);
    }

    public BitFieldEditor(String i_name, String i_labelText, int i_numColumns, String[] i_labels, int[] i_values, Composite i_parent, boolean i_useGroup) {
        this.init(i_name, i_labelText);
        Assert.isTrue((i_labels.length == i_values.length ? 1 : 0) != 0);
        this.labels = i_labels;
        this.values = i_values;
        this.numColumns = i_numColumns;
        this.useGroup = i_useGroup;
        this.createControl(i_parent);
    }

    protected void adjustForNumColumns(int i_numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = this.numColumns;
        }
        ((GridData)this.groupBox.getLayoutData()).horizontalSpan = this.numColumns;
    }

    protected void doFillIntoGrid(Composite i_parent, int i_numColumns) {
        if (this.useGroup) {
            Control control = this.getGroupControl(i_parent);
            GridData gd = new GridData(768);
            control.setLayoutData((Object)gd);
        } else {
            Label control = this.getLabelControl(i_parent);
            GridData gd = new GridData();
            gd.horizontalSpan = i_numColumns;
            control.setLayoutData((Object)gd);
            control = this.getGroupControl(i_parent);
            gd = new GridData();
            gd.horizontalSpan = i_numColumns;
            gd.horizontalIndent = this.indent;
            control.setLayoutData((Object)gd);
        }
    }

    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getInt(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
    }

    private Control getGroupControl(Composite parent) {
        if (this.groupBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.groupBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.groupBox.setLayout((Layout)layout);
            } else {
                this.groupBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.groupBox.setLayout((Layout)layout);
                this.groupBox.setFont(font);
            }
            this.checkboxes = new Button[this.labels.length];
            int i = 0;
            while (i < this.labels.length) {
                Button checkbox;
                this.checkboxes[i] = checkbox = new Button(this.groupBox, 16416);
                checkbox.setText(this.labels[i]);
                checkbox.setData((Object)this.values[i]);
                checkbox.setFont(font);
                checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int oldValue = BitFieldEditor.this.value;
                        Button button = (Button)event.widget;
                        int bit = (Integer)button.getData();
                        if (button.getSelection()) {
                            BitFieldEditor bitFieldEditor = BitFieldEditor.this;
                            bitFieldEditor.value = bitFieldEditor.value | bit;
                        } else {
                            BitFieldEditor bitFieldEditor = BitFieldEditor.this;
                            bitFieldEditor.value = bitFieldEditor.value & ~bit;
                        }
                        BitFieldEditor.this.setPresentsDefaultValue(false);
                        BitFieldEditor.this.fireValueChanged("field_editor_value", oldValue, BitFieldEditor.this.value);
                    }
                });
                ++i;
            }
            this.groupBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BitFieldEditor.this.groupBox = null;
                    BitFieldEditor.this.checkboxes = null;
                }
            });
        } else {
            this.checkParent((Control)this.groupBox, parent);
        }
        return this.groupBox;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean i_enabled, Composite i_parent) {
        if (!this.useGroup) {
            super.setEnabled(i_enabled, i_parent);
        }
        int i = 0;
        while (i < this.checkboxes.length) {
            this.checkboxes[i].setEnabled(i_enabled);
            ++i;
        }
    }

    public void setIndent(int i_indent) {
        this.indent = i_indent < 0 ? 0 : i_indent;
    }

    public void updateValue(int i_newValue) {
        this.value = i_newValue;
        if (this.checkboxes == null) {
            return;
        }
        int i = 0;
        while (i < this.checkboxes.length) {
            Button checkbox;
            int data = (Integer)(checkbox = this.checkboxes[i]).getData();
            checkbox.setSelection((i_newValue & data) != 0);
            ++i;
        }
    }
}

