/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.tools;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.MouseEvent3D;
import org.eclipse.draw3d.PlaneSurface;
import org.eclipse.draw3d.ShapeFigure3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.shapes.CuboidFigureShape;
import org.eclipse.draw3d.shapes.Shape;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef3d.requests.ChangeBounds3DRequest;
import org.eclipse.gef3d.ui.parts.GraphicalViewer3DImpl;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DragEditPartsTracker3D
extends DragEditPartsTracker {
    private static final Logger log = Logger.getLogger(DragEditPartsTracker3D.class.getName());
    static final int MODIFIER_3DDRAG = "macosx".equals(Platform.getOS()) ? 0x400000 : 65536;
    public static float ROTATION_SENSITIVITY = 0.01f;
    public static float ROTATION_THRESHOLD = 20.0f;
    protected MouseEvent3D currentMouseEvent3D = null;
    protected IVector3f startWorldLocation = null;
    protected ISurface startSurface = null;
    protected Point startScreenLocation = null;
    protected PlaneSurface depthSurface;
    protected ShapeFigure3D debugDepthSurfaceFigure = new ShapeFigure3D(){

        protected Shape createShape() {
            return new CuboidFigureShape((IFigure3D)this, false);
        }
    };
    static final Point NO_DELTA = new Point(0, 0);
    static final Dimension NO_DELTA_SIZE = new Dimension(0, 0);

    public DragEditPartsTracker3D(EditPart i_sourceEditPart) {
        super(i_sourceEditPart);
        Color c = Display.getCurrent().getSystemColor(9);
        this.debugDepthSurfaceFigure.setForegroundColor(c);
        c = Display.getCurrent().getSystemColor(11);
        this.debugDepthSurfaceFigure.setBackgroundColor(c);
        this.debugDepthSurfaceFigure.setAlpha(119);
    }

    protected void popMouseEvent3D() {
        this.currentMouseEvent3D = null;
    }

    protected void pushMouseEvent3D(MouseEvent i_me) {
        this.currentMouseEvent3D = i_me instanceof MouseEvent3D ? (MouseEvent3D)i_me : null;
    }

    protected void setStartLocation(Point i_p) {
        if (log.isLoggable(Level.INFO)) {
            log.info("update drag start location");
        }
        if (this.currentMouseEvent3D != null) {
            GraphicalViewer3DImpl v;
            this.startSurface = this.currentMouseEvent3D.getSurface();
            this.startWorldLocation = this.currentMouseEvent3D.getWorldLocation();
            this.startScreenLocation = this.currentMouseEvent3D.getScreenLocation();
            Vector3f depthRotation = this.startSurface.getSurfaceRotation(null);
            Vector3fImpl b = new Vector3fImpl(0.0f, 0.0f, -1.0f);
            IVector3f no = this.startSurface.getNormal();
            Math3D.eulerAngles((IVector3f)no, (IVector3f)b, (Vector3f)depthRotation);
            depthRotation.setX((float)((double)depthRotation.getX() - 1.5707963267948966));
            if (Math3D.equals((IVector3f)depthRotation, (IVector3f)IVector3f.NULLVEC3f, (float)0.001f)) {
                depthRotation.setX(1.5707964f);
            }
            this.depthSurface = new PlaneSurface();
            this.depthSurface.getPosition3D().setLocation3D(this.startWorldLocation);
            this.depthSurface.getPosition3D().setRotation3D((IVector3f)depthRotation);
            this.depthSurface.getPosition3D().setSize3D((IVector3f)new Vector3fImpl(20.0f, 40.0f, 5.0f));
            if (this.getCurrentViewer() instanceof GraphicalViewer3DImpl && (v = (GraphicalViewer3DImpl)this.getCurrentViewer()).getLightweightSystem3D().isDebug()) {
                this.debugDepthSurfaceFigure.getPosition3D().setPosition((IPosition3D)this.depthSurface.getPosition3D());
                this.debugDepthSurfaceFigure.setVisible(true);
                v.getLightweightSystem3D().addDebugFigure((IFigure3D)this.debugDepthSurfaceFigure);
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("depthSurface=" + this.depthSurface + ", startSurface=" + this.startSurface);
            }
        } else {
            this.startWorldLocation = null;
            this.startSurface = null;
            this.startScreenLocation = null;
            this.depthSurface = null;
        }
        super.setStartLocation(i_p);
    }

    public void deactivate() {
        if (this.getCurrentViewer() instanceof GraphicalViewer3DImpl) {
            GraphicalViewer3DImpl v = (GraphicalViewer3DImpl)this.getCurrentViewer();
            v.getLightweightSystem3D().removeDebugFigure((IFigure3D)this.debugDepthSurfaceFigure);
        }
    }

    protected Request createTargetRequest() {
        String type = this.isCloneActive() ? "clone" : "move";
        ChangeBounds3DRequest cbr = new ChangeBounds3DRequest(type);
        cbr.setStartSurface(this.startSurface);
        return cbr;
    }

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.pushMouseEvent3D(me);
        try {
            this.getCurrentInput().setInput(me);
            this.getCurrentInput().setMouseButton(me.button, true);
            this.setStartLocation(new Point(me.x, me.y));
            this.handleButtonDown(me.button);
        }
        finally {
            this.popMouseEvent3D();
        }
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        this.pushMouseEvent3D(me);
        try {
            super.mouseDrag(me, viewer);
        }
        finally {
            this.popMouseEvent3D();
        }
    }

    IFigure3D getAncestor3D() {
        if (this.getSourceEditPart() instanceof GraphicalEditPart) {
            return Figure3DHelper.getAncestor3D((IFigure)((GraphicalEditPart)this.getSourceEditPart()).getFigure());
        }
        return null;
    }

    protected void updateTargetRequest() {
        super.updateTargetRequest();
        ChangeBounds3DRequest cbr = (ChangeBounds3DRequest)this.getTargetRequest();
        cbr.setMoveDepthDelta3D(IVector3f.NULLVEC3f);
        cbr.setRotationDelta3D(IVector3f.NULLVEC3f);
        cbr.setModifier3D(ChangeBounds3DRequest.Modifier3D.NONE);
        if (this.currentMouseEvent3D != null) {
            cbr.setLocation3D(this.currentMouseEvent3D.getWorldLocation());
            if (this.getCurrentInput().isModKeyDown(MODIFIER_3DDRAG)) {
                cbr.setModifier3D(this.getCurrentInput().isShiftKeyDown() ? ChangeBounds3DRequest.Modifier3D.ROTATION : ChangeBounds3DRequest.Modifier3D.DEPTH);
                cbr.setMoveDelta(NO_DELTA);
                cbr.setSizeDelta(NO_DELTA_SIZE);
                switch (cbr.getModifier3D()) {
                    case DEPTH: {
                        cbr.setMoveDepthDelta3D(this.computeDepthDelta3D());
                        break;
                    }
                    case ROTATION: {
                        cbr.setRotationDelta3D(this.computeRotationDelta3D());
                    }
                }
            }
        }
    }

    protected IVector3f computeMoveDelta3D() {
        Vector3f end = this.currentMouseEvent3D.computeWorldLocation(this.currentMouseEvent3D.getScreenLocation(), this.startSurface);
        Math3D.sub((IVector3f)end, (IVector3f)this.startWorldLocation, (Vector3f)end);
        return end;
    }

    protected IVector3f computeDepthDelta3D() {
        if (log.isLoggable(Level.INFO)) {
            log.info("compute depth with depthSurface=" + this.depthSurface);
        }
        Vector3f end = this.currentMouseEvent3D.computeWorldLocation(this.currentMouseEvent3D.getScreenLocation(), (ISurface)this.depthSurface);
        this.startSurface.getSurfaceLocation3D((IVector3f)end, end);
        if (log.isLoggable(Level.INFO)) {
            log.info("new depth: " + end.getZ());
        }
        end.setY(0.0f);
        end.setX(0.0f);
        return end;
    }

    protected IVector3f computeRotationDelta3D() {
        Dimension delta = this.currentMouseEvent3D.getScreenLocation().getDifference(this.startScreenLocation);
        Vector3fImpl rotationDelta = new Vector3fImpl();
        if ((float)Math.abs(delta.width) > ROTATION_THRESHOLD) {
            rotationDelta.setY(ROTATION_SENSITIVITY * ((float)delta.width - ROTATION_THRESHOLD));
        }
        if ((float)Math.abs(delta.height) > ROTATION_THRESHOLD) {
            rotationDelta.setX(ROTATION_SENSITIVITY * ((float)delta.height - ROTATION_THRESHOLD));
        }
        return rotationDelta;
    }
}

