/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.command;

import org.ascape.runtime.Runner;
import org.eclipse.amp.axf.time.ITimeGranularity;
import org.eclipse.amp.axf.time.TimeGranularity;
import org.eclipse.amp.escape.command.ResourceHandler;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class ExecuteHandler
extends ResourceHandler {
    private boolean headless;

    public ExecuteHandler(boolean headless) {
        this.setHeadless(headless);
    }

    @Override
    public final void execute(final Object executed, String name) throws ExecutionException {
        final EclipseEscapeRunner eclipseRunner = this.createRunner();
        if (this.isHeadless()) {
            eclipseRunner.setUpdateGranularity((ITimeGranularity)TimeGranularity.createFrequencyGranularity((int)Integer.MAX_VALUE));
        }
        Job escapeRun = new Job("Run " + name){

            protected IStatus run(IProgressMonitor monitor) {
                ExecuteHandler.this.setMonitor(monitor);
                eclipseRunner.setMonitor(monitor);
                try {
                    ExecuteHandler.this.executeOpen(eclipseRunner, executed, monitor);
                }
                catch (RuntimeException e) {
                    ExecuteHandler.this.setMonitor(null);
                    throw e;
                }
                ExecuteHandler.this.setMonitor(null);
                return eclipseRunner.getFinishStatus();
            }

            protected void canceling() {
                eclipseRunner.setFinishStatus(Status.CANCEL_STATUS);
                eclipseRunner.closeFinally();
            }
        };
        escapeRun.setPriority(30);
        escapeRun.schedule();
    }

    protected abstract void executeOpen(EclipseEscapeRunner var1, Object var2, IProgressMonitor var3);

    protected EclipseEscapeRunner createRunner() {
        Runner.setDisplayGraphics((!this.isHeadless() ? 1 : 0) != 0);
        return new EclipseEscapeRunner();
    }

    public void setEnabled(Object evaluationContext) {
        EvaluationContext ctx = (EvaluationContext)evaluationContext;
        Object selection = ctx.getVariable("selection");
        if (selection instanceof IStructuredSelection) {
            boolean enabled = false;
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss != null && ss.getFirstElement() != null) {
                Object fs = ss.getFirstElement();
                enabled = this.handleSelect(fs);
            }
            this.setBaseEnabled(enabled);
        }
    }

    protected abstract boolean handleSelect(Object var1);

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public boolean isHeadless() {
        return this.headless;
    }
}

